/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.util.ConcurrencyUtils;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    private static final long INTERVAL = 500L;
    private volatile ProgressBar progressBar = new ProgressBarBuilder().setStyle(ProgressBarStyle.ASCII).build().pause();
    private final AtomicInteger totalTasks = new AtomicInteger(0);
    private ThreadPoolExecutor executor;
    public static final int DEFAULT_THREAD_COUNT = Runtime.getRuntime().availableProcessors();

    public static TaskManager getInstance() {
        return SingletonHolder.instance;
    }

    private TaskManager() {
        this.init();
    }

    public void startProgress(String msg) {
        this.totalTasks.set(0);
        this.progressBar = new ProgressBarBuilder().setTaskName(msg).setStyle(ProgressBarStyle.ASCII).build();
    }

    public void stopProgress() {
        this.progressBar.close();
        this.totalTasks.set(0);
    }

    public void addTask(final Runnable task) {
        this.progressBar.maxHint((long)this.totalTasks.incrementAndGet());
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Exception e) {
                    log.error("Failed to execute task", (Throwable)e);
                }
                finally {
                    TaskManager.this.progressBar.step();
                }
            }
        });
    }

    public int getMaximumThreadCount() {
        return this.getExecutor().getMaximumPoolSize();
    }

    public synchronized void setMaximumThreadCount(int threads) {
        int curCoreSize;
        if (threads < 1) {
            threads = DEFAULT_THREAD_COUNT;
        }
        if (threads < (curCoreSize = this.executor.getCorePoolSize())) {
            this.executor.setCorePoolSize(threads);
        }
        this.executor.setMaximumPoolSize(threads);
        if (threads > curCoreSize) {
            this.executor.setCorePoolSize(threads);
        }
    }

    public synchronized void waitForAllTasksToComplete() throws InterruptedException {
        this.executor.shutdown();
        try {
            while (!this.executor.isTerminated()) {
                Thread.sleep(500L);
            }
        }
        finally {
            this.init();
        }
    }

    private void init() {
        this.executor = ConcurrencyUtils.getNewThreadPoolExecutor("ReportGenerator-pool-", DEFAULT_THREAD_COUNT);
    }

    private synchronized ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    private static class SingletonHolder {
        private static final TaskManager instance = new TaskManager();

        private SingletonHolder() {
        }
    }
}

