/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.net;

import com.xceptance.common.util.ssl.EasySSLUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;

public class UrlConnectionFactory {
    private int connectTimeout = -1;
    private boolean easySsl;
    private String password;
    private int readTimeout = -1;
    private String userName;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isEasySsl() {
        return this.easySsl;
    }

    public URLConnection open(URL url) throws IOException {
        URLConnection conn;
        URLConnection uRLConnection = conn = this.easySsl ? EasySSLUtils.openEasyConnection(url) : url.openConnection();
        if (this.connectTimeout >= 0) {
            conn.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            conn.setReadTimeout(this.readTimeout);
        }
        if (this.userName != null && this.password != null) {
            conn.setRequestProperty("Authorization", "Basic " + Base64.encodeBase64String((byte[])(this.userName + ":" + this.password).getBytes(StandardCharsets.ISO_8859_1)));
        }
        return conn;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setEasySsl(boolean easySsl) {
        this.easySsl = easySsl;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

