/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.xceptance.common.lang.StringUtils;
import com.xceptance.common.util.ParameterCheckUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParseUtils {
    private static final int TIME_BASE = 60;

    private ParseUtils() {
    }

    public static Class<?> parseClass(String className) throws ParseException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Failed to parse '" + className + "' as class name.", 0);
        }
    }

    @Deprecated
    public static URL parseURL(String urlString) throws ParseException {
        ParameterCheckUtils.isNotNullOrEmpty(urlString, "urlString");
        try {
            return new URL(urlString.trim());
        }
        catch (MalformedURLException e) {
            throw new ParseException("Failed to parse '" + urlString + "' as URL.", 0);
        }
    }

    public static URI parseURI(String urlString) throws ParseException {
        ParameterCheckUtils.isNotNullOrEmpty(urlString, "urlString");
        try {
            return new URI(urlString.trim());
        }
        catch (URISyntaxException e) {
            throw new ParseException("Failed to parse '" + urlString + "' as URI.", 0);
        }
    }

    public static int parseTimePeriod(String s) throws ParseException {
        ParameterCheckUtils.isNotNullOrEmpty(s, "s");
        String timeString = StringUtils.replaceAll(s, "\\s+", "");
        for (TimeFormat tFormat : TimeFormat.values()) {
            Matcher m = tFormat.getPattern().matcher(timeString);
            if (!m.matches()) continue;
            return tFormat.evaluate(m);
        }
        throw new ParseException(String.format("Unknown format of time period '%s'.", s), 0);
    }

    public static int parseRelativeTimePeriod(String s) throws ParseException {
        ParameterCheckUtils.isNotNullOrEmpty(s, "s");
        String timeString = s.trim();
        char operator = timeString.charAt(0);
        if (operator == '-' || operator == '+') {
            timeString = timeString.substring(1);
        }
        int time = ParseUtils.parseTimePeriod(timeString);
        if (operator == '-') {
            time *= -1;
        }
        return time;
    }

    public static int parseInt(String s) throws ParseException {
        ParameterCheckUtils.isNotNullOrEmpty(s, "s");
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(String.format("Failed to parse '%s' as integer.", s), 0);
        }
    }

    public static double parseDouble(String s) throws ParseException {
        ParameterCheckUtils.isNotNullOrEmpty(s, "s");
        try {
            return Double.parseDouble(s.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(String.format("Failed to parse '%s' as a double.", s), 0);
        }
    }

    public static int parseInt(String s, int defaultValue) {
        try {
            return ParseUtils.parseInt(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long parseLong(String s) throws ParseException {
        ParameterCheckUtils.isNotNullOrEmpty(s, "s");
        try {
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException fe) {
            throw new ParseException(String.format("Failed to parse '%s' as long.", s), 0);
        }
    }

    public static long parseLong(String s, long defaultValue) {
        try {
            return ParseUtils.parseLong(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static enum TimeFormat {
        NATURAL("(\\d+)s?"),
        ACCUMULATED("(\\d+h)?(\\d+m)?(\\d+s)?"),
        DIGIT("(?:(\\d+):)?([0-5]?\\d):([0-5]?\\d)");

        private final Pattern pattern;

        private TimeFormat(String s) {
            this.pattern = Pattern.compile(s);
        }

        private Pattern getPattern() {
            return this.pattern;
        }

        private int evaluate(Matcher matcher) throws ParseException {
            if (this.equals((Object)NATURAL)) {
                return ParseUtils.parseInt(matcher.group(1));
            }
            if (this.equals((Object)DIGIT)) {
                int groups;
                int time = 0;
                for (int i = groups = matcher.groupCount(); i > 0; --i) {
                    String group = matcher.group(i);
                    if (group == null || group.length() == 0) continue;
                    int timeVal = ParseUtils.parseInt(matcher.group(i));
                    time = (int)((double)time + (double)timeVal * Math.pow(60.0, groups - i));
                }
                return time;
            }
            if (this.equals((Object)ACCUMULATED)) {
                int time = 0;
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String group = matcher.group(i);
                    if (group == null || group.length() == 0) continue;
                    String s = group.substring(0, group.length() - 1);
                    int timeVal = ParseUtils.parseInt(s);
                    int exp = group.endsWith("h") ? 2 : (group.endsWith("m") ? 1 : 0);
                    time = (int)((double)time + (double)timeVal * Math.pow(60.0, exp));
                }
                return time;
            }
            return 0;
        }
    }
}

