/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import java.util.concurrent.atomic.AtomicInteger;

public class SynchronizingCounter {
    private final AtomicInteger count = new AtomicInteger();

    public SynchronizingCounter() {
        this(0);
    }

    public SynchronizingCounter(int initialValue) {
        this.count.set(initialValue);
    }

    public int add(int delta) {
        int last = this.count.addAndGet(delta);
        this.check(last);
        return last;
    }

    public synchronized void awaitZero() throws InterruptedException {
        while (this.count.get() > 0) {
            this.wait();
        }
    }

    public synchronized void awaitZero(long timeout) throws InterruptedException {
        long wakeUpTime = System.currentTimeMillis() + timeout;
        while (this.count.get() > 0 && System.currentTimeMillis() < wakeUpTime) {
            this.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(int value) {
        if (value <= 0) {
            SynchronizingCounter synchronizingCounter = this;
            synchronized (synchronizingCounter) {
                this.notifyAll();
            }
        }
    }

    public int decrement() {
        return this.add(-1);
    }

    public int get() {
        return this.count.get();
    }

    public int increment() {
        return this.add(1);
    }

    public void set(int value) {
        this.count.set(value);
        this.check(value);
    }
}

