/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.xlt.api.engine.AbstractData;
import com.xceptance.xlt.api.util.XltCharBuffer;
import java.util.List;

public class JvmResourceUsageData
extends AbstractData {
    private int blockedThreadCount;
    private long committedMemorySize;
    private double cpuUsage;
    private long fullGcCount;
    private int fullGcCountDiff;
    private double fullGcCpuUsage;
    private long fullGcTime;
    private int fullGcTimeDiff;
    private double heapUsage;
    private double memoryUsage;
    private long minorGcCount;
    private int minorGcCountDiff;
    private double minorGcCpuUsage;
    private long minorGcTime;
    private int minorGcTimeDiff;
    private int runnableThreadCount;
    private double totalCpuUsage;
    private long totalHeapSize;
    private long usedHeapSize;
    private int waitingThreadCount;

    public JvmResourceUsageData() {
        super('J');
    }

    public JvmResourceUsageData(String name) {
        super(name, 'J');
    }

    public int getBlockedThreadCount() {
        return this.blockedThreadCount;
    }

    public long getCommittedMemorySize() {
        return this.committedMemorySize;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public long getFullGcCount() {
        return this.fullGcCount;
    }

    public int getFullGcCountDiff() {
        return this.fullGcCountDiff;
    }

    public double getFullGcCpuUsage() {
        return this.fullGcCpuUsage;
    }

    public long getFullGcTime() {
        return this.fullGcTime;
    }

    public int getFullGcTimeDiff() {
        return this.fullGcTimeDiff;
    }

    public double getHeapUsage() {
        return this.heapUsage;
    }

    public double getMemoryUsage() {
        return this.memoryUsage;
    }

    public long getMinorGcCount() {
        return this.minorGcCount;
    }

    public int getMinorGcCountDiff() {
        return this.minorGcCountDiff;
    }

    public double getMinorGcCpuUsage() {
        return this.minorGcCpuUsage;
    }

    public long getMinorGcTime() {
        return this.minorGcTime;
    }

    public int getMinorGcTimeDiff() {
        return this.minorGcTimeDiff;
    }

    public int getRunnableThreadCount() {
        return this.runnableThreadCount;
    }

    public double getTotalCpuUsage() {
        return this.totalCpuUsage;
    }

    public long getTotalHeapSize() {
        return this.totalHeapSize;
    }

    public long getUsedHeapSize() {
        return this.usedHeapSize;
    }

    public int getWaitingThreadCount() {
        return this.waitingThreadCount;
    }

    public void setBlockedThreadCount(int blockedThreadCount) {
        this.blockedThreadCount = blockedThreadCount;
    }

    public void setCommittedMemorySize(long committedMemorySize) {
        this.committedMemorySize = committedMemorySize;
    }

    public void setCpuUsage(double cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public void setFullGcCount(long fullGcCount) {
        this.fullGcCount = fullGcCount;
    }

    public void setFullGcCountDiff(int fullGcCountDiff) {
        this.fullGcCountDiff = fullGcCountDiff;
    }

    public void setFullGcCpuUsage(double fullGcCpuUsage) {
        this.fullGcCpuUsage = fullGcCpuUsage;
    }

    public void setFullGcTime(long fullGcTime) {
        this.fullGcTime = fullGcTime;
    }

    public void setFullGcTimeDiff(int fullGcTimeDiff) {
        this.fullGcTimeDiff = fullGcTimeDiff;
    }

    public void setHeapUsage(double heapUsage) {
        this.heapUsage = heapUsage;
    }

    public void setMemoryUsage(double memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    public void setMinorGcCount(long minorGcCount) {
        this.minorGcCount = minorGcCount;
    }

    public void setMinorGcCountDiff(int minorGcCountDiff) {
        this.minorGcCountDiff = minorGcCountDiff;
    }

    public void setMinorGcCpuUsage(double minorGcCpuUsage) {
        this.minorGcCpuUsage = minorGcCpuUsage;
    }

    public void setMinorGcTime(long minorGcTime) {
        this.minorGcTime = minorGcTime;
    }

    public void setMinorGcTimeDiff(int minorGcTimeDiff) {
        this.minorGcTimeDiff = minorGcTimeDiff;
    }

    public void setRunnableThreadCount(int runnableThreadCount) {
        this.runnableThreadCount = runnableThreadCount;
    }

    public void setTotalCpuUsage(double totalCpuUsage) {
        this.totalCpuUsage = totalCpuUsage;
    }

    public void setTotalHeapSize(long totalHeapSize) {
        this.totalHeapSize = totalHeapSize;
    }

    public void setUsedHeapSize(long usedHeapSize) {
        this.usedHeapSize = usedHeapSize;
    }

    public void setWaitingThreadCount(int waitingThreadCount) {
        this.waitingThreadCount = waitingThreadCount;
    }

    @Override
    public List<String> toList() {
        List<String> fields = super.toList();
        fields.add(Double.toString(this.cpuUsage));
        fields.add(Long.toString(this.committedMemorySize));
        fields.add(Double.toString(this.memoryUsage));
        fields.add(Long.toString(this.usedHeapSize));
        fields.add(Long.toString(this.totalHeapSize));
        fields.add(Double.toString(this.heapUsage));
        fields.add(Integer.toString(this.runnableThreadCount));
        fields.add(Integer.toString(this.blockedThreadCount));
        fields.add(Integer.toString(this.waitingThreadCount));
        fields.add(Long.toString(this.minorGcCount));
        fields.add(Long.toString(this.minorGcTime));
        fields.add(Double.toString(this.minorGcCpuUsage));
        fields.add(Long.toString(this.fullGcCount));
        fields.add(Long.toString(this.fullGcTime));
        fields.add(Double.toString(this.fullGcCpuUsage));
        fields.add(Integer.toString(this.minorGcTimeDiff));
        fields.add(Integer.toString(this.fullGcTimeDiff));
        fields.add(Integer.toString(this.minorGcCountDiff));
        fields.add(Integer.toString(this.fullGcCountDiff));
        fields.add(Double.toString(this.totalCpuUsage));
        return fields;
    }

    @Override
    public void setRemainingValues(List<XltCharBuffer> values) {
        this.cpuUsage = Double.parseDouble(values.get(3).toString());
        this.committedMemorySize = Long.parseLong(values.get(4).toString());
        this.memoryUsage = Double.parseDouble(values.get(5).toString());
        this.usedHeapSize = Long.parseLong(values.get(6).toString());
        this.totalHeapSize = Long.parseLong(values.get(7).toString());
        this.heapUsage = Double.parseDouble(values.get(8).toString());
        if (values.size() >= 23) {
            this.runnableThreadCount = ParseNumbers.parseInt(values.get(9));
            this.blockedThreadCount = ParseNumbers.parseInt(values.get(10));
            this.waitingThreadCount = ParseNumbers.parseInt(values.get(11));
            this.minorGcCount = ParseNumbers.parseLong(values.get(12));
            this.minorGcTime = ParseNumbers.parseLong(values.get(13));
            this.minorGcCpuUsage = Double.parseDouble(values.get(14).toString());
            this.fullGcCount = ParseNumbers.parseLong(values.get(15));
            this.fullGcTime = ParseNumbers.parseLong(values.get(16));
            this.fullGcCpuUsage = Double.parseDouble(values.get(17).toString());
            this.minorGcTimeDiff = ParseNumbers.parseInt(values.get(18));
            this.fullGcTimeDiff = ParseNumbers.parseInt(values.get(19));
            this.minorGcCountDiff = ParseNumbers.parseInt(values.get(20));
            this.fullGcCountDiff = ParseNumbers.parseInt(values.get(21));
            this.totalCpuUsage = Double.parseDouble(values.get(22).toString());
        } else {
            if (values.size() >= 12) {
                this.runnableThreadCount = Integer.parseInt(values.get(9).toString());
                this.blockedThreadCount = Integer.parseInt(values.get(10).toString());
                this.waitingThreadCount = Integer.parseInt(values.get(11).toString());
            }
            if (values.size() >= 18) {
                this.minorGcCount = ParseNumbers.parseLong(values.get(12));
                this.minorGcTime = ParseNumbers.parseLong(values.get(13));
                this.minorGcCpuUsage = Double.parseDouble(values.get(14).toString());
                this.fullGcCount = ParseNumbers.parseLong(values.get(15));
                this.fullGcTime = ParseNumbers.parseLong(values.get(16));
                this.fullGcCpuUsage = Double.parseDouble(values.get(17).toString());
            }
            if (values.size() >= 20) {
                this.minorGcTimeDiff = ParseNumbers.parseInt(values.get(18));
                this.fullGcTimeDiff = ParseNumbers.parseInt(values.get(19));
            }
            if (values.size() >= 22) {
                this.minorGcCountDiff = ParseNumbers.parseInt(values.get(20));
                this.fullGcCountDiff = ParseNumbers.parseInt(values.get(21));
            }
            if (values.size() >= 23) {
                this.totalCpuUsage = Double.parseDouble(values.get(22).toString());
            }
        }
    }
}

