/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.actions;

import com.xceptance.common.lang.StringUtils;
import com.xceptance.xlt.api.actions.AbstractAction;
import com.xceptance.xlt.api.util.ResponseProcessor;
import com.xceptance.xlt.engine.XltWebClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.UrlUtils;

public abstract class AbstractWebAction
extends AbstractAction {
    protected static final List<NameValuePair> EMPTY_PARAMETER_LIST = Collections.emptyList();
    private XltWebClient webClient;

    protected AbstractWebAction(AbstractWebAction previousAction, String timerName) {
        super(previousAction, timerName);
        this.webClient = previousAction == null ? new XltWebClient() : (XltWebClient)previousAction.getWebClient();
        this.webClient.setTimerName(this.getTimerName());
    }

    protected AbstractWebAction(String timerName) {
        this(null, timerName);
    }

    public void addResponseProcessor(ResponseProcessor processor) {
        ((XltWebClient)this.getWebClient()).addResponseProcessor(processor);
    }

    public void closeWebClient() {
        if (this.webClient != null) {
            this.webClient.shutdown();
            this.webClient = null;
        }
    }

    @Override
    public AbstractWebAction getPreviousAction() {
        return (AbstractWebAction)super.getPreviousAction();
    }

    public WebClient getWebClient() {
        if (this.webClient == null) {
            throw new IllegalStateException("Cannot access the web client any longer since it has been closed explicitly.");
        }
        return this.webClient;
    }

    @Override
    public void run() throws Throwable {
        ((XltWebClient)this.getWebClient()).setTimerName(this.getTimerName());
        try {
            super.run();
        }
        finally {
            ((XltWebClient)this.getWebClient()).clearResponseProcessors();
        }
    }

    protected WebRequest createWebRequestSettings(URL url, HttpMethod method, List<NameValuePair> requestParameters) throws MalformedURLException {
        boolean methodIsHttpPost;
        String urlString = url.toString();
        urlString = StringUtils.replace(urlString, "&amp;", "&");
        URL newUrl = new URL(urlString);
        boolean thereAreRequestParameters = requestParameters != null && !requestParameters.isEmpty();
        boolean bl = methodIsHttpPost = method == HttpMethod.POST;
        if (thereAreRequestParameters && !methodIsHttpPost) {
            newUrl = this.buildNewUrl(newUrl, requestParameters);
        }
        WebRequest webRequest = new WebRequest(newUrl, method);
        if (thereAreRequestParameters && methodIsHttpPost) {
            webRequest.setRequestParameters(requestParameters);
        }
        return webRequest;
    }

    private URL buildNewUrl(URL newUrl, List<NameValuePair> requestParameters) throws MalformedURLException {
        boolean insertLeadingAmp;
        String oldQueryString = newUrl.getQuery();
        StringBuilder newQueryString = new StringBuilder();
        boolean bl = insertLeadingAmp = oldQueryString != null && !oldQueryString.isEmpty();
        if (insertLeadingAmp) {
            newQueryString.append(oldQueryString);
        }
        for (int index = 0; index < requestParameters.size(); ++index) {
            NameValuePair nameValuePair = requestParameters.get(index);
            if (index > 0 || insertLeadingAmp) {
                newQueryString.append('&');
            }
            newQueryString.append(nameValuePair.getName()).append('=').append(nameValuePair.getValue());
        }
        return UrlUtils.getUrlWithNewQuery(newUrl, newQueryString.toString());
    }
}

