/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.validators;

import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import org.htmlunit.html.HtmlPage;
import org.junit.Assert;

public class HttpResponseCodeValidator {
    private final int httpResponseCode;

    public HttpResponseCodeValidator(int httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }

    public HttpResponseCodeValidator() {
        this(200);
    }

    public void validate(HtmlPage page) {
        Assert.assertNotNull((String)"No html page available to validate the response code against", (Object)page);
        Assert.assertEquals((String)"Response code does not match", (long)this.httpResponseCode, (long)page.getWebResponse().getStatusCode());
    }

    public void validate(LightWeightPage page) {
        Assert.assertNotNull((String)"No html page available to validate the response code against", (Object)page);
        Assert.assertEquals((String)"Response code does not match", (long)this.httpResponseCode, (long)page.getHttpResponseCode());
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public static HttpResponseCodeValidator getInstance() {
        return HttpResponseCodeValidator_Singleton.instance;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpResponseCodeValidator other = (HttpResponseCodeValidator)obj;
        return this.httpResponseCode == other.httpResponseCode;
    }

    public int hashCode() {
        return (this.getClass().hashCode() & 0xFFFF) << 16 ^ this.httpResponseCode & 0xFFFF;
    }

    private static class HttpResponseCodeValidator_Singleton {
        private static final HttpResponseCodeValidator instance = new HttpResponseCodeValidator();

        private HttpResponseCodeValidator_Singleton() {
        }
    }
}

