/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.xceptance.xlt.engine.har.model.HarParam;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"mimeType", "params", "text", "comment"})
public class HarPostData {
    private final String mimeType;
    private final List<HarParam> params;
    private final String text;
    private final String comment;

    @JsonCreator
    public HarPostData(@JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="params") List<HarParam> params, @JsonProperty(value="text") String text, @JsonProperty(value="comment") String comment) {
        this.mimeType = mimeType;
        this.params = params;
        this.text = text;
        this.comment = comment;
    }

    public String getText() {
        return this.text;
    }

    public List<HarParam> getParams() {
        return this.params;
    }

    public String getComment() {
        return this.comment;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String toString() {
        return "HarPostData [text = " + this.text + ", params = " + this.params + ", comment = " + this.comment + ", mimeType = " + this.mimeType + "]";
    }

    public static class Builder {
        private String mimeType;
        private List<HarParam> params;
        private String text;
        private String comment;

        public Builder withMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder withParams(List<HarParam> params) {
            if (params != null) {
                this.text = null;
            }
            this.params = params;
            return this;
        }

        public Builder addParam(HarParam param) {
            if (this.params == null) {
                this.params = new ArrayList<HarParam>();
            }
            this.params.add(param);
            this.text = null;
            return this;
        }

        public Builder withText(String text) {
            if (text != null) {
                this.params = null;
            }
            this.text = text;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarPostData build() {
            return new HarPostData(this.mimeType, this.params, this.text, this.comment);
        }
    }
}

