/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.engine.resultbrowser.ActionInfo;
import com.xceptance.xlt.engine.resultbrowser.PageDOMClone;
import com.xceptance.xlt.engine.resultbrowser.PageWrapper;
import com.xceptance.xlt.engine.resultbrowser.Request;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.html.HtmlPage;

class Page {
    private ActionInfo actionInfo;
    private PageWrapper wrapper;
    private final String name;
    private byte[] pageImage;
    private final List<Request> requests = new ArrayList<Request>();

    public Page(String name, HtmlPage htmlPage) {
        this.name = name;
        this.wrapper = new PageWrapper(htmlPage);
    }

    public Page(String name, LightWeightPage page) {
        this.name = name;
        this.wrapper = new PageWrapper(page);
    }

    public Page(ActionInfo actionInfo, byte[] pageImage) {
        this.name = actionInfo.name;
        this.actionInfo = actionInfo;
        this.pageImage = pageImage;
    }

    public Page(String name) {
        this.name = name;
    }

    public final boolean isHtmlPage() {
        return this.wrapper != null && this.wrapper.isHtmlPage();
    }

    public final boolean isScreenshotPage() {
        return this.pageImage != null;
    }

    public final boolean isEmptyPage() {
        return this.pageImage == null && this.wrapper == null;
    }

    public final PageDOMClone getHtmlPage() {
        return this.wrapper == null ? null : this.wrapper.getHtmlPage();
    }

    public final LightWeightPage getLightWeightPage() {
        return this.wrapper == null ? null : this.wrapper.getLightWeightPage();
    }

    public final byte[] getScreenshotPage() {
        return this.pageImage;
    }

    public final String getName() {
        return this.name;
    }

    public final List<Request> getRequests() {
        return this.requests;
    }

    public ActionInfo getActionInfo() {
        return this.actionInfo;
    }
}

