/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.report.util.DoubleMinMaxValue;

public class DoubleMinMaxValueSet {
    public static final int DEFAULT_SIZE = 1024;
    private int firstSecond;
    private int lastSecond;
    private long maximumTime;
    private long minimumTime;
    private int scale = 1;
    private final int size;
    private long valueCount;
    private final DoubleMinMaxValue[] values;

    public DoubleMinMaxValueSet() {
        this(1024);
    }

    public DoubleMinMaxValueSet(int size) {
        ParameterCheckUtils.isGreaterThan(size, 0, "size");
        this.size = size * 2;
        this.values = new DoubleMinMaxValue[this.size];
    }

    public void addOrUpdateValue(long time, double value) {
        int second = (int)(time / 1000L) & ~(this.scale - 1);
        if (this.valueCount == 0L) {
            this.firstSecond = this.lastSecond = second;
            this.values[0] = new DoubleMinMaxValue(value);
            this.minimumTime = this.maximumTime = time;
            this.valueCount = 1L;
        } else {
            int index;
            DoubleMinMaxValue item;
            if (second != this.firstSecond) {
                if (second > this.firstSecond) {
                    while ((second - this.firstSecond) / this.scale >= this.size) {
                        this.scale *= 2;
                        this.shrink();
                        second &= ~(this.scale - 1);
                        this.firstSecond &= ~(this.scale - 1);
                        this.lastSecond &= ~(this.scale - 1);
                    }
                    if (second > this.lastSecond) {
                        this.lastSecond = second;
                    }
                } else {
                    while ((this.lastSecond - second) / this.scale >= this.size) {
                        this.scale *= 2;
                        this.shrink();
                        second &= ~(this.scale - 1);
                        this.firstSecond &= ~(this.scale - 1);
                        this.lastSecond &= ~(this.scale - 1);
                    }
                    if (second < this.firstSecond) {
                        int indexDiff = (this.firstSecond - second) / this.scale;
                        this.shift(indexDiff);
                        this.firstSecond = second;
                    }
                }
            }
            if ((item = this.values[index = (second - this.firstSecond) / this.scale]) == null) {
                this.values[index] = new DoubleMinMaxValue(value);
            } else {
                item.updateValue(value);
            }
            ++this.valueCount;
            if (time < this.minimumTime) {
                this.minimumTime = time;
            }
            if (time > this.maximumTime) {
                this.maximumTime = time;
            }
        }
    }

    public long getFirstSecond() {
        if (this.valueCount == 0L) {
            throw new IllegalStateException("No first second available as no values have been added so far.");
        }
        return this.firstSecond * 1000;
    }

    public long getMaximumTime() {
        if (this.valueCount == 0L) {
            throw new IllegalStateException("No maximum time available as no values have been added so far.");
        }
        return this.maximumTime;
    }

    public long getMinimumTime() {
        if (this.valueCount == 0L) {
            throw new IllegalStateException("No minimum time available as no values have been added so far.");
        }
        return this.minimumTime;
    }

    public int getScale() {
        return this.scale;
    }

    public int getSize() {
        return this.size / 2;
    }

    public long getValueCount() {
        return this.valueCount;
    }

    public DoubleMinMaxValue[] getValues() {
        DoubleMinMaxValue[] copy;
        if (this.valueCount == 0L) {
            copy = new DoubleMinMaxValue[]{};
        } else {
            int length = (this.lastSecond - this.firstSecond) / this.scale + 1;
            copy = new DoubleMinMaxValue[length];
            System.arraycopy(this.values, 0, copy, 0, length);
        }
        return copy;
    }

    private void shift(int indexDiff) {
        System.arraycopy(this.values, 0, this.values, indexDiff, this.size - indexDiff);
        for (int i = 0; i < indexDiff; ++i) {
            this.values[i] = null;
        }
    }

    private void shrink() {
        int offset;
        int i = offset = this.firstSecond % this.scale > 0 ? 1 : 0;
        int j = offset;
        while (i < this.size - 1) {
            DoubleMinMaxValue v1 = this.values[i];
            DoubleMinMaxValue v2 = this.values[i + 1];
            DoubleMinMaxValue rv = v1 != null && v2 != null ? v1.merge(v2) : (v1 != null && v2 == null ? v1 : (v1 == null && v2 != null ? v2 : null));
            this.values[i] = null;
            this.values[i + 1] = null;
            this.values[j] = rv;
            i += 2;
            ++j;
        }
        if (i < this.size) {
            this.values[j] = this.values[i];
            this.values[i] = null;
        }
    }
}

