/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.common.io.FileUtils;
import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.report.util.DoubleMinMaxValue;
import com.xceptance.xlt.report.util.DoubleMinMaxValueSet;
import com.xceptance.xlt.report.util.DoubleSummaryStatistics;
import com.xceptance.xlt.report.util.ElementSpecification;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.math3.util.Precision;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ReportUtils {
    public static final String XPATH_PROJECT_NAME = "/testreport/configuration/projectName";
    public static final int DEFAULT_DECIMAL_PLACES = 3;

    private ReportUtils() {
    }

    public static BigDecimal convertToBigDecimal(double value) {
        return ReportUtils.convertToBigDecimal(value, 3);
    }

    public static BigDecimal convertToBigDecimal(double value, int decimalPlaces) {
        ParameterCheckUtils.isNotNegative(decimalPlaces, "decimalPlaces");
        if (Double.isNaN(value)) {
            value = 0.0;
        }
        return BigDecimal.valueOf(value).setScale(decimalPlaces, RoundingMode.HALF_EVEN);
    }

    public static Element addTextElement(String tagName, String textContent, Element parent) {
        Element element = parent.getOwnerDocument().createElement(tagName);
        element.setTextContent(textContent);
        parent.appendChild(element);
        return element;
    }

    public static List<Node> evaluateXpathAsNodeSet(Node node, String xpathExpression) {
        try {
            DOMXPath path = new DOMXPath(xpathExpression);
            return path.selectNodes((Object)node);
        }
        catch (JaxenException e) {
            throw new XltException("Failed to evaluate XPath expression: " + xpathExpression, e);
        }
    }

    public static String evaluateXpathAsString(Node node, String xpathExpression) {
        return ReportUtils.evaluateXpathAsNodeSet(node, xpathExpression).get(0).getTextContent();
    }

    public static Map<String, Element> filterElements(Document document, ElementSpecification spec) {
        LinkedHashMap<String, Element> elementsByName = new LinkedHashMap<String, Element>();
        List<Node> elements = ReportUtils.evaluateXpathAsNodeSet(document, spec.rootElementXpath);
        for (Node node : elements) {
            Element element = (Element)node;
            String elementId = spec.idElementTagName == null ? element.getTagName() : ReportUtils.getChildElementText(element, spec.idElementTagName);
            elementsByName.put(elementId, element);
        }
        return elementsByName;
    }

    public static String formatValue(Double value) {
        return value == null ? "null" : String.valueOf(Precision.round((double)value, (int)3));
    }

    public static String formatValue(double value) {
        long valueAsLong = (long)value;
        return value == (double)valueAsLong ? String.valueOf(valueAsLong) : String.valueOf(value);
    }

    public static Date getAsDate(Node node, String xpath) throws ParseException {
        String result = ReportUtils.getAsString(node, xpath);
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z", Locale.ENGLISH).parse(result);
    }

    public static String getAsString(Node node, String xpath) {
        return ReportUtils.evaluateXpathAsString(node, xpath);
    }

    public static String getChildElementText(Node node, String tagName) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element element;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !(element = (Element)childNode).getTagName().equals(tagName)) continue;
            return element.getTextContent();
        }
        throw new XltException("No child element found with tag name: " + tagName);
    }

    public static double getChildElementTextAsDouble(Node node, String tagName) {
        String result = ReportUtils.getChildElementText(node, tagName);
        return Double.parseDouble(result);
    }

    public static int getChildElementTextAsInt(Node node, String tagName) {
        String result = ReportUtils.getChildElementText(node, tagName);
        return Integer.parseInt(result);
    }

    public static String toString(File file) {
        return SystemUtils.IS_OS_WINDOWS ? file.getAbsolutePath() : FileUtils.toUri(file).toString();
    }

    public static DoubleSummaryStatistics toSummaryStatistics(DoubleMinMaxValueSet valueSet) {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        for (DoubleMinMaxValue value : valueSet.getValues()) {
            if (value == null) continue;
            stats.addValue(value.getAverageValue());
        }
        return stats;
    }

    public static String obtainProjectName(Iterable<Document> documents) {
        String projectName = null;
        for (Document doc : documents) {
            String pName;
            List<Node> matches = ReportUtils.evaluateXpathAsNodeSet(doc, XPATH_PROJECT_NAME);
            if (matches.isEmpty() || !StringUtils.isNotBlank((CharSequence)(pName = matches.get(0).getTextContent()))) continue;
            projectName = pName;
        }
        return StringUtils.defaultString(projectName);
    }

    public static BigDecimal calculatePercentage(int count, int total) {
        if (total == 0) {
            return new BigDecimal(0);
        }
        return ReportUtils.convertToBigDecimal((double)count * 100.0 / (double)total);
    }
}

