/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.css;

import java.util.Iterator;
import java.util.Map;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.css.AbstractCssStyleDeclaration;
import org.htmlunit.css.StyleAttributes;
import org.htmlunit.css.StyleElement;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.html.DomElement;
import org.htmlunit.util.StringUtils;

public class ElementCssStyleDeclaration
extends AbstractCssStyleDeclaration {
    private final DomElement domElement_;

    public ElementCssStyleDeclaration(DomElement domElement) {
        if (domElement == null) {
            throw new IllegalStateException("domElement can't be null");
        }
        this.domElement_ = domElement;
    }

    @Override
    public String getStylePriority(String name) {
        StyleElement element = this.domElement_.getStyleElement(name);
        if (element != null && element.getValue() != null) {
            return element.getPriority();
        }
        return "";
    }

    @Override
    public String getCssText() {
        return this.domElement_.getAttributeDirect("style");
    }

    @Override
    public String getStyleAttribute(String name) {
        StyleElement element = this.getStyleElement(name);
        if (element != null && element.getValue() != null) {
            String value = element.getValue();
            if (!value.contains("url")) {
                return StringUtils.toRootLowerCase(value);
            }
            return value;
        }
        return "";
    }

    @Override
    public String getStyleAttribute(StyleAttributes.Definition definition, boolean getDefaultValueIfEmpty) {
        return this.getStyleAttribute(definition.getAttributeName());
    }

    @Override
    public void setCssText(String value) {
        this.domElement_.setAttribute("style", value);
    }

    @Override
    public void setStyleAttribute(String name, String newValue, String important) {
        this.domElement_.replaceStyleAttribute(name, newValue, important);
    }

    @Override
    public String removeStyleAttribute(String name) {
        return this.domElement_.removeStyleAttribute(name);
    }

    @Override
    public int getLength() {
        return this.domElement_.getStyleMap().size();
    }

    @Override
    public String item(int index) {
        if (index < 0) {
            return "";
        }
        int i = 0;
        Iterator<StyleElement> values = this.domElement_.getStyleMap().values().iterator();
        while (values.hasNext()) {
            if (index == i) {
                return values.next().getName();
            }
            values.next();
            ++i;
        }
        return "";
    }

    @Override
    public AbstractCSSRuleImpl getParentRule() {
        return null;
    }

    @Override
    public StyleElement getStyleElement(String name) {
        return this.domElement_.getStyleElement(name);
    }

    @Override
    public StyleElement getStyleElementCaseInSensitive(String name) {
        return this.domElement_.getStyleElementCaseInSensitive(name);
    }

    @Override
    public Map<String, StyleElement> getStyleMap() {
        return this.domElement_.getStyleMap();
    }

    public DomElement getDomElement() {
        return this.domElement_;
    }

    @Override
    public boolean hasFeature(BrowserVersionFeatures property) {
        return this.domElement_.hasFeature(property);
    }

    @Override
    public BrowserVersion getBrowserVersion() {
        return this.domElement_.getPage().getWebClient().getBrowserVersion();
    }

    public String toString() {
        return "ElementCssStyleDeclaration for '" + this.getDomElement() + "'";
    }
}

