/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import org.htmlunit.Page;
import org.htmlunit.StringWebResponse;
import org.htmlunit.WebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.WebWindowImpl;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.HtmlPage;

public class FrameWindow
extends WebWindowImpl {
    private final BaseFrameElement frame_;
    private PageDenied pageDenied_;

    FrameWindow(BaseFrameElement frame) {
        super(frame.getPage().getWebClient());
        this.frame_ = frame;
        this.performRegistration();
        WebWindowImpl parent = (WebWindowImpl)this.frame_.getPage().getEnclosingWindow();
        parent.addChildWindow(this);
    }

    @Override
    public String getName() {
        return this.frame_.getNameAttribute();
    }

    @Override
    public void setName(String name) {
        this.frame_.setNameAttribute(name);
    }

    @Override
    public WebWindow getParentWindow() {
        return this.frame_.getPage().getEnclosingWindow();
    }

    @Override
    public WebWindow getTopWindow() {
        return this.getParentWindow().getTopWindow();
    }

    @Override
    protected boolean isJavaScriptInitializationNeeded(Page page) {
        return this.getScriptableObject() == null || !(page.getWebResponse() instanceof StringWebResponse) || !((StringWebResponse)page.getWebResponse()).isFromJavascript();
    }

    public HtmlPage getEnclosingPage() {
        return (HtmlPage)this.frame_.getPage();
    }

    @Override
    public void setEnclosedPage(Page page) {
        StringWebResponse response;
        this.setPageDenied(PageDenied.NONE);
        super.setEnclosedPage(page);
        WebResponse webResponse = page.getWebResponse();
        if (webResponse instanceof StringWebResponse && (response = (StringWebResponse)webResponse).isFromJavascript()) {
            BaseFrameElement frame = this.getFrameElement();
            frame.setContentLoaded();
        }
    }

    public BaseFrameElement getFrameElement() {
        return this.frame_;
    }

    public String toString() {
        return "FrameWindow[name=\"" + this.getName() + "\"]";
    }

    public void close() {
        WebWindowImpl parent = (WebWindowImpl)this.getParentWindow();
        parent.removeChildWindow(this);
        this.getWebClient().deregisterWebWindow(this);
    }

    public void setPageDenied(PageDenied pageDenied) {
        this.pageDenied_ = pageDenied;
    }

    public PageDenied getPageDenied() {
        return this.pageDenied_;
    }

    public static enum PageDenied {
        NONE,
        BY_X_FRAME_OPTIONS,
        BY_CONTENT_SECURIRY_POLICY;

    }
}

