/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.css.CSSGroupingRule;
import org.htmlunit.javascript.host.css.CSSRule;
import org.htmlunit.javascript.host.css.CSSStyleSheet;

@JsxClass
public class CSSRuleList
extends HtmlUnitScriptable {
    private final List<CSSRule> rules_ = new ArrayList<CSSRule>();

    public CSSRuleList() {
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        throw JavaScriptEngine.reportRuntimeError("Illegal constructor.");
    }

    public CSSRuleList(CSSStyleSheet stylesheet) {
        this.setParentScope(stylesheet.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public CSSRuleList(CSSGroupingRule groupingRule) {
        this.setParentScope(groupingRule.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    protected void addRule(CSSRule rule) {
        this.rules_.add(rule);
    }

    protected void clearRules() {
        this.rules_.clear();
    }

    @JsxGetter
    public int getLength() {
        return this.rules_.size();
    }

    @JsxFunction
    public Object item(int index) {
        return this.get(index, (Scriptable)this);
    }

    public Object[] getIds() {
        ArrayList<String> idList = new ArrayList<String>();
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            idList.add(Integer.toString(i));
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CSSRULELIST_ENUM_ITEM_LENGTH)) {
            idList.add("item");
            idList.add("length");
        } else {
            idList.add("length");
            idList.add("item");
        }
        return idList.toArray();
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.getLength();
    }

    public boolean has(String name, Scriptable start) {
        if ("length".equals(name) || "item".equals(name)) {
            return true;
        }
        try {
            return this.has(Integer.parseInt(name), start);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object get(int index, Scriptable start) {
        if (index < 0 || this.getLength() <= index) {
            return NOT_FOUND;
        }
        return this.rules_.get(index);
    }
}

