/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlOptionGroup;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLFormElement;
import org.xml.sax.helpers.AttributesImpl;

@JsxClass(domClass=HtmlOption.class)
public class HTMLOptionElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor(Object newText, String newValue, boolean defaultSelected, boolean selected) {
        SgmlPage page = (SgmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        AttributesImpl attributes = null;
        if (defaultSelected) {
            attributes = new AttributesImpl();
            attributes.addAttribute(null, "selected", "selected", null, "selected");
        }
        HtmlOption htmlOption = (HtmlOption)page.getWebClient().getPageCreator().getHtmlParser().getFactory("option").createElement(page, "option", attributes);
        htmlOption.setSelected(selected);
        this.setDomNode(htmlOption);
        if (!JavaScriptEngine.isUndefined(newText)) {
            String newTextString = JavaScriptEngine.toString(newText);
            htmlOption.appendChild(new DomText(page, newTextString));
            htmlOption.setLabelAttribute(newTextString);
        }
        if (!"undefined".equals(newValue)) {
            htmlOption.setValueAttribute(newValue);
        }
    }

    public void jsConstructorOption(Object newText, String newValue, boolean defaultSelected, boolean selected) {
        this.jsConstructor(newText, newValue, defaultSelected, selected);
    }

    @Override
    @JsxGetter
    public String getValue() {
        String value = this.getDomNodeOrNull().getAttributeDirect("value");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value) {
            value = ((HtmlOption)this.getDomNodeOrNull()).getText();
        }
        return value;
    }

    @JsxSetter
    public void setValue(String newValue) {
        HtmlElement dom = this.getDomNodeOrNull();
        if (dom instanceof HtmlOption) {
            ((HtmlOption)dom).setValueAttribute(newValue);
        }
    }

    @JsxGetter
    public String getText() {
        HtmlElement dom = this.getDomNodeOrNull();
        if (dom instanceof HtmlOption) {
            return ((HtmlOption)dom).getText();
        }
        return null;
    }

    @JsxSetter
    public void setText(String newText) {
        HtmlElement dom = this.getDomNodeOrNull();
        if (dom instanceof HtmlOption) {
            ((HtmlOption)dom).setText(newText);
            if (!this.hasAttribute("label")) {
                this.setLabel(newText);
            }
        }
    }

    @JsxGetter
    public boolean isSelected() {
        HtmlElement dom = this.getDomNodeOrNull();
        if (dom instanceof HtmlOption) {
            return ((HtmlOption)dom).isSelected();
        }
        return false;
    }

    @JsxSetter
    public void setSelected(boolean selected) {
        HtmlOption optionNode = (HtmlOption)this.getDomNodeOrNull();
        HtmlSelect enclosingSelect = optionNode.getEnclosingSelect();
        if (!selected && optionNode.isSelected() && enclosingSelect != null && enclosingSelect.getSize() <= 1 && !enclosingSelect.isMultipleSelectEnabled()) {
            enclosingSelect.getOption(0).setSelectedFromJavaScript(true);
            return;
        }
        optionNode.setSelectedFromJavaScript(selected);
    }

    @JsxGetter
    public boolean isDefaultSelected() {
        HtmlElement dom = this.getDomNodeOrNull();
        if (dom instanceof HtmlOption) {
            return ((HtmlOption)dom).isDefaultSelected();
        }
        return false;
    }

    @JsxGetter
    public String getLabel() {
        HtmlElement domNode = this.getDomNodeOrNull();
        if (domNode instanceof HtmlOption) {
            return ((HtmlOption)domNode).getLabelAttribute();
        }
        return ((HtmlOptionGroup)domNode).getLabelAttribute();
    }

    @JsxSetter
    public void setLabel(String label) {
        HtmlElement domNode = this.getDomNodeOrNull();
        if (domNode instanceof HtmlOption) {
            ((HtmlOption)domNode).setLabelAttribute(label);
        } else {
            ((HtmlOptionGroup)domNode).setLabelAttribute(label);
        }
    }

    @Override
    @JsxGetter
    public boolean isDisabled() {
        return super.isDisabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }

    @JsxGetter
    public int getIndex() {
        HtmlSelect enclosingSelect;
        HtmlOption optionNode = (HtmlOption)this.getDomNodeOrNull();
        if (optionNode != null && (enclosingSelect = optionNode.getEnclosingSelect()) != null) {
            return enclosingSelect.indexOf(optionNode);
        }
        return 0;
    }

    @Override
    public void setAttribute(String name, String value) {
        super.setAttribute(name, value);
        if ("selected".equals(name)) {
            this.setSelected(true);
        }
    }

    @Override
    public void removeAttribute(String name) {
        super.removeAttribute(name);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLOPTION_REMOVE_SELECTED_ATTRIB_DESELECTS) && "selected".equals(name)) {
            this.setSelected(false);
        }
    }

    @Override
    @JsxGetter
    public HTMLFormElement getForm() {
        HtmlForm form = this.getDomNodeOrDie().getEnclosingForm();
        if (form == null) {
            return null;
        }
        return (HTMLFormElement)this.getScriptableFor(form);
    }
}

