/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.data;

import com.xceptance.xlt.api.data.DataProvider;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.util.XltRandom;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class GeneralDataProvider {
    private static final char SPACE = ' ';
    private static final char AT = '@';
    private static final Pattern uuidCleanerPattern = Pattern.compile("-");

    private GeneralDataProvider() {
    }

    private DataProvider getDataProvider(DataCategory name) {
        try {
            return DataProvider.getInstance(name.getFileName());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize data provider", e);
        }
    }

    private String getNextItem(DataCategory category, boolean removeWhitespace) {
        DataProvider provider = this.getDataProvider(category);
        return provider.getRandomRow(removeWhitespace);
    }

    public String getCompany(boolean removeWhitespace) {
        return this.getNextItem(DataCategory.COMPANIES, removeWhitespace);
    }

    public String getCountry(boolean removeWhitespace) {
        return this.getNextItem(DataCategory.COUNTRIES, removeWhitespace);
    }

    public String getFirstName(boolean removeWhitespace) {
        return this.getNextItem(DataCategory.FIRSTNAMES, removeWhitespace);
    }

    public String getTown(boolean removeWhitespace) {
        return this.getNextItem(DataCategory.TOWNS, removeWhitespace);
    }

    public String getLastName(boolean removeWhitespace) {
        return this.getNextItem(DataCategory.LASTNAMES, removeWhitespace);
    }

    public String getSentence(boolean removeWhitespace) {
        return this.getNextItem(DataCategory.SENTENCES, removeWhitespace);
    }

    public String getText(int sentenceCount, boolean removeWhitespace) {
        DataProvider provider = this.getDataProvider(DataCategory.SENTENCES);
        if (provider.getSize() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < sentenceCount; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(provider.getRandomRow(false));
        }
        return removeWhitespace ? StringUtils.deleteWhitespace((String)sb.toString()) : sb.toString();
    }

    public String getText(int minSentenceCount, int maxSentenceCount, boolean removeWhitespace) {
        int sentenceCount = XltRandom.nextInt(minSentenceCount, maxSentenceCount);
        return this.getText(sentenceCount, removeWhitespace);
    }

    private String getDynamicDomain() {
        long now = GlobalClock.get().millis();
        return "xlt" + now + ".com";
    }

    public String getEmail() {
        return (this.getLastName(true) + "@" + this.getDynamicDomain()).toLowerCase();
    }

    public String getPredefinedEmail() {
        return this.getNextItem(DataCategory.EMAILS, false);
    }

    @Deprecated
    public String getEmail(String name, boolean removeWhitespace) {
        return this.getEmail(name);
    }

    public String getEmail(String name) {
        String cleanName = StringUtils.deleteWhitespace((String)name);
        String emailAddress = (cleanName + '@' + this.getDynamicDomain()).toLowerCase();
        return emailAddress;
    }

    public String getUniqueEmail(String prefix, String domain, int length) {
        String p = StringUtils.defaultString((String)StringUtils.deleteWhitespace((String)prefix));
        int remainingLength = Math.min(Math.max(0, length - p.length()), 32);
        String uuid = uuidCleanerPattern.matcher(UUID.randomUUID().toString()).replaceAll("");
        return p + uuid.substring(0, remainingLength) + '@' + domain;
    }

    public String getUniqueEmail(String domain) {
        return this.getUniqueEmail("x", domain, 20);
    }

    public String getStreet(boolean removeWhitespace) {
        return this.getNextItem(DataCategory.STREETS, removeWhitespace);
    }

    public String getZip(int length) {
        return RandomStringUtils.randomNumeric((int)length);
    }

    public String getUniqueUserName() {
        UUID uuid = UUID.randomUUID();
        return StringUtils.substring((String)("user" + uuid.toString()), (int)0, (int)20);
    }

    public String getUSPhoneNumber() {
        int prefix = XltRandom.nextInt(200, 999);
        int infix = XltRandom.nextInt(200, 999);
        String suffix = RandomStringUtils.randomNumeric((int)4);
        return "1-" + prefix + "-" + infix + "-" + suffix;
    }

    public String getDEPhoneNumber() {
        String prefix = RandomStringUtils.randomNumeric((int)3);
        String suffix = RandomStringUtils.randomNumeric((int)6);
        return "0" + prefix + "-" + suffix;
    }

    public static GeneralDataProvider getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final GeneralDataProvider INSTANCE = new GeneralDataProvider();

        private SingletonHolder() {
        }
    }

    private static enum DataCategory {
        COMPANIES,
        COUNTRIES,
        FIRSTNAMES,
        LASTNAMES,
        EMAILS,
        SENTENCES,
        STREETS,
        TOWNS;

        private String fileName = null;

        private DataCategory(String fileName) {
            this.fileName = fileName;
        }

        private DataCategory() {
            this(null);
        }

        String getFileName() {
            if (this.fileName != null) {
                return this.fileName;
            }
            return "default" + File.separator + this.name().toLowerCase() + ".txt";
        }
    }
}

