/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.report;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.util.SimpleArrayList;
import java.util.List;

public class PostProcessedDataContainer {
    public final List<Data> data;
    public int droppedLines;
    public final int sampleFactor;
    private long maximumTime = 0L;
    private long minimumTime = Long.MAX_VALUE;

    public PostProcessedDataContainer(int size, int sampleFactor) {
        this.data = new SimpleArrayList<Data>(size);
        this.sampleFactor = sampleFactor;
    }

    public List<Data> getData() {
        return this.data;
    }

    public void add(Data d) {
        this.data.add(d);
        long time = d.getTime();
        this.minimumTime = Math.min(this.minimumTime, time);
        this.maximumTime = Math.max(this.maximumTime, time);
    }

    public final long getMaximumTime() {
        return this.maximumTime;
    }

    public final long getMinimumTime() {
        return this.minimumTime == Long.MAX_VALUE ? 0L : this.minimumTime;
    }
}

