/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit.okhttp3;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.htmlunit.WebRequest;

class RetrieveFinalRequestHeadersInterceptor
implements Interceptor {
    private final WebRequest webRequest;

    RetrieveFinalRequestHeadersInterceptor(WebRequest webRequest) {
        this.webRequest = webRequest;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.webRequest.setAdditionalHeaders(RetrieveFinalRequestHeadersInterceptor.toMap(request.headers()));
        return chain.proceed(request);
    }

    private static Map<String, String> toMap(Headers okHttpHeaders) {
        LinkedHashMap<String, String> htmlUnitHeaders = new LinkedHashMap<String, String>();
        for (int i = 0; i < okHttpHeaders.size(); ++i) {
            htmlUnitHeaders.put(okHttpHeaders.name(i), okHttpHeaders.value(i));
        }
        return htmlUnitHeaders;
    }
}

