/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.resultbrowser.DomUtils;
import com.xceptance.xlt.engine.resultbrowser.PageDOMClone;
import org.htmlunit.html.HtmlPage;

class PageWrapper {
    private static final boolean DELAY_CLONING;
    private static final String ONERROR_DUMP_MODE = "com.xceptance.xlt.output2disk.onError.dumpMode";
    private static final String FINAL_PAGES_ONLY = "finalPagesOnly";
    private static final String MODIFIED_AND_FINAL_PAGES = "modifiedAndFinalPages";
    private PageDOMClone page;
    private final LightWeightPage lwPage;
    private final HtmlPage htmlPage;

    public PageWrapper(LightWeightPage lwPage) {
        this.lwPage = lwPage;
        this.page = null;
        this.htmlPage = null;
    }

    public PageWrapper(HtmlPage page) {
        this.lwPage = null;
        if (DELAY_CLONING) {
            this.page = null;
            this.htmlPage = page;
        } else {
            this.page = DomUtils.clonePage(page);
            this.htmlPage = null;
        }
    }

    public final boolean isHtmlPage() {
        return this.lwPage == null;
    }

    public final PageDOMClone getHtmlPage() {
        if (this.page == null && this.htmlPage != null) {
            this.page = DomUtils.clonePage(this.htmlPage);
        }
        return this.page;
    }

    public final LightWeightPage getLightWeightPage() {
        return this.lwPage;
    }

    public int hashCode() {
        if (this.lwPage != null) {
            return this.lwPage.hashCode();
        }
        if (this.page != null) {
            return this.page.hashCode();
        }
        if (this.htmlPage != null) {
            return this.htmlPage.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return o != null && this.hashCode() == o.hashCode();
    }

    static {
        XltProperties props = XltProperties.getInstance();
        DELAY_CLONING = !props.getProperty(ONERROR_DUMP_MODE, FINAL_PAGES_ONLY).equals(MODIFIED_AND_FINAL_PAGES);
    }
}

