/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.webdriver;

import com.xceptance.xlt.engine.scripting.util.TextMatchingUtils;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

class OptionFinder {
    private final Map<String, OptionLookupStrategy> strategies = new HashMap<String, OptionLookupStrategy>();

    OptionFinder() {
        LabelStrategy labelStrategy = new LabelStrategy();
        this.strategies.put("implicit", labelStrategy);
        this.strategies.put("id", new IdStrategy());
        this.strategies.put("index", new IndexStrategy());
        this.strategies.put("label", labelStrategy);
        this.strategies.put("value", new ValueStrategy());
    }

    WebElement findOption(WebElement select, String optionLocator) {
        return this.findOptions(select, optionLocator).get(0);
    }

    List<WebElement> findOptions(WebElement select, String optionLocator) {
        String value;
        String strategyName;
        Matcher m = WebDriverFinder.STRATEGY_PATTERN.matcher(optionLocator);
        if (m.matches()) {
            strategyName = m.group(1);
            value = m.group(2);
        } else {
            strategyName = "implicit";
            value = optionLocator;
        }
        OptionLookupStrategy strategy = this.strategies.get(strategyName);
        if (strategy == null) {
            throw new InvalidSelectorException("Unsupported option locator strategy: " + strategyName);
        }
        List<WebElement> options = strategy.find(select, value);
        if (options.size() == 0) {
            throw new NoSuchElementException("No option found for option locator: " + optionLocator);
        }
        return options;
    }

    private static abstract class OptionLookupStrategy {
        private OptionLookupStrategy() {
        }

        protected abstract List<WebElement> find(WebElement var1, String var2);

        protected List<WebElement> getOptionElements(WebElement select) {
            return select.findElements(By.tagName((String)"option"));
        }
    }

    private static final class ValueStrategy
    extends OptionLookupStrategy {
        private ValueStrategy() {
        }

        @Override
        protected List<WebElement> find(WebElement select, String valuePattern) {
            ArrayList<WebElement> options = new ArrayList<WebElement>();
            for (WebElement o : this.getOptionElements(select)) {
                String value = StringUtils.defaultString((String)o.getAttribute("value"));
                if (!TextMatchingUtils.isAMatch(value, valuePattern, true, false)) continue;
                options.add(o);
            }
            return options;
        }
    }

    private static final class LabelStrategy
    extends OptionLookupStrategy {
        private LabelStrategy() {
        }

        @Override
        protected List<WebElement> find(WebElement select, String textPattern) {
            ArrayList<WebElement> options = new ArrayList<WebElement>();
            for (WebElement o : this.getOptionElements(select)) {
                if (!TextMatchingUtils.isAMatch(o.getText(), textPattern, true, true)) continue;
                options.add(o);
            }
            return options;
        }
    }

    private static final class IndexStrategy
    extends OptionLookupStrategy {
        private IndexStrategy() {
        }

        @Override
        protected List<WebElement> find(WebElement select, String index) {
            ArrayList<WebElement> options = new ArrayList<WebElement>();
            try {
                int idx = Integer.parseInt(index);
                List<WebElement> optionElements = this.getOptionElements(select);
                options.add(optionElements.get(idx));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return options;
        }
    }

    private static final class IdStrategy
    extends OptionLookupStrategy {
        private IdStrategy() {
        }

        @Override
        protected List<WebElement> find(WebElement select, String id) {
            ArrayList<WebElement> options = new ArrayList<WebElement>();
            for (WebElement o : this.getOptionElements(select)) {
                if (!id.equals(o.getAttribute("id"))) continue;
                options.add(o);
            }
            return options;
        }
    }
}

