/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import org.htmlunit.Page;
import org.htmlunit.WebWindow;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;

public class HtmlUnitWindow
implements WebDriver.Window {
    private static final int SCROLLBAR_WIDTH = 8;
    private static final int HEADER_HEIGHT = 150;
    private final WebWindow webWindow_;
    private final Dimension initialWindowDimension_;
    private Point windowPosition_;

    public HtmlUnitWindow(WebWindow webWindow) {
        this.webWindow_ = webWindow;
        this.windowPosition_ = this.getBasePoint();
        this.initialWindowDimension_ = new Dimension(this.webWindow_.getOuterWidth(), this.webWindow_.getOuterHeight());
    }

    public WebWindow getWebWindow() {
        return this.webWindow_;
    }

    public void setSize(Dimension targetSize) {
        WebWindow topWindow = this.webWindow_.getTopWindow();
        int width = targetSize.getWidth();
        if (width < 8) {
            width = 8;
        }
        topWindow.setOuterWidth(width);
        topWindow.setInnerWidth(width - 8);
        int height = targetSize.getHeight();
        if (height < 150) {
            height = 150;
        }
        topWindow.setOuterHeight(height);
        topWindow.setInnerHeight(height - 150);
    }

    public void setPosition(Point targetPosition) {
        this.windowPosition_ = targetPosition;
    }

    public Dimension getSize() {
        WebWindow topWindow = this.webWindow_.getTopWindow();
        return new Dimension(topWindow.getOuterWidth(), topWindow.getOuterHeight());
    }

    public Point getPosition() {
        return this.windowPosition_;
    }

    public void maximize() {
        this.setSize(this.initialWindowDimension_);
        this.setPosition(this.getBasePoint());
    }

    public void minimize() {
        throw new UnsupportedOperationException("Cannot minimize window");
    }

    public void fullscreen() {
        this.maximize();
    }

    public Page lastPage() {
        return this.webWindow_.getEnclosedPage();
    }

    private Point getBasePoint() {
        return new Point(0, 0);
    }
}

