/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.api.services.compute.model.Instance;
import com.xceptance.xlt.gce.GceAdminUtils;
import com.xceptance.xlt.gce.GceClient;
import java.io.File;
import java.util.List;

class OpCreateInstanceGroupNonInteractively {
    private final GceClient gceClient;

    OpCreateInstanceGroupNonInteractively(GceClient gceClient) {
        this.gceClient = gceClient;
    }

    void execute(String regionName, String instanceGroupName, String instanceTemplateName, int instanceCount, File outputFile) {
        try {
            this.gceClient.createInstanceGroup(regionName, instanceGroupName, instanceTemplateName, instanceCount);
            List<Instance> instances = this.gceClient.waitForInstancesAreRunning(regionName, instanceGroupName, instanceCount);
            GceAdminUtils.outputAgentControllerConnectionProperties(instances, outputFile);
        }
        catch (Exception e) {
            GceAdminUtils.dieWithMessage(String.format("Failed to create instance group '%s' with %d instances in region '%s' using template '%s'", instanceGroupName, instanceCount, regionName, instanceTemplateName), e);
        }
    }
}

