/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.ReportProvider;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.report.mergerules.InvalidRequestProcessingRuleException;
import com.xceptance.xlt.report.mergerules.RequestProcessingRule;
import com.xceptance.xlt.report.providers.RequestTableColorization;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;

public class ReportGeneratorConfiguration
extends AbstractConfiguration
implements ReportProviderConfiguration {
    private static final String PROP_PREFIX = "com.xceptance.xlt.reportgenerator.";
    private static final String PROP_RUNTIME_PERCENTILES = "com.xceptance.xlt.reportgenerator.runtimePercentiles";
    private static final String PROP_RUNTIME_INTERVAL_BOUNDARIES = "com.xceptance.xlt.reportgenerator.runtimeIntervalBoundaries";
    private static final String PROP_REQUESTS_TABLE_COLORIZE = "com.xceptance.xlt.reportgenerator.requests.table.colorization";
    private static final String PROP_REQUESTS_TABLE_COLORIZE_DEFAULT = "default";
    private static final String PROP_SUFFIX_MATCHING = "matching";
    private static final String PROP_SUFFIX_MEAN = "mean";
    private static final String PROP_SUFFIX_MIN = "min";
    private static final String PROP_SUFFIX_MAX = "max";
    private static final String PROP_SUFFIX_PERCENTILE = "percentile";
    private static final String PROP_SUFFIX_SEGMENTATION = "segmentation";
    private static final String PROP_SUFFIX_ID = "id";
    private static final String PROP_CHARTS_PREFIX = "com.xceptance.xlt.reportgenerator.charts.";
    private static final String PROP_CHARTS_COMPRESSION_FACTOR = "com.xceptance.xlt.reportgenerator.charts.compressionFactor";
    private static final String PROP_CHARTS_HEIGHT = "com.xceptance.xlt.reportgenerator.charts.height";
    private static final String PROP_CHARTS_MOV_AVG_PERCENTAGE = "com.xceptance.xlt.reportgenerator.charts.movingAverage.percentageOfValues";
    private static final String PROP_CHARTS_WIDTH = "com.xceptance.xlt.reportgenerator.charts.width";
    private static final String PROP_DATA_RECORD_CLASSES_PREFIX = "com.xceptance.xlt.reportgenerator.dataRecords.";
    private static final String PROP_REPORT_PROVIDER_CLASSES_PREFIX = "com.xceptance.xlt.reportgenerator.providers.";
    private static final String PROP_REPORTS_ROOT_DIR = "com.xceptance.xlt.reportgenerator.reports";
    private static final String PROP_RESULTS_ROOT_DIR = "com.xceptance.xlt.reportgenerator.results";
    private static final String PROP_REQUEST_MERGE_RULES_PREFIX = "com.xceptance.xlt.reportgenerator.requestMergeRules.";
    private static final String PROP_PARSER_THREAD_COUNT = "com.xceptance.xlt.reportgenerator.parser.threads";
    private static final String PROP_READER_THREAD_COUNT = "com.xceptance.xlt.reportgenerator.reader.threads";
    private static final String PROP_THREAD_QUEUE_SIZE = "com.xceptance.xlt.reportgenerator.queue.bucketsize";
    private static final String PROP_THREAD_QUEUE_LENGTH = "com.xceptance.xlt.reportgenerator.queue.length";
    private static final String PROP_DATA_SAMPLE_FACTOR = "com.xceptance.xlt.reportgenerator.data.sampleFactor";
    private static final String PROP_TRANSFORMATIONS_PREFIX = "com.xceptance.xlt.reportgenerator.transformations.";
    private static final String PROP_TRANSFORMATIONS_STYLE_SHEET_FILE_SUFFIX = ".styleSheetFileName";
    private static final String PROP_TRANSFORMATIONS_OUTPUT_FILE_SUFFIX = ".outputFileName";
    private static final String PROP_RESULTS_BASE_URI = "com.xceptance.xlt.reportgenerator.resultsBaseUri";
    private static final String PROP_GENERATE_ERROR_LINKS = "com.xceptance.xlt.reportgenerator.linkToResultBrowsers";
    private static final String PROP_CHART_SCALE = "com.xceptance.xlt.reportgenerator.charts.scale";
    private static final String PROP_CHART_CAPPING_FACTOR = "com.xceptance.xlt.reportgenerator.charts.cappingFactor";
    private static final String PROP_CHART_CAPPING_VALUE = "com.xceptance.xlt.reportgenerator.charts.cappingValue";
    private static final String PROP_CHART_CAPPING_MODE = "com.xceptance.xlt.reportgenerator.charts.cappingMode";
    private static final String PROP_REMOVE_INDEXES_FROM_REQUEST_NAMES = "com.xceptance.xlt.reportgenerator.requests.removeIndexes";
    private final float chartsCompressionFactor;
    private final int chartsHeight;
    private final int chartsWidth;
    private final File configDirectory;
    private final Map<String, Class<? extends Data>> dataRecordClasses;
    private final File homeDirectory;
    private final int movingAveragePoints;
    private final List<String> outputFileNames;
    private final List<Class<? extends ReportProvider>> reportProviderClasses;
    private final int[] runtimeIntervalBoundaries;
    private final double[] runtimePercentiles;
    private final List<RequestTableColorization> requestTableColorization;
    private final List<String> styleSheetFileNames;
    private final File testReportsRootDirectory;
    private final File testResultsRootDirectory;
    private File reportDirectory;
    private FileObject resultsDirectory;
    private String resultsDirectoryName;
    private File chartsDirectory;
    private File csvDirectory;
    private long maximumChartTime;
    private long minimumChartTime;
    private boolean noCharts;
    private boolean noAgentCharts;
    public final int readerThreadCount;
    public final int parserThreadCount;
    public final int threadQueueBucketSize;
    public final int threadQueueLength;
    public final int dataSampleFactor;
    private final ChartScale chartScaleMode;
    private final ChartCappingInfo transactionChartCappingInfo;
    private final ChartCappingInfo actionChartCappingInfo;
    private final ChartCappingInfo requestChartCappingInfo;
    private final ChartCappingInfo customChartCappingInfo;
    private final URI linkedResultsBaseUri;
    private final boolean generateErrorLinks;
    private final int requestErrorOverviewChartLimit;
    private final int transactionErrorOverviewChartLimit;
    private final int errorDetailsChartLimit;
    private final int directoryLimitPerError;
    private final double directoryReplacementChance;
    private final int stackTracesLimit;
    private final Map<Pattern, Double> apdexThresholdsByActionNamePattern = new HashMap<Pattern, Double>();
    private double defaultApdexThreshold;
    private final boolean groupEventsByTestCase;
    private final int eventLimit;
    private final int eventMessageLimit;
    private final boolean removeIndexesFromRequestNames;

    public ReportGeneratorConfiguration() throws IOException {
        this(null, null, null);
    }

    public ReportGeneratorConfiguration(Properties xltProperties, File overridePropertyFile, Properties commandLineProperties) throws IOException {
        File testReportsRootDir;
        this.homeDirectory = XltExecutionContext.getCurrent().getXltHomeDir();
        this.configDirectory = XltExecutionContext.getCurrent().getXltConfigDir();
        if (xltProperties == null) {
            xltProperties = XltProperties.getInstance().getProperties();
        }
        this.loadProperties(new File(this.configDirectory, "reportgenerator.properties"));
        Map<String, String> currentMergeRules = this.snapshotMergeRules();
        this.loadProperties(new File(this.configDirectory, "mastercontroller.properties"));
        this.mergeMergeRules(currentMergeRules);
        currentMergeRules = this.snapshotMergeRules();
        this.addProperties(xltProperties);
        this.mergeMergeRules(currentMergeRules);
        if (overridePropertyFile != null) {
            if (!overridePropertyFile.isFile() || !overridePropertyFile.canRead()) {
                throw new FileNotFoundException(overridePropertyFile.getAbsolutePath());
            }
            currentMergeRules = this.snapshotMergeRules();
            this.loadProperties(overridePropertyFile);
            this.mergeMergeRules(currentMergeRules);
        }
        if (commandLineProperties != null) {
            currentMergeRules = this.snapshotMergeRules();
            this.addProperties(commandLineProperties);
            this.mergeMergeRules(currentMergeRules);
        }
        if (!(testReportsRootDir = this.getFileProperty(PROP_REPORTS_ROOT_DIR, new File(this.homeDirectory, "reports"))).isAbsolute()) {
            testReportsRootDir = new File(this.homeDirectory, testReportsRootDir.getPath());
        }
        this.testReportsRootDirectory = testReportsRootDir;
        File testResultsRootDir = this.getFileProperty(PROP_RESULTS_ROOT_DIR, new File(this.homeDirectory, "results"));
        if (!testResultsRootDir.isAbsolute()) {
            testResultsRootDir = new File(this.homeDirectory, testResultsRootDir.getPath());
        }
        this.testResultsRootDirectory = testResultsRootDir;
        this.generateErrorLinks = this.getBooleanProperty(PROP_GENERATE_ERROR_LINKS, false);
        this.linkedResultsBaseUri = this.getUriProperty(PROP_RESULTS_BASE_URI, null);
        this.requestErrorOverviewChartLimit = this.getIntProperty("com.xceptance.xlt.reportgenerator.errors.requestErrorOverviewChartsLimit", 50);
        this.transactionErrorOverviewChartLimit = this.getIntProperty("com.xceptance.xlt.reportgenerator.errors.transactionErrorOverviewChartsLimit", 50);
        this.errorDetailsChartLimit = this.getIntProperty("com.xceptance.xlt.reportgenerator.errors.transactionErrorDetailChartsLimit", 50);
        this.directoryLimitPerError = this.getIntProperty("com.xceptance.xlt.reportgenerator.errors.directoryLimitPerError", 10);
        this.directoryReplacementChance = this.getDoubleProperty("com.xceptance.xlt.reportgenerator.errors.directoryReplacementChance", 0.1);
        this.stackTracesLimit = this.getIntProperty("com.xceptance.xlt.reportgenerator.errors.stackTracesLimit", 500);
        this.groupEventsByTestCase = this.getBooleanProperty("com.xceptance.xlt.reportgenerator.events.groupByTestCase", true);
        this.eventLimit = this.getIntProperty("com.xceptance.xlt.reportgenerator.events.eventLimit", 100);
        this.eventMessageLimit = this.getIntProperty("com.xceptance.xlt.reportgenerator.events.messageLimit", 100);
        this.chartScaleMode = this.getEnumProperty(ChartScale.class, PROP_CHART_SCALE, ChartScale.LINEAR);
        double defaultChartCappingFactor = this.getDoubleProperty(PROP_CHART_CAPPING_FACTOR, -1.0);
        double defaultChartCappingValue = this.getDoubleProperty(PROP_CHART_CAPPING_VALUE, -1.0);
        ChartCappingInfo.ChartCappingMode defaultChartCappingMode = this.getEnumProperty(ChartCappingInfo.ChartCappingMode.class, PROP_CHART_CAPPING_MODE, ChartCappingInfo.ChartCappingMode.SMART);
        this.transactionChartCappingInfo = this.readChartCappingInfo("transactions", defaultChartCappingValue, defaultChartCappingFactor, defaultChartCappingMode);
        this.actionChartCappingInfo = this.readChartCappingInfo("actions", defaultChartCappingValue, defaultChartCappingFactor, defaultChartCappingMode);
        this.requestChartCappingInfo = this.readChartCappingInfo("requests", defaultChartCappingValue, defaultChartCappingFactor, defaultChartCappingMode);
        this.customChartCappingInfo = this.readChartCappingInfo("custom", defaultChartCappingValue, defaultChartCappingFactor, defaultChartCappingMode);
        this.chartsCompressionFactor = (float)this.getDoubleProperty(PROP_CHARTS_COMPRESSION_FACTOR, 0.0);
        this.chartsWidth = this.getIntProperty(PROP_CHARTS_WIDTH, 900);
        this.chartsHeight = this.getIntProperty(PROP_CHARTS_HEIGHT, 300);
        this.movingAveragePoints = this.getIntProperty(PROP_CHARTS_MOV_AVG_PERCENTAGE, 5);
        this.readerThreadCount = Math.max(1, this.getIntProperty(PROP_READER_THREAD_COUNT, Runtime.getRuntime().availableProcessors()));
        this.parserThreadCount = Math.max(1, this.getIntProperty(PROP_PARSER_THREAD_COUNT, Runtime.getRuntime().availableProcessors()));
        this.dataSampleFactor = Math.max(1, this.getIntProperty(PROP_DATA_SAMPLE_FACTOR, 1));
        this.threadQueueBucketSize = Math.max(1, this.getIntProperty(PROP_THREAD_QUEUE_SIZE, 200));
        this.threadQueueLength = Math.max(1, this.getIntProperty(PROP_THREAD_QUEUE_LENGTH, 100));
        this.removeIndexesFromRequestNames = this.getBooleanProperty(PROP_REMOVE_INDEXES_FROM_REQUEST_NAMES, true);
        this.dataRecordClasses = this.readDataRecordClasses();
        this.reportProviderClasses = this.readReportProviderClasses();
        this.runtimeIntervalBoundaries = this.readRuntimeIntervalBoundaries();
        this.runtimePercentiles = this.readRuntimePercentiles();
        this.requestTableColorization = this.readRequestTableColorization(this.runtimeIntervalBoundaries, this.runtimePercentiles);
        this.outputFileNames = new ArrayList<String>();
        this.styleSheetFileNames = new ArrayList<String>();
        this.readTransformations(this.outputFileNames, this.styleSheetFileNames);
        this.readApdexThresholds();
    }

    private void checkForLeadingZeros(String s) {
        if (s.length() > 1 && s.startsWith("0")) {
            StringBuilder sb = new StringBuilder("Leading zeros are not allowed in request merge rule indices.\nPlease check your configuration and fix the following properties:");
            for (String prop : this.getPropertyKeysWithPrefix(PROP_REQUEST_MERGE_RULES_PREFIX + s + ".")) {
                sb.append("\n\t").append(prop);
            }
            sb.append("\n");
            throw new RuntimeException(sb.toString());
        }
    }

    private ChartCappingInfo readChartCappingInfo(String chartType, double defaultCappingValue, double defaultCappingFactor, ChartCappingInfo.ChartCappingMode defaultCappingMode) {
        ChartCappingInfo info = new ChartCappingInfo();
        double factor = this.getDoubleProperty("com.xceptance.xlt.reportgenerator.charts.cappingFactor." + chartType, defaultCappingFactor);
        double value = this.getDoubleProperty("com.xceptance.xlt.reportgenerator.charts.cappingValue." + chartType, defaultCappingValue);
        if (value > 0.0) {
            info.method = ChartCappingInfo.ChartCappingMethod.ABSOLUTE;
            info.parameter = value;
        } else if (factor > 1.0) {
            info.method = ChartCappingInfo.ChartCappingMethod.NFOLD_OF_AVERAGE;
            info.parameter = factor;
        } else {
            info.method = ChartCappingInfo.ChartCappingMethod.NONE;
            info.parameter = 0.0;
        }
        info.mode = this.getEnumProperty(ChartCappingInfo.ChartCappingMode.class, "com.xceptance.xlt.reportgenerator.charts.cappingMode." + chartType, defaultCappingMode);
        return info;
    }

    public double getApdexThresholdForAction(String actionName) {
        for (Map.Entry<Pattern, Double> entry : this.apdexThresholdsByActionNamePattern.entrySet()) {
            if (!RegExUtils.isMatching(actionName, entry.getKey())) continue;
            return entry.getValue();
        }
        return this.defaultApdexThreshold;
    }

    @Override
    public File getChartDirectory() {
        if (this.chartsDirectory == null) {
            this.chartsDirectory = new File(this.reportDirectory, "charts");
        }
        if (!this.chartsDirectory.exists()) {
            this.chartsDirectory.mkdirs();
        }
        return this.chartsDirectory;
    }

    public float getChartCompressionFactor() {
        return this.chartsCompressionFactor;
    }

    @Override
    public long getChartEndTime() {
        return this.maximumChartTime;
    }

    @Override
    public int getChartHeight() {
        return this.chartsHeight;
    }

    @Override
    public long getChartStartTime() {
        return this.minimumChartTime;
    }

    @Override
    public int getChartWidth() {
        return this.chartsWidth;
    }

    public ChartScale getChartScale() {
        return this.chartScaleMode;
    }

    public ChartCappingInfo getTransactionChartCappingInfo() {
        return this.transactionChartCappingInfo;
    }

    public ChartCappingInfo getActionChartCappingInfo() {
        return this.actionChartCappingInfo;
    }

    public ChartCappingInfo getRequestChartCappingInfo() {
        return this.requestChartCappingInfo;
    }

    public ChartCappingInfo getCustomChartCappingInfo() {
        return this.customChartCappingInfo;
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    @Override
    public File getCsvDirectory() {
        return this.csvDirectory;
    }

    public Map<String, Class<? extends Data>> getDataRecordClasses() {
        return this.dataRecordClasses;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    @Override
    public int getMovingAveragePercentage() {
        return this.movingAveragePoints;
    }

    public List<String> getOutputFileNames() {
        return this.outputFileNames;
    }

    @Override
    public File getReportDirectory() {
        return this.reportDirectory;
    }

    public List<Class<? extends ReportProvider>> getReportProviderClasses() {
        return this.reportProviderClasses;
    }

    public FileObject getResultsDirectory() {
        return this.resultsDirectory;
    }

    public String getResultsDirectoryName() {
        return this.resultsDirectoryName;
    }

    public int[] getRuntimeIntervalBoundaries() {
        return this.runtimeIntervalBoundaries;
    }

    public double[] getRuntimePercentiles() {
        return this.runtimePercentiles;
    }

    public List<RequestTableColorization> getRequestTableColorizations() {
        return this.requestTableColorization;
    }

    public String getRequestTableColorizationDefaultGroupName() {
        return PROP_REQUESTS_TABLE_COLORIZE_DEFAULT;
    }

    public List<String> getStyleSheetFileNames() {
        return this.styleSheetFileNames;
    }

    public File getTestReportsRootDirectory() {
        return this.testReportsRootDirectory;
    }

    public File getTestResultsRootDirectory() {
        return this.testResultsRootDirectory;
    }

    public int getErrorDetailsChartLimit() {
        return this.errorDetailsChartLimit;
    }

    public int getDirectoryLimitPerError() {
        return this.directoryLimitPerError;
    }

    public double getDirectoryReplacementChance() {
        return this.directoryReplacementChance;
    }

    public int getStackTracesLimit() {
        return this.stackTracesLimit;
    }

    public boolean createErrorDetailsCharts() {
        return this.getErrorDetailsChartLimit() != 0;
    }

    public boolean createRequestErrorOverviewCharts() {
        return this.getRequestErrorOverviewChartLimit() != 0;
    }

    public int getRequestErrorOverviewChartLimit() {
        return this.requestErrorOverviewChartLimit;
    }

    public boolean createTransactionErrorOverviewCharts() {
        return this.getTransactionErrorOverviewChartLimit() != 0;
    }

    public int getTransactionErrorOverviewChartLimit() {
        return this.transactionErrorOverviewChartLimit;
    }

    public void setChartEndTime(long maximumChartTime) {
        this.maximumChartTime = maximumChartTime;
    }

    public void setChartStartTime(long minimumChartTime) {
        this.minimumChartTime = minimumChartTime;
    }

    public void setReportDirectory(File reportDirectory) {
        this.reportDirectory = reportDirectory;
        this.chartsDirectory = new File(reportDirectory, "charts");
        this.csvDirectory = new File(reportDirectory, "csv");
    }

    public void setResultsDirectory(FileObject resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
    }

    public void setResultsDirectoryName(String resultsDirectoryName) {
        this.resultsDirectoryName = resultsDirectoryName;
    }

    public void disableChartsGeneration() {
        this.noCharts = true;
    }

    @Override
    public boolean shouldChartsGenerated() {
        return !this.noCharts;
    }

    public void disableAgentCharts() {
        this.noAgentCharts = true;
    }

    public boolean agentChartsEnabled() {
        return !this.noCharts && !this.noAgentCharts;
    }

    public boolean isGenerateErrorLinks() {
        return this.generateErrorLinks;
    }

    public URI getLinkedResultsBaseUri() {
        return this.linkedResultsBaseUri;
    }

    public boolean getGroupEventsByTestCase() {
        return this.groupEventsByTestCase;
    }

    public int getEventLimitPerTestCase() {
        return this.eventLimit;
    }

    public int getEventMessageLimitPerEvent() {
        return this.eventMessageLimit;
    }

    public boolean getRemoveIndexesFromRequestNames() {
        return this.removeIndexesFromRequestNames;
    }

    private int[] readRuntimeIntervalBoundaries() {
        try {
            int[] values;
            for (int value : values = this.readIntValueList(PROP_RUNTIME_INTERVAL_BOUNDARIES, "")) {
                if (value >= 1) continue;
                throw new IllegalArgumentException(String.format("Value '%d' is smaller than 1", value));
            }
            Arrays.sort(values);
            return values;
        }
        catch (Exception e) {
            throw new XltException("Failed to parse runtime interval boundaries: " + e.getMessage(), e);
        }
    }

    private double[] readRuntimePercentiles() {
        try {
            double[] values;
            for (double value : values = this.readDoubleValueList(PROP_RUNTIME_PERCENTILES, "50, 95, 99, 99.9")) {
                if (!(value <= 0.0) && !(value > 100.0)) continue;
                throw new IllegalArgumentException(String.format("Value '%f' is not in range (0,100]", value));
            }
            Arrays.sort(values);
            return values;
        }
        catch (Exception e) {
            throw new XltException("Failed to parse runtime percentiles: " + e.getMessage(), e);
        }
    }

    private List<RequestTableColorization> readRequestTableColorization(int[] segmentationIntervals, double[] percentileIntervals) {
        try {
            ArrayList<RequestTableColorization> colorizationConfigs = new ArrayList<RequestTableColorization>();
            Set<String> groupNames = this.getPropertyKeyFragment("com.xceptance.xlt.reportgenerator.requests.table.colorization.");
            for (String eachGroupName : groupNames) {
                String matchingPattern;
                String propertyGroup = "com.xceptance.xlt.reportgenerator.requests.table.colorization." + eachGroupName;
                String propertyMatching = propertyGroup + ".matching";
                if (PROP_REQUESTS_TABLE_COLORIZE_DEFAULT.equals(eachGroupName)) {
                    matchingPattern = ".*";
                } else {
                    matchingPattern = this.getStringProperty(propertyMatching);
                    if (StringUtils.isBlank((CharSequence)matchingPattern)) {
                        throw new XltException(propertyMatching + " has no value. The value must be a regular expression");
                    }
                }
                try {
                    this.compileRegEx(matchingPattern, propertyMatching);
                }
                catch (XltException e) {
                    throw new XltException(e.getMessage());
                }
                ArrayList<RequestTableColorization.ColorizationRule> colorizationRules = new ArrayList<RequestTableColorization.ColorizationRule>();
                colorizationRules.add(this.readColorizationRule(propertyGroup, PROP_SUFFIX_MEAN, PROP_SUFFIX_MEAN, false));
                colorizationRules.add(this.readColorizationRule(propertyGroup, PROP_SUFFIX_MIN, PROP_SUFFIX_MIN, false));
                colorizationRules.add(this.readColorizationRule(propertyGroup, PROP_SUFFIX_MAX, PROP_SUFFIX_MAX, false));
                colorizationRules.addAll(this.readPercentileColorizationRules(propertyGroup, percentileIntervals));
                colorizationRules.addAll(this.readSegmentationColorizationRules(propertyGroup, segmentationIntervals));
                colorizationConfigs.add(new RequestTableColorization(eachGroupName, matchingPattern, colorizationRules));
            }
            return colorizationConfigs;
        }
        catch (Exception e) {
            throw new XltException("Failed to parse request table colorization: " + e.getMessage(), e);
        }
    }

    private List<RequestTableColorization.ColorizationRule> readSegmentationColorizationRules(String propertyGroup, int[] segmentationIntervals) {
        ArrayList<RequestTableColorization.ColorizationRule> segmentationRules = new ArrayList<RequestTableColorization.ColorizationRule>();
        String segmentationProperty = propertyGroup + ".segmentation";
        Set<String> segmentationGroups = this.getPropertyKeyFragment(segmentationProperty + ".");
        for (String eachSegmentationGroup : segmentationGroups) {
            String propertyID = segmentationProperty + "." + eachSegmentationGroup + ".id";
            String segmentationValue = this.getStringProperty(propertyID);
            List<String> segmentationStrings = this.getSegmentationsAsStringList(segmentationIntervals);
            if (!segmentationStrings.contains(segmentationValue) && !">".equals(segmentationValue)) {
                throw new XltException(propertyID + " = " + segmentationValue + " value should be one of " + segmentationStrings + " as specified at the \"runtimeIntervalBoundaries\" property or \">\" for the last column.");
            }
            RequestTableColorization.ColorizationRule rule = this.readColorizationRule(segmentationProperty, eachSegmentationGroup, PROP_SUFFIX_SEGMENTATION, !">".equals(segmentationValue));
            rule.id = segmentationValue;
            if (">".equals(rule.id)) {
                rule.id = "";
            }
            segmentationRules.add(rule);
        }
        return segmentationRules;
    }

    private List<String> getSegmentationsAsStringList(int[] segmentationIntervals) {
        ArrayList<String> list = new ArrayList<String>(segmentationIntervals.length);
        for (int eachEntry : segmentationIntervals) {
            list.add(Integer.toString(eachEntry));
        }
        return list;
    }

    private List<RequestTableColorization.ColorizationRule> readPercentileColorizationRules(String propertyGroup, double[] percentileIntervals) {
        ArrayList<RequestTableColorization.ColorizationRule> percentileRules = new ArrayList<RequestTableColorization.ColorizationRule>();
        String percentileProperty = propertyGroup + ".percentile";
        Set<String> percentileGroups = this.getPropertyKeyFragment(percentileProperty + ".");
        for (String eachPercentileGroup : percentileGroups) {
            String propertyID = percentileProperty + "." + eachPercentileGroup + ".id";
            String percentileValue = this.getStringProperty(propertyID);
            List<String> percentileStrings = this.getPercentilesAsStringList(percentileIntervals);
            if (!percentileStrings.contains(percentileValue)) {
                throw new XltException(propertyID + " = " + percentileValue + " value should be one of " + percentileStrings + " as specified at the \"runtimePercentiles\" property.");
            }
            String percentileID = "p" + percentileValue;
            RequestTableColorization.ColorizationRule rule = this.readColorizationRule(percentileProperty, eachPercentileGroup, PROP_SUFFIX_PERCENTILE, false);
            rule.id = percentileID;
            percentileRules.add(rule);
        }
        return percentileRules;
    }

    private List<String> getPercentilesAsStringList(double[] percentileIntervals) {
        ArrayList<String> list = new ArrayList<String>(percentileIntervals.length);
        for (double eachEntry : percentileIntervals) {
            if (eachEntry == (double)((long)eachEntry)) {
                list.add(Long.toString((long)eachEntry));
                continue;
            }
            list.add(Double.toString(eachEntry));
        }
        return list;
    }

    private RequestTableColorization.ColorizationRule readColorizationRule(String propertyGroup, String propertyName, String type, boolean scaleInverted) throws XltException {
        String ruleProperty = propertyGroup + "." + propertyName;
        if (this.getPropertyKeyFragments(ruleProperty).isEmpty()) {
            return null;
        }
        String rangeSpec = this.getStringProperty(ruleProperty);
        String[] ranges = rangeSpec.split(" ");
        if (ranges.length != 3) {
            throw new XltException(ruleProperty + " = " + rangeSpec + " must be a whitespace separated list of numbers in the pattern of \"<FROM> <TARGET> <TO>\"");
        }
        int from = this.parseInt(ruleProperty + " (FROM parameter, first value)", ranges[0]);
        int target = this.parseInt(ruleProperty + " (TARGET parameter, second value)", ranges[1]);
        int to = this.parseInt(ruleProperty + " (TO parameter, third value)", ranges[2]);
        if (from < 0) {
            throw new XltException(ruleProperty + " = " + rangeSpec + " FROM parameter (first value) must be greater or equal 0");
        }
        if (!scaleInverted) {
            if (to <= from) {
                throw new XltException(ruleProperty + " = " + rangeSpec + " TO parameter (third value) must be greater than the FROM parameter (first value)");
            }
            if (target < from || target > to) {
                throw new XltException(ruleProperty + " = " + rangeSpec + " TARGET parameter (second value) must be greater or equal the FROM parameter (first value) and lower or equal the TO parameter (third value)");
            }
        } else {
            if (to >= from) {
                throw new XltException(ruleProperty + " = " + rangeSpec + " TO parameter (third value) must be lower than the FROM parameter (first value)");
            }
            if (target > from || target < to) {
                throw new XltException(ruleProperty + " = " + rangeSpec + " TARGET parameter (second value) must be less or equal the FROM parameter (first value) and greater or equal the TO parameter (third value)");
            }
        }
        RequestTableColorization.ColorizationRule rule = new RequestTableColorization.ColorizationRule(propertyName, type);
        rule.from = scaleInverted ? to : from;
        rule.target = target;
        rule.to = scaleInverted ? from : to;
        return rule;
    }

    private int[] readIntValueList(String propertyName, String defaultValue) {
        String propertyValue = this.getStringProperty(propertyName, defaultValue);
        String[] valueStrings = StringUtils.split((String)propertyValue, (String)" ,;");
        int[] values = new int[valueStrings.length];
        for (int i = 0; i < valueStrings.length; ++i) {
            values[i] = Integer.parseInt(valueStrings[i]);
        }
        return values;
    }

    private double[] readDoubleValueList(String propertyName, String defaultValue) {
        String propertyValue = this.getStringProperty(propertyName, defaultValue);
        String[] valueStrings = StringUtils.split((String)propertyValue, (String)" ,;");
        double[] values = new double[valueStrings.length];
        for (int i = 0; i < valueStrings.length; ++i) {
            values[i] = Double.parseDouble(valueStrings[i]);
        }
        return values;
    }

    private Map<String, Class<? extends Data>> readDataRecordClasses() {
        HashMap<String, Class<? extends Data>> dataRecordClasses = new HashMap<String, Class<? extends Data>>();
        Set<String> typeCodes = this.getPropertyKeyFragment(PROP_DATA_RECORD_CLASSES_PREFIX);
        for (String typeCode : typeCodes) {
            Class<?> cl = this.getClassProperty(PROP_DATA_RECORD_CLASSES_PREFIX + typeCode);
            if (!Data.class.isAssignableFrom(cl)) continue;
            Class<Data> c = cl.asSubclass(Data.class);
            dataRecordClasses.put(typeCode, c);
        }
        return dataRecordClasses;
    }

    private List<Class<? extends ReportProvider>> readReportProviderClasses() {
        ArrayList<Class<? extends ReportProvider>> providerClasses = new ArrayList<Class<? extends ReportProvider>>();
        Set<String> keys = this.getPropertyKeysWithPrefix(PROP_REPORT_PROVIDER_CLASSES_PREFIX);
        for (String key : keys) {
            Class<?> cl = this.getClassProperty(key);
            if (!ReportProvider.class.isAssignableFrom(cl)) continue;
            Class<ReportProvider> c = cl.asSubclass(ReportProvider.class);
            providerClasses.add(c);
        }
        return providerClasses;
    }

    private void readTransformations(List<String> outputFileNames, List<String> styleSheetFileNames) {
        Set<String> keys = this.getPropertyKeyFragment(PROP_TRANSFORMATIONS_PREFIX);
        for (String key : keys) {
            String propertyPrefix = PROP_TRANSFORMATIONS_PREFIX + key;
            File outputFile = this.getFileProperty(propertyPrefix + PROP_TRANSFORMATIONS_OUTPUT_FILE_SUFFIX);
            File styleSheetFile = this.getFileProperty(propertyPrefix + PROP_TRANSFORMATIONS_STYLE_SHEET_FILE_SUFFIX);
            outputFileNames.add(outputFile.getPath());
            styleSheetFileNames.add(styleSheetFile.getPath());
        }
    }

    private Map<String, String> snapshotMergeRules() {
        Set<String> oldMergeRuleKeys = this.getPropertyKeysWithPrefix(PROP_REQUEST_MERGE_RULES_PREFIX);
        HashMap<String, String> oldMergeRulesComplete = new HashMap<String, String>();
        for (String key : oldMergeRuleKeys) {
            oldMergeRulesComplete.put(key, this.getStringProperty(key));
            this.getProperties().remove(key);
        }
        return oldMergeRulesComplete;
    }

    private void mergeMergeRules(Map<String, String> oldMergeRulesComplete) {
        if (this.getPropertyKeysWithPrefix(PROP_REQUEST_MERGE_RULES_PREFIX).isEmpty()) {
            for (Map.Entry<String, String> rule : oldMergeRulesComplete.entrySet()) {
                this.getProperties().setProperty(rule.getKey(), rule.getValue());
            }
        }
    }

    public List<RequestProcessingRule> getRequestProcessingRules() {
        ArrayList<RequestProcessingRule> requestProcessingRules = new ArrayList<RequestProcessingRule>();
        TreeSet<Integer> requestMergerNumbers = new TreeSet<Integer>();
        Set<String> requestMergerNumberStrings = this.getPropertyKeyFragment(PROP_REQUEST_MERGE_RULES_PREFIX);
        for (String s : requestMergerNumberStrings) {
            this.checkForLeadingZeros(s);
            requestMergerNumbers.add(Integer.parseInt(s));
        }
        boolean invalidRulePresent = false;
        Iterator iterator = requestMergerNumbers.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            String basePropertyName = PROP_REQUEST_MERGE_RULES_PREFIX + i;
            String newName = this.getStringProperty(basePropertyName + ".newName", "");
            boolean stopOnMatch = this.getBooleanProperty(basePropertyName + ".stopOnMatch", true);
            boolean dropOnMatch = this.getBooleanProperty(basePropertyName + ".dropOnMatch", false);
            String urlPattern = this.getStringProperty(basePropertyName + ".urlPattern", "");
            String contentTypePattern = this.getStringProperty(basePropertyName + ".contentTypePattern", "");
            String statusCodePattern = this.getStringProperty(basePropertyName + ".statusCodePattern", "");
            String requestNamePattern = this.getStringProperty(basePropertyName + ".namePattern", "");
            String agentNamePattern = this.getStringProperty(basePropertyName + ".agentPattern", "");
            String transactionNamePattern = this.getStringProperty(basePropertyName + ".transactionPattern", "");
            String methodPattern = this.getStringProperty(basePropertyName + ".methodPattern", "");
            String responseTimes = this.getStringProperty(basePropertyName + ".runTimeRanges", "");
            String urlExcludePattern = this.getStringProperty(basePropertyName + ".urlPattern.exclude", "");
            String contentTypeExcludePattern = this.getStringProperty(basePropertyName + ".contentTypePattern.exclude", "");
            String statusCodeExcludePattern = this.getStringProperty(basePropertyName + ".statusCodePattern.exclude", "");
            String requestNameExcludePattern = this.getStringProperty(basePropertyName + ".namePattern.exclude", "");
            String agentNameExcludePattern = this.getStringProperty(basePropertyName + ".agentPattern.exclude", "");
            String transactionNameExcludePattern = this.getStringProperty(basePropertyName + ".transactionPattern.exclude", "");
            String methodExcludePattern = this.getStringProperty(basePropertyName + ".methodPattern.exclude", "");
            if (StringUtils.isNotBlank((CharSequence)newName) == dropOnMatch) {
                throw new RuntimeException(String.format("Either specify property '%s' or set property '%s' to true", basePropertyName + ".newName", basePropertyName + ".dropOnMatch"));
            }
            if (dropOnMatch && !stopOnMatch) {
                throw new RuntimeException(String.format("If property '%s' is true, property '%s' cannot be false", basePropertyName + ".dropOnMatch", basePropertyName + ".stopOnMatch"));
            }
            try {
                RequestProcessingRule mergeRule = new RequestProcessingRule(newName, requestNamePattern, urlPattern, contentTypePattern, statusCodePattern, agentNamePattern, transactionNamePattern, methodPattern, responseTimes, stopOnMatch, requestNameExcludePattern, urlExcludePattern, contentTypeExcludePattern, statusCodeExcludePattern, agentNameExcludePattern, transactionNameExcludePattern, methodExcludePattern, dropOnMatch);
                requestProcessingRules.add(mergeRule);
            }
            catch (InvalidRequestProcessingRuleException imre) {
                String errMsg = "Request processing rule '" + basePropertyName + "' is invalid. " + imre.getMessage();
                XltLogger.reportLogger.error(errMsg, (Throwable)imre);
                System.err.println(errMsg);
                invalidRulePresent = true;
            }
        }
        if (invalidRulePresent) {
            throw new RuntimeException("Please check your configuration. At least one request processing rule is invalid and needs to be fixed.");
        }
        return requestProcessingRules;
    }

    private void readApdexThresholds() {
        String PROP_APDEX_PREFIX = "com.xceptance.xlt.reportgenerator.apdex.";
        String ACTION_GROUP_DEFAULT = PROP_REQUESTS_TABLE_COLORIZE_DEFAULT;
        Set<String> actionGroups = this.getPropertyKeyFragment("com.xceptance.xlt.reportgenerator.apdex.");
        actionGroups.remove(PROP_REQUESTS_TABLE_COLORIZE_DEFAULT);
        String defaultThresholdPropertyName = "com.xceptance.xlt.reportgenerator.apdex.default.threshold";
        this.defaultApdexThreshold = this.getDoubleProperty("com.xceptance.xlt.reportgenerator.apdex.default.threshold", 4.0);
        this.validateApdexThreshold(this.defaultApdexThreshold, "com.xceptance.xlt.reportgenerator.apdex.default.threshold");
        for (String actionGroup : actionGroups) {
            String thresholdPropertyName = "com.xceptance.xlt.reportgenerator.apdex." + actionGroup + ".threshold";
            double threshold = this.getDoubleProperty(thresholdPropertyName, Double.NaN);
            String actionsPropertyName = "com.xceptance.xlt.reportgenerator.apdex." + actionGroup + ".actions";
            String actionNamePattern = this.getStringProperty(actionsPropertyName, "");
            if (Double.isNaN(threshold) || !StringUtils.isNotBlank((CharSequence)actionNamePattern)) continue;
            this.validateApdexThreshold(threshold, thresholdPropertyName);
            Pattern pattern = this.compileRegEx(actionNamePattern, actionsPropertyName);
            this.apdexThresholdsByActionNamePattern.put(pattern, threshold);
        }
    }

    private void validateApdexThreshold(double threshold, String propertyName) {
        if (threshold <= 0.0) {
            throw new XltException(String.format("The value '%f' of property '%s' must be greater than 0.0", threshold, propertyName));
        }
    }

    private Pattern compileRegEx(String regEx, String propertyName) {
        try {
            return RegExUtils.getPattern(regEx);
        }
        catch (Exception ex) {
            throw new XltException(String.format("The value '%s' of property '%s' is not a valid regular expression:\n%s", regEx, propertyName, ex.getMessage()));
        }
    }

    public static class ChartCappingInfo {
        public ChartCappingMethod method;
        public ChartCappingMode mode;
        public double parameter;

        public static enum ChartCappingMode {
            SMART,
            ALWAYS;

        }

        public static enum ChartCappingMethod {
            NONE,
            ABSOLUTE,
            NFOLD_OF_AVERAGE;

        }
    }

    public static enum ChartScale {
        LINEAR,
        LOGARITHMIC;

    }
}

