/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.xceptance.xlt.api.report.ReportCreator;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.report.TestReport;
import com.xceptance.xlt.report.util.xstream.SanitizingDomDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public class XmlReportGenerator {
    private final List<ReportCreator> processors = new ArrayList<ReportCreator>();

    public void createReport(File xmlFile) throws IOException {
        TestReport testReport = new TestReport();
        for (ReportCreator processor : this.processors) {
            try {
                Object report = processor.createReportFragment();
                if (report == null) continue;
                testReport.addReportFragment(report);
            }
            catch (Throwable t) {
                XltLogger.reportLogger.warn("Failed to create report fragment", t);
            }
        }
        this.saveTestReport(testReport, xmlFile);
    }

    <T extends ReportCreator> void registerStatisticsProviders(List<T> processors) {
        for (ReportCreator t : processors) {
            this.registerStatisticsProvider(t);
        }
    }

    public void registerStatisticsProvider(ReportCreator processor) {
        this.processors.add(processor);
    }

    public void unregisterStatisticsProcessor(ReportCreator processor) {
        this.processors.remove(processor);
    }

    private void saveTestReport(TestReport testReport, File xmlFile) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF-8");){
            osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            XStream xstream = new XStream((HierarchicalStreamDriver)new SanitizingDomDriver());
            xstream.autodetectAnnotations(true);
            xstream.registerConverter((SingleValueConverter)new DateConverter("yyyy-MM-dd HH:mm:ss z", null, TimeZone.getDefault()));
            xstream.aliasSystemAttribute(null, "class");
            xstream.setMode(1001);
            xstream.toXML((Object)testReport, (Writer)osw);
        }
    }
}

