/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import java.io.File;

public abstract class AbstractDataProcessor {
    private int chartHeight;
    private File chartsDir;
    private int chartWidth;
    private File csvDir;
    private int movingAveragePercentage;
    private ReportGeneratorConfiguration.ChartCappingInfo chartCappingInfo;
    private String name;
    private final AbstractReportProvider reportProvider;

    protected AbstractDataProcessor(String name, AbstractReportProvider reportProvider) {
        this.name = name;
        this.reportProvider = reportProvider;
        ReportProviderConfiguration config = reportProvider.getConfiguration();
        this.setChartDir(config.getChartDirectory());
        this.setCsvDir(config.getCsvDirectory());
        this.setChartWidth(config.getChartWidth());
        this.setChartHeight(config.getChartHeight());
        this.setMovingAveragePercentage(config.getMovingAveragePercentage());
    }

    public int getChartHeight() {
        return this.chartHeight;
    }

    public File getChartDir() {
        return this.chartsDir;
    }

    public int getChartWidth() {
        return this.chartWidth;
    }

    public ReportProviderConfiguration getConfiguration() {
        return this.reportProvider.getConfiguration();
    }

    public File getCsvDir() {
        return this.csvDir;
    }

    public long getEndTime() {
        return this.getConfiguration().getChartEndTime();
    }

    public int getMovingAveragePercentage() {
        return this.movingAveragePercentage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractReportProvider getReportProvider() {
        return this.reportProvider;
    }

    public long getStartTime() {
        return this.getConfiguration().getChartStartTime();
    }

    public abstract void processDataRecord(Data var1);

    public void setChartHeight(int chartHeight) {
        this.chartHeight = chartHeight;
    }

    public void setChartDir(File chartsDir) {
        this.chartsDir = chartsDir;
        chartsDir.mkdirs();
    }

    public void setChartWidth(int chartWidth) {
        this.chartWidth = chartWidth;
    }

    public void setCsvDir(File csvDir) {
        this.csvDir = csvDir;
        csvDir.mkdirs();
    }

    public void setMovingAveragePercentage(int movingAveragePercentage) {
        this.movingAveragePercentage = movingAveragePercentage;
    }

    protected void setChartCappingInfo(ReportGeneratorConfiguration.ChartCappingInfo cappingInfo) {
        this.chartCappingInfo = cappingInfo;
    }

    protected ReportGeneratorConfiguration.ChartCappingInfo getChartCappingInfo() {
        return this.chartCappingInfo;
    }
}

