/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import com.xceptance.xlt.agentcontroller.AgentControllerStatus;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.agentcontroller.AgentStatusInfo;
import com.xceptance.xlt.agentcontroller.ScenarioStatus;
import com.xceptance.xlt.agentcontroller.TestUserStatus;
import com.xceptance.xlt.mastercontroller.AgentControllerStatusInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class StatusUtils {
    public static List<ScenarioStatus> aggregateScenarioStatusLists(List<AgentControllerStatusInfo> agentControllerStatusInfoList) {
        TreeMap<String, ScenarioStatus> mergedScenarioStatusMap = new TreeMap<String, ScenarioStatus>();
        for (AgentControllerStatusInfo agentControllerStatus : agentControllerStatusInfoList) {
            for (ScenarioStatus scenarioStatus : agentControllerStatus.getScenarioStatusList()) {
                String scenarioName = scenarioStatus.getScenarioName();
                ScenarioStatus mergedScenarioStatus = mergedScenarioStatusMap.computeIfAbsent(scenarioName, StatusUtils::createInitialScenarioStatus);
                StatusUtils.mergeScenarioStatusInto(scenarioStatus, mergedScenarioStatus);
            }
        }
        return new ArrayList<ScenarioStatus>(mergedScenarioStatusMap.values());
    }

    public static ScenarioStatus getTotalScenarioStatus(List<ScenarioStatus> scenarioStatusList) {
        ScenarioStatus totalScenarioStatus = StatusUtils.createInitialScenarioStatus("Totals");
        for (ScenarioStatus scenarioStatus : scenarioStatusList) {
            StatusUtils.mergeScenarioStatusInto(scenarioStatus, totalScenarioStatus);
        }
        return totalScenarioStatus;
    }

    public static void mergeScenarioStatusInto(ScenarioStatus sourceScenarioStatus, ScenarioStatus targetScenarioStatus) {
        TestUserStatus.State targetState = targetScenarioStatus.getState();
        TestUserStatus.State sourceState = sourceScenarioStatus.getState();
        if (targetState != TestUserStatus.State.Running && sourceState != TestUserStatus.State.Waiting) {
            targetScenarioStatus.setState(sourceState);
        }
        targetScenarioStatus.setRunningUsers(targetScenarioStatus.getRunningUsers() + sourceScenarioStatus.getRunningUsers());
        targetScenarioStatus.setTotalUsers(targetScenarioStatus.getTotalUsers() + sourceScenarioStatus.getTotalUsers());
        targetScenarioStatus.setIterations(targetScenarioStatus.getIterations() + sourceScenarioStatus.getIterations());
        targetScenarioStatus.setTotalRuntime(targetScenarioStatus.getTotalRuntime() + sourceScenarioStatus.getTotalRuntime());
        targetScenarioStatus.setElapsedTime(Math.max(targetScenarioStatus.getElapsedTime(), sourceScenarioStatus.getElapsedTime()));
        targetScenarioStatus.setEvents(targetScenarioStatus.getEvents() + sourceScenarioStatus.getEvents());
        targetScenarioStatus.setErrors(targetScenarioStatus.getErrors() + sourceScenarioStatus.getErrors());
        targetScenarioStatus.setPercentageComplete(Math.max(targetScenarioStatus.getPercentageComplete(), sourceScenarioStatus.getPercentageComplete()));
        targetScenarioStatus.setStartDate(Math.min(targetScenarioStatus.getStartDate(), sourceScenarioStatus.getStartDate()));
        targetScenarioStatus.setException((Exception)ObjectUtils.defaultIfNull((Object)sourceScenarioStatus.getException(), (Object)targetScenarioStatus.getException()));
        if (targetScenarioStatus.getLastModifiedDate() < sourceScenarioStatus.getLastModifiedDate()) {
            targetScenarioStatus.setLastModifiedDate(sourceScenarioStatus.getLastModifiedDate());
            targetScenarioStatus.setLastRuntime(sourceScenarioStatus.getLastRuntime());
        }
    }

    public static Map<String, List<AgentStatusInfo>> getFailedAgentsByHost(List<AgentControllerStatusInfo> agentControllerStatusList) {
        HashMap<String, List<AgentStatusInfo>> failedAgentsByHostMap = new HashMap<String, List<AgentStatusInfo>>();
        for (AgentControllerStatusInfo agentControllerStatus : agentControllerStatusList) {
            for (AgentStatusInfo agentStatus : agentControllerStatus.getAgentStatusList()) {
                if (agentStatus.getExitCode() == null || agentStatus.getExitCode() == 0) continue;
                List failedAgentStatusList = failedAgentsByHostMap.computeIfAbsent(agentStatus.getHostName(), k -> new ArrayList());
                failedAgentStatusList.add(agentStatus);
            }
        }
        return failedAgentsByHostMap;
    }

    @Deprecated
    public static AgentControllerStatus getAgentControllerStatus(Set<AgentStatus> agentStatusList) {
        ArrayList<AgentStatusInfo> agentStatusInfoList = new ArrayList<AgentStatusInfo>();
        ArrayList<TestUserStatus> userStatusList = new ArrayList<TestUserStatus>();
        for (AgentStatus agentStatus : agentStatusList) {
            AgentStatusInfo agentStatusInfo = new AgentStatusInfo(agentStatus.getAgentID(), agentStatus.getHostName(), true, agentStatus.getErrorExitCode());
            agentStatusInfoList.add(agentStatusInfo);
            userStatusList.addAll(agentStatus.getTestUserStatusList());
        }
        List<ScenarioStatus> scenarioStatusList = StatusUtils.aggregateUserStatusList(userStatusList);
        return new AgentControllerStatus(agentStatusInfoList, scenarioStatusList);
    }

    @Deprecated
    public static List<ScenarioStatus> aggregateUserStatusList(List<TestUserStatus> userStatusList) {
        TreeMap<String, ScenarioStatus> scenarioStatusMap = new TreeMap<String, ScenarioStatus>();
        for (TestUserStatus userStatus : userStatusList) {
            String scenarioName = StringUtils.substringBeforeLast((String)userStatus.getUserName(), (String)"-");
            ScenarioStatus scenarioStatus = scenarioStatusMap.computeIfAbsent(scenarioName, StatusUtils::createInitialScenarioStatus);
            scenarioStatus.setTotalUsers(scenarioStatus.getTotalUsers() + 1);
            if (userStatus.getState() == TestUserStatus.State.Running) {
                scenarioStatus.setRunningUsers(scenarioStatus.getRunningUsers() + 1);
            }
            TestUserStatus.State state = userStatus.getState();
            if (scenarioStatus.getState() != TestUserStatus.State.Running && state != TestUserStatus.State.Waiting) {
                scenarioStatus.setState(state);
            }
            if (scenarioStatus.getLastModifiedDate() < userStatus.getLastModifiedDate()) {
                scenarioStatus.setLastModifiedDate(userStatus.getLastModifiedDate());
                scenarioStatus.setLastRuntime(userStatus.getLastRuntime());
            }
            if (userStatus.getMode() == TestUserStatus.Mode.TIME_PERIOD) {
                scenarioStatus.setPercentageComplete(Math.max(scenarioStatus.getPercentageComplete(), userStatus.getPercentageComplete()));
            } else {
                int totalUsers = scenarioStatus.getTotalUsers();
                if (totalUsers == 1) {
                    scenarioStatus.setPercentageComplete(userStatus.getPercentageComplete());
                } else {
                    double mean = scenarioStatus.getPercentageComplete();
                    mean += ((double)userStatus.getPercentageComplete() - mean) / (double)totalUsers;
                    scenarioStatus.setPercentageComplete((int)mean);
                }
            }
            scenarioStatus.setIterations(scenarioStatus.getIterations() + userStatus.getIterations());
            scenarioStatus.setTotalRuntime(scenarioStatus.getTotalRuntime() + userStatus.getTotalRuntime());
            scenarioStatus.setElapsedTime(Math.max(scenarioStatus.getElapsedTime(), userStatus.getElapsedTime()));
            scenarioStatus.setEvents(scenarioStatus.getEvents() + userStatus.getEvents());
            scenarioStatus.setErrors(scenarioStatus.getErrors() + userStatus.getErrors());
            scenarioStatus.setException((Exception)ObjectUtils.defaultIfNull((Object)userStatus.getException(), (Object)scenarioStatus.getException()));
            scenarioStatus.setStartDate(Math.min(scenarioStatus.getStartDate(), userStatus.getStartDate()));
        }
        return new ArrayList<ScenarioStatus>(scenarioStatusMap.values());
    }

    private static ScenarioStatus createInitialScenarioStatus(String scenarioName) {
        ScenarioStatus scenarioStatus = new ScenarioStatus();
        scenarioStatus.setScenarioName(scenarioName);
        scenarioStatus.setStartDate(Long.MAX_VALUE);
        scenarioStatus.setElapsedTime(Long.MIN_VALUE);
        return scenarioStatus;
    }
}

