/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.activex.javascript.msxml.MSXMLActiveXObjectFactory;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.ActiveXObjectImpl;

@JsxClass(value={SupportedBrowser.IE})
public class ActiveXObject
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(ActiveXObject.class);

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args, Function ctorObj, boolean inNewExpr) {
        String xClassString;
        Scriptable scriptable;
        if (args.length < 1 || args.length > 2) {
            throw JavaScriptEngine.reportRuntimeError("ActiveXObject Error: constructor must have one or two String parameters.");
        }
        if (JavaScriptEngine.isUndefined(args[0])) {
            throw JavaScriptEngine.reportRuntimeError("ActiveXObject Error: constructor parameter is undefined.");
        }
        if (!(args[0] instanceof String)) {
            throw JavaScriptEngine.reportRuntimeError("ActiveXObject Error: constructor parameter must be a String.");
        }
        String activeXName = (String)args[0];
        WebWindow window = ActiveXObject.getWindow((Scriptable)ctorObj).getWebWindow();
        MSXMLActiveXObjectFactory factory = window.getWebClient().getMSXMLActiveXObjectFactory();
        if (factory.supports(activeXName) && (scriptable = factory.create(activeXName, window)) != null) {
            return scriptable;
        }
        WebClient webClient = ActiveXObject.getWindow((Scriptable)ctorObj).getWebWindow().getWebClient();
        Map<String, String> map = webClient.getActiveXObjectMap();
        if (map != null && (xClassString = map.get(activeXName)) != null) {
            try {
                Class<?> xClass = Class.forName(xClassString);
                Object object = xClass.newInstance();
                return Context.toObject(object, (Scriptable)ctorObj);
            }
            catch (Exception e) {
                throw JavaScriptEngine.reportRuntimeError("ActiveXObject Error: failed instantiating class " + xClassString + " because " + e.getMessage() + ".");
            }
        }
        if (webClient.getOptions().isActiveXNative() && System.getProperty("os.name").contains("Windows")) {
            try {
                return new ActiveXObjectImpl(activeXName);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error initiating Jacob", (Throwable)e);
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Automation server can't create object for '" + activeXName + "'."));
        }
        throw JavaScriptEngine.reportRuntimeError("Automation server can't create object for '" + activeXName + "'.");
    }

    public static void addProperty(HtmlUnitScriptable scriptable, String propertyName, boolean isGetter, boolean isSetter) {
        String initialUpper = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String getterName = null;
        if (isGetter) {
            getterName = "get" + initialUpper;
        }
        String setterName = null;
        if (isSetter) {
            setterName = "set" + initialUpper;
        }
        ActiveXObject.addProperty(scriptable, propertyName, getterName, setterName);
    }

    static void addProperty(HtmlUnitScriptable scriptable, String propertyName, String getterMethodName, String setterMethodName) {
        scriptable.defineProperty(propertyName, null, ActiveXObject.getMethod(scriptable.getClass(), getterMethodName, JsxGetter.class), ActiveXObject.getMethod(scriptable.getClass(), setterMethodName, JsxSetter.class), 4);
    }

    static Method getMethod(Class<? extends HtmlUnitScriptable> clazz, String name, Class<? extends Annotation> annotationClass) {
        if (name == null) {
            return null;
        }
        Method foundMethod = null;
        int foundByNameOnlyCount = 0;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            if (null != method.getAnnotation(annotationClass)) {
                return method;
            }
            ++foundByNameOnlyCount;
            foundMethod = method;
        }
        if (foundByNameOnlyCount > 1) {
            throw new IllegalArgumentException("Found " + foundByNameOnlyCount + " methods for name '" + name + "' in class '" + clazz + "'.");
        }
        return foundMethod;
    }
}

