/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.css.CssMediaList;
import org.htmlunit.css.CssStyleSheet;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSImportRuleImpl;
import org.htmlunit.cssparser.dom.MediaListImpl;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.css.CSSRule;
import org.htmlunit.javascript.host.css.CSSStyleSheet;
import org.htmlunit.javascript.host.css.MediaList;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass
public class CSSImportRule
extends CSSRule {
    private MediaList media_;
    private CSSStyleSheet importedStylesheet_;

    public CSSImportRule() {
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        super.jsConstructor();
    }

    protected CSSImportRule(CSSStyleSheet stylesheet, CSSImportRuleImpl rule) {
        super(stylesheet, (AbstractCSSRuleImpl)rule);
    }

    @JsxGetter
    public String getHref() {
        return this.getImportRule().getHref();
    }

    @JsxGetter
    public MediaList getMedia() {
        if (this.media_ == null) {
            CSSStyleSheet parent = this.getParentStyleSheet();
            MediaListImpl ml = this.getImportRule().getMedia();
            this.media_ = new MediaList(parent, new CssMediaList(ml));
        }
        return this.media_;
    }

    @JsxGetter
    public CSSStyleSheet getStyleSheet() {
        if (this.importedStylesheet_ == null) {
            CSSStyleSheet owningSheet = this.getParentStyleSheet();
            HTMLElement ownerNode = owningSheet.getOwnerNode();
            CssStyleSheet importedSheet = owningSheet.getCssStyleSheet().getImportedStyleSheet(this.getImportRule());
            this.importedStylesheet_ = new CSSStyleSheet(null, (Scriptable)ownerNode.getWindow(), importedSheet);
        }
        return this.importedStylesheet_;
    }

    private CSSImportRuleImpl getImportRule() {
        return (CSSImportRuleImpl)this.getRule();
    }

    @Override
    public String getCssText() {
        String cssText = super.getCssText();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_CSSTEXT_IE_STYLE)) {
            cssText = REPLACEMENT_IE.matcher(cssText).replaceFirst("url( $1 )");
        }
        return cssText;
    }
}

