/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.css.CssStyleSheet;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSCharsetRuleImpl;
import org.htmlunit.cssparser.dom.CSSRuleListImpl;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.cssparser.parser.InputSource;
import org.htmlunit.cssparser.parser.selector.SelectorList;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.css.CSSRule;
import org.htmlunit.javascript.host.css.CSSRuleList;
import org.htmlunit.javascript.host.css.StyleSheet;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.w3c.dom.DOMException;

@JsxClass
public class CSSStyleSheet
extends StyleSheet {
    private static final Log LOG = LogFactory.getLog(CSSStyleSheet.class);
    private CssStyleSheet styleSheet_;
    private CSSRuleList cssRules_;
    private List<Integer> cssRulesIndexFix_;

    public CSSStyleSheet() {
        super(null);
        this.styleSheet_ = new CssStyleSheet(null, (InputSource)null, null);
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        super.jsConstructor();
        this.styleSheet_ = new CssStyleSheet(null, (InputSource)null, null);
    }

    public CSSStyleSheet(HTMLElement element, InputSource source, String uri) {
        super(element);
        this.setParentScope((Scriptable)element.getWindow());
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.styleSheet_ = new CssStyleSheet(element.getDomNodeOrDie(), source, uri);
    }

    public CSSStyleSheet(HTMLElement element, String styleSheet, String uri) {
        super(element);
        Window win = element.getWindow();
        CssStyleSheet css = null;
        try (InputSource source = new InputSource((Reader)new StringReader(styleSheet));){
            css = new CssStyleSheet(element.getDomNodeOrDie(), source, uri);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        this.setParentScope((Scriptable)win);
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.styleSheet_ = css;
    }

    public CSSStyleSheet(HTMLElement element, Scriptable parentScope, CssStyleSheet cssStyleSheet) {
        super(element);
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.styleSheet_ = cssStyleSheet;
    }

    public CssStyleSheet getCssStyleSheet() {
        return this.styleSheet_;
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public HTMLElement getOwnerNode() {
        return super.getOwnerNode();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public HTMLElement getOwningElement() {
        return this.getOwnerNode();
    }

    @JsxGetter
    public CSSRuleList getRules() {
        return this.getCssRules();
    }

    @JsxGetter
    public CSSRuleList getCssRules() {
        this.initCssRules();
        return this.cssRules_;
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public String getHref() {
        return super.getHref();
    }

    @JsxFunction
    public int insertRule(String rule, int position) {
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().insertRule(rule, this.fixIndex(position));
            this.refreshCssRules();
            return position;
        }
        catch (DOMException e) {
            int pos = rule.indexOf(123);
            if (pos > -1) {
                String newRule = rule.substring(0, pos) + "{}";
                try {
                    this.getCssStyleSheet().getWrappedSheet().insertRule(newRule, this.fixIndex(position));
                    this.refreshCssRules();
                    return position;
                }
                catch (DOMException ex) {
                    throw JavaScriptEngine.throwAsScriptRuntimeEx(ex);
                }
            }
            throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
        }
    }

    private void refreshCssRules() {
        if (this.cssRules_ == null) {
            return;
        }
        this.cssRules_.clearRules();
        this.cssRulesIndexFix_.clear();
        CSSRuleListImpl ruleList = this.getCssStyleSheet().getWrappedSheet().getCssRules();
        List rules = ruleList.getRules();
        int pos = 0;
        for (AbstractCSSRuleImpl rule : rules) {
            if (rule instanceof CSSCharsetRuleImpl) {
                this.cssRulesIndexFix_.add(pos);
                continue;
            }
            CSSRule cssRule = CSSRule.create(this, rule);
            if (null == cssRule) {
                this.cssRulesIndexFix_.add(pos);
            } else {
                this.cssRules_.addRule(cssRule);
            }
            ++pos;
        }
        this.getCssStyleSheet().getWrappedSheet().resetRuleIndex();
    }

    private int fixIndex(int index) {
        for (int fix : this.cssRulesIndexFix_) {
            if (fix > index) {
                return index;
            }
            ++index;
        }
        return index;
    }

    @JsxFunction
    public void deleteRule(int position) {
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction
    public int addRule(String selector, String rule) {
        String completeRule = selector + " {" + rule + "}";
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().insertRule(completeRule, this.getCssStyleSheet().getWrappedSheet().getCssRules().getLength());
            this.refreshCssRules();
        }
        catch (DOMException e) {
            completeRule = selector + " {}";
            try {
                this.getCssStyleSheet().getWrappedSheet().insertRule(completeRule, this.getCssStyleSheet().getWrappedSheet().getCssRules().getLength());
                this.refreshCssRules();
            }
            catch (DOMException ex) {
                throw JavaScriptEngine.throwAsScriptRuntimeEx(ex);
            }
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.STYLESHEET_ADD_RULE_RETURNS_POS)) {
            return this.getCssStyleSheet().getWrappedSheet().getCssRules().getLength() - 1;
        }
        return -1;
    }

    @JsxFunction
    public void removeRule(int position) {
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
        }
    }

    @Override
    public String getUri() {
        return this.getCssStyleSheet().getUri();
    }

    @Deprecated
    public static void validateSelectors(SelectorList selectorList, int documentMode, DomNode domNode) throws CSSException {
        CssStyleSheet.validateSelectors(selectorList, documentMode, domNode);
    }

    private void initCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleList(this);
            this.cssRulesIndexFix_ = new ArrayList<Integer>();
            this.refreshCssRules();
        }
    }
}

