/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlBase;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlBase.class)
public class HTMLBaseElement
extends HTMLElement {
    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public String getHref() {
        String href = this.getDomNodeOrDie().getAttributeDirect("href");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLBASE_HREF_DEFAULT_EMPTY)) {
                return href;
            }
            return this.getWindow().getLocation().getHref();
        }
        return href;
    }

    @JsxSetter
    public void setHref(String href) {
        this.getDomNodeOrDie().setAttribute("href", href);
    }

    @JsxGetter
    public String getTarget() {
        return this.getDomNodeOrDie().getAttributeDirect("target");
    }

    @JsxSetter
    public void setTarget(String target) {
        this.getDomNodeOrDie().setAttribute("target", target);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }
}

