/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.xceptance.common.util.StreamPump;
import com.xceptance.xlt.agentcontroller.Agent;
import com.xceptance.xlt.agentcontroller.AgentListener;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentImpl
implements Agent {
    private static final Logger log = LoggerFactory.getLogger(AgentImpl.class);
    private final AgentListener agentListener;
    private final ProcessMonitor monitor;
    private final Process process;
    private final OutputStream stdin;
    private final List<TestUserConfiguration> loadProfile;
    private final String agentID;
    private AgentStatus status;
    private final AtomicBoolean isStopped = new AtomicBoolean();

    public AgentImpl(String agentID, String[] commandLine, File resultsDir, List<TestUserConfiguration> loadProfile, AgentListener agentListener, File workingDirectory) throws Exception {
        this.agentID = agentID;
        this.loadProfile = loadProfile;
        this.agentListener = agentListener;
        FileUtils.forceMkdir((File)resultsDir);
        com.xceptance.common.io.FileUtils.cleanDirRelaxed(resultsDir);
        ProcessBuilder procBuilder = new ProcessBuilder(commandLine);
        procBuilder.directory(workingDirectory);
        this.process = procBuilder.start();
        this.monitor = new ProcessMonitor();
        this.monitor.setDaemon(true);
        this.monitor.start();
        this.stdin = this.process.getOutputStream();
        StreamPump stdoutLogger = new StreamPump(this.process.getInputStream(), new File(resultsDir, "agent-stdout.log"));
        stdoutLogger.setDaemon(true);
        stdoutLogger.start();
        StreamPump stderrLogger = new StreamPump(this.process.getErrorStream(), new File(resultsDir, "agent-stderr.log"));
        stderrLogger.setDaemon(true);
        stderrLogger.start();
    }

    private void agentStopped() {
        if (this.agentListener != null) {
            this.agentListener.agentStopped(this.agentID);
        }
    }

    private void agentExitedUnexpectedly(int exitCode) {
        if (this.agentListener != null) {
            this.agentListener.agentExitedUnexpectedly(this.agentID, exitCode);
        }
    }

    public AgentListener getAgentListener() {
        return this.agentListener;
    }

    @Override
    public AgentStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isRunning() {
        return this.monitor.isAlive();
    }

    @Override
    public void setStatus(AgentStatus status) {
        this.status = status;
    }

    @Override
    public void stop() {
        boolean wasStopped = this.isStopped.getAndSet(true);
        if (!wasStopped) {
            new StopThread().start();
        }
    }

    public List<TestUserConfiguration> getLoadProfile() {
        return this.loadProfile;
    }

    private class StopThread
    extends Thread {
        private StopThread() {
        }

        @Override
        public void run() {
            IOUtils.closeQuietly((OutputStream)AgentImpl.this.stdin);
            try {
                AgentImpl.this.monitor.join(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (AgentImpl.this.monitor.isAlive()) {
                AgentImpl.this.process.descendants().forEach(ProcessHandle::destroyForcibly);
                AgentImpl.this.process.destroyForcibly();
            }
        }
    }

    class ProcessMonitor
    extends Thread {
        ProcessMonitor() {
        }

        @Override
        public void run() {
            log.debug("Started agent process monitoring thread.");
            try {
                int exitCode = AgentImpl.this.process.waitFor();
                if (!AgentImpl.this.isStopped.get() && exitCode != 0) {
                    AgentImpl.this.agentExitedUnexpectedly(exitCode);
                }
            }
            catch (Exception ex) {
                log.error("An error occurred while waiting for the agent process to die: ", (Throwable)ex);
            }
            AgentImpl.this.agentStopped();
        }
    }
}

