/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;

public class GlobalClock {
    private static Clock clock = Clock.systemUTC();
    private static final VarHandle clockHandle;
    private static final VarHandle offsetMillisHandle;
    private static long offsetMillis;

    public static Clock get() {
        return clock;
    }

    public static long millis() {
        return clock.millis();
    }

    public static long offset() {
        return offsetMillis;
    }

    public static Clock install(Clock clock) {
        clockHandle.setVolatile(clock);
        offsetMillisHandle.setVolatile(0L);
        return clock;
    }

    public static Clock installWithOffset(long offsetinMillis) {
        clockHandle.setVolatile(Clock.offset(clock, Duration.ofMillis(offsetinMillis)));
        offsetMillisHandle.setVolatile(offsetinMillis);
        return clock;
    }

    public static Clock installFixed(long epochMillis) {
        clockHandle.setVolatile(Clock.fixed(Instant.ofEpochMilli(epochMillis), ZoneOffset.UTC));
        offsetMillisHandle.setVolatile(0L);
        return clock;
    }

    public static Clock reset() {
        return GlobalClock.install(Clock.systemUTC());
    }

    static {
        try {
            clockHandle = MethodHandles.lookup().findStaticVarHandle(GlobalClock.class, "clock", Clock.class);
            offsetMillisHandle = MethodHandles.lookup().findStaticVarHandle(GlobalClock.class, "offsetMillis", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

