/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import com.xceptance.common.lang.ParseBoolean;
import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.xlt.api.engine.AbstractData;
import com.xceptance.xlt.api.util.XltCharBuffer;
import java.util.List;

public abstract class TimerData
extends AbstractData {
    private int runTime;
    private boolean failed;

    public TimerData(char typeCode) {
        super(typeCode);
    }

    public TimerData(String name, char typeCode) {
        super(name, typeCode);
    }

    public long getEndTime() {
        return this.getTime() + (long)this.runTime;
    }

    public int getRunTime() {
        return this.runTime;
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public void setRunTime(long runTime) {
        this.runTime = (int)runTime;
    }

    public void setRunTime(int runTime) {
        this.runTime = runTime;
    }

    @Override
    public List<String> toList() {
        List<String> fields = super.toList();
        fields.add(Long.toString(this.runTime));
        fields.add(Boolean.toString(this.failed));
        return fields;
    }

    @Override
    public void setRemainingValues(List<XltCharBuffer> values) {
        this.runTime = ParseNumbers.parseInt(values.get(3));
        if (this.runTime < 0) {
            throw new IllegalArgumentException("Invalid value for the 'runtime' attribute.");
        }
        this.failed = ParseBoolean.parse(values.get(4));
    }
}

