/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.report.external;

import com.xceptance.xlt.api.report.external.ValueSet;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;

public abstract class AbstractLineParser {
    private static final String PROP_FORMAT_PATTERN = "parser.dateFormat.pattern";
    private static final String PROP_FORMAT_TIMEZONE = "parser.dateFormat.timeZone";
    private Set<String> valueNames;
    private Properties properties;
    private static DateFormat FORMAT;

    public abstract ValueSet parse(String var1);

    protected long parseTime(String timeString) {
        try {
            return Long.valueOf(timeString);
        }
        catch (NumberFormatException nfe) {
            try {
                return this.getDateFormat().parse(timeString).getTime();
            }
            catch (ParseException pe) {
                return -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DateFormat getDateFormat() {
        if (FORMAT != null) return FORMAT;
        Class<AbstractLineParser> clazz = AbstractLineParser.class;
        synchronized (AbstractLineParser.class) {
            if (FORMAT != null) return FORMAT;
            if (this.getProperties() == null) {
                throw new NullPointerException("Properties have not been set for the parser. Set them first!");
            }
            String formatterPattern = this.getProperties().getProperty(PROP_FORMAT_PATTERN, "dd.MM.yyyy HH:mm:ss");
            String formatterTimeZone = this.getProperties().getProperty(PROP_FORMAT_TIMEZONE, "GMT+0");
            FORMAT = new SimpleDateFormat(formatterPattern);
            FORMAT.setTimeZone(TimeZone.getTimeZone(formatterTimeZone));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return FORMAT;
        }
    }

    public void setValueNames(Set<String> valueNames) {
        this.valueNames = valueNames;
    }

    public Set<String> getValueNames() {
        return this.valueNames;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

