/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.report.external;

import com.xceptance.common.util.CsvUtils;
import com.xceptance.xlt.api.report.external.AbstractLineParser;
import com.xceptance.xlt.api.report.external.ValueSet;
import java.util.List;

public class SimpleCsvParser
extends AbstractLineParser {
    private static final String PROP_FIELD_SEPARATOR = "parser.csv.separator";
    private char fieldSeparator = '\u0000';

    @Override
    public ValueSet parse(String line) {
        List<String> csv = CsvUtils.decode(line, this.getFieldSeparator());
        long time = this.parseTime(csv.get(0));
        ValueSet dp = new ValueSet(time);
        for (int i = 1; i < csv.size(); ++i) {
            String name = this.getName(i);
            if (this.getValueNames() == null || !this.getValueNames().contains(name)) continue;
            dp.addValue(name, Double.valueOf(csv.get(i)));
        }
        return dp;
    }

    protected String getName(int i) {
        return String.valueOf(i);
    }

    protected char getFieldSeparator() {
        if (this.fieldSeparator == '\u0000') {
            if (this.getProperties() == null) {
                throw new IllegalStateException("Properties have not been set! Set them first.");
            }
            String separatorProp = this.getProperties().getProperty(PROP_FIELD_SEPARATOR, ",");
            this.fieldSeparator = (char)(separatorProp.length() == 0 ? 44 : (int)separatorProp.charAt(0));
        }
        return this.fieldSeparator;
    }
}

