/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.util;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.util.ResponseProcessor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.htmlunit.WebResponse;
import org.htmlunit.WebResponseData;
import org.htmlunit.util.NameValuePair;

public abstract class AbstractResponseProcessor
implements ResponseProcessor {
    protected WebResponse createWebResponse(WebResponse originalWebResponse, byte[] content) {
        ParameterCheckUtils.isNotNull(originalWebResponse, "originalWebResponse");
        ParameterCheckUtils.isNotNull(content, "content");
        return this.makeResponse(originalWebResponse, content);
    }

    protected WebResponse createWebResponse(WebResponse originalWebResponse, String content) {
        ParameterCheckUtils.isNotNull(originalWebResponse, "originalWebResponse");
        ParameterCheckUtils.isNotNull(content, "content");
        Charset charSet = originalWebResponse.getContentCharset();
        return this.makeResponse(originalWebResponse, content.getBytes(charSet));
    }

    private WebResponse makeResponse(WebResponse originalWebResponse, byte[] responseData) {
        try {
            ModifiedWebResponseData modifiedWebResponseData = new ModifiedWebResponseData(originalWebResponse, responseData);
            return new WebResponse(modifiedWebResponseData, originalWebResponse.getWebRequest(), originalWebResponse.getLoadTime());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to make response", e);
        }
    }

    private static List<NameValuePair> fixContentLengthHeader(List<NameValuePair> responseHeaders, int length) {
        if (responseHeaders == null || responseHeaders.isEmpty()) {
            return responseHeaders;
        }
        ArrayList<NameValuePair> fixedHeaders = new ArrayList<NameValuePair>();
        for (NameValuePair header : responseHeaders) {
            String headerName = header.getName();
            if (!"Content-Length".equals(headerName)) {
                fixedHeaders.add(header);
                continue;
            }
            fixedHeaders.add(new NameValuePair(headerName, Integer.toString(length)));
        }
        return fixedHeaders;
    }

    private static class ModifiedWebResponseData
    extends WebResponseData {
        private static final long serialVersionUID = 7571849792027379514L;
        private final byte[] body;

        public ModifiedWebResponseData(WebResponse originalResponse, byte[] body) throws IOException {
            super(originalResponse.getStatusCode(), originalResponse.getStatusMessage(), AbstractResponseProcessor.fixContentLengthHeader(originalResponse.getResponseHeaders(), body.length));
            this.body = body;
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.body);
        }

        @Override
        public InputStream getInputStreamWithBomIfApplicable(ByteOrderMark ... bomHeaders) throws IOException {
            return this.getInputStream();
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }
    }
}

