/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.clientperformance;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.tyrus.server.Server;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPerformanceExtensionConnector {
    private static final Logger LOG = LoggerFactory.getLogger(ClientPerformanceExtensionConnector.class);
    private final Map<Session, ClientPerformanceExtensionConnection> connections = Collections.synchronizedMap(new HashMap());
    private final BlockingQueue<ClientPerformanceExtensionConnection> connectionQueue = new LinkedBlockingQueue<ClientPerformanceExtensionConnection>();
    private final ConnectionListener connectionListener;
    private final String id = String.valueOf(System.identityHashCode(this));

    public ClientPerformanceExtensionConnector(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public String getID() {
        return this.id;
    }

    public int getPort() {
        InetSocketAddress address = WebSocketServerEndpoint.getAddress();
        if (address != null) {
            return address.getPort();
        }
        return 0;
    }

    public void start() throws CommunicationException {
        WebSocketServerEndpoint.start(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int timeout) {
        Map<Session, ClientPerformanceExtensionConnection> map = this.connections;
        synchronized (map) {
            for (ClientPerformanceExtensionConnection eachConnection : this.connections.values()) {
                eachConnection.close();
            }
        }
        WebSocketServerEndpoint.stop(this);
        this.connections.clear();
        this.connectionQueue.clear();
    }

    public ClientPerformanceExtensionConnection waitForNextConnection(long timeout) throws TimeoutException, CommunicationException, InterruptedException {
        this.start();
        ClientPerformanceExtensionConnection connection = null;
        while (connection == null || !connection.isOpen()) {
            connection = this.connectionQueue.poll(timeout, TimeUnit.MILLISECONDS);
            if (connection != null) continue;
            throw new TimeoutException("No connection was made within the expected time frame");
        }
        return connection;
    }

    public ClientPerformanceExtensionConnection waitForNextConnection() throws InterruptedException, CommunicationException {
        this.start();
        ClientPerformanceExtensionConnection connection = null;
        while (connection == null || !connection.isOpen()) {
            connection = this.connectionQueue.take();
        }
        return connection;
    }

    private void onOpen(Session conn) {
        ClientPerformanceExtensionConnection extensionConnection = new ClientPerformanceExtensionConnection(conn, this.connectionListener);
        conn.setMaxIdleTimeout(0L);
        this.connections.put(conn, extensionConnection);
        this.connectionListener.onConnect(this, extensionConnection);
        try {
            this.connectionQueue.put(extensionConnection);
        }
        catch (InterruptedException e) {
            LOG.warn("", (Throwable)e);
        }
    }

    private void onClose(Session conn, CloseReason closeReason) {
        ClientPerformanceExtensionConnection extensionConnection = this.connections.remove(conn);
        if (extensionConnection != null) {
            extensionConnection.onClose();
        } else {
            LOG.warn("Closed unwrapped connection");
        }
    }

    private void onError(Session conn, Throwable ex) {
        ClientPerformanceExtensionConnection extensionConnection = this.connections.get(conn);
        if (extensionConnection != null) {
            extensionConnection.onError(ex);
        } else {
            LOG.warn("Error for unwrapped connection", ex);
        }
    }

    private void onMessage(Session conn, String message) {
        ClientPerformanceExtensionConnection extensionConnection = this.connections.get(conn);
        if (extensionConnection != null) {
            extensionConnection.onMessage(message);
        } else {
            LOG.warn("Message received for unwrapped connection");
        }
    }

    private static class Message {
        private final String messageID;
        private final JSONObject data;

        private Message(String messageID, JSONObject data) {
            this.messageID = messageID;
            this.data = data;
        }

        public String getMessageID() {
            return this.messageID;
        }

        public JSONObject getMessageData() {
            return this.data;
        }

        public String toString() {
            return "messageID: " + this.messageID + ", data: " + this.data;
        }
    }

    public static class Responder {
        private final Message request;
        private final ClientPerformanceExtensionConnection connection;

        private Responder(ClientPerformanceExtensionConnection connection, Message request) {
            this.request = request;
            this.connection = connection;
        }

        public void respond(JSONObject response) throws CommunicationException {
            Message answer = new Message(this.request.getMessageID(), response);
            this.connection.send(answer);
        }
    }

    private static class ResponseWaitLock
    extends CountDownLatch {
        private Message response;
        private boolean aborted = false;

        public ResponseWaitLock() {
            super(1);
        }

        public Message getResponse() {
            return this.response;
        }

        public void setResponse(Message response) {
            this.response = response;
            this.countDown();
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void abort() {
            this.aborted = true;
            this.countDown();
        }
    }

    public static class CommunicationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CommunicationException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }

    public static interface ResponseHandler {
        public void onResponse(JSONObject var1);

        public void onTimeout();

        public void onError(CommunicationException var1);
    }

    public static class ClientPerformanceExtensionConnection {
        private final ConnectionListener connectionListener;
        private final Session connection;
        private final AtomicLong messageIndex = new AtomicLong(0L);
        private final Map<String, ResponseWaitLock> responseWaits = Collections.synchronizedMap(new HashMap());

        private ClientPerformanceExtensionConnection(Session con, ConnectionListener connectionListener) {
            this.connection = con;
            this.connectionListener = connectionListener;
        }

        public boolean isOpen() {
            return this.connection.isOpen();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientPerformanceExtensionConnection close() {
            try {
                if (this.connection.isOpen()) {
                    this.connection.close();
                }
            }
            catch (IOException e) {
                this.notifyOnErrorListener(new CommunicationException("Failed to close connection", e));
            }
            Map<String, ResponseWaitLock> map = this.responseWaits;
            synchronized (map) {
                for (ResponseWaitLock eachLock : this.responseWaits.values()) {
                    eachLock.abort();
                }
            }
            this.responseWaits.clear();
            return this;
        }

        private void onMessage(String message) {
            try {
                ResponseWaitLock responseWait;
                Message deserializedMessage = this.deserializeMessage(message);
                String messageID = deserializedMessage.getMessageID();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received message " + deserializedMessage);
                }
                if ((responseWait = this.responseWaits.get(messageID)) != null) {
                    responseWait.setResponse(deserializedMessage);
                } else {
                    this.notifyOnMessageListener(deserializedMessage);
                }
            }
            catch (CommunicationException e) {
                this.notifyOnErrorListener(e);
            }
        }

        private void onError(Throwable ex) {
            this.notifyOnErrorListener(new CommunicationException("", ex));
        }

        private void onClose() {
            this.notifyOnCloseListener();
            this.close();
        }

        private void notifyOnMessageListener(Message message) {
            this.connectionListener.onMessage(this, message.getMessageData(), new Responder(this, message));
        }

        private void notifyOnErrorListener(CommunicationException error) {
            this.connectionListener.onError(this, error);
        }

        private void notifyOnCloseListener() {
            this.connectionListener.onClose(this);
        }

        private String nextMessageID() {
            return String.valueOf(System.identityHashCode(this)) + this.messageIndex.getAndIncrement();
        }

        private Message deserializeMessage(String message) throws CommunicationException {
            try {
                JSONObject messageObject = new JSONObject(message);
                String messageID = messageObject.getString("messageID");
                JSONObject data = null;
                if (!messageObject.has("data") || messageObject.isNull("data")) {
                    throw new CommunicationException("No data for message: \"" + message + "\"", null);
                }
                data = messageObject.getJSONObject("data");
                return new Message(messageID, data);
            }
            catch (JSONException e) {
                throw new CommunicationException("Failed to deserialize message: \"" + message + "\"", e);
            }
        }

        private String serializeMessage(Message message) throws CommunicationException {
            String messageID = message.getMessageID();
            String data = message.getMessageData().toString();
            if (StringUtils.isBlank((CharSequence)message.messageID)) {
                throw new CommunicationException("No ID for message: \"" + message + "\"", null);
            }
            if (StringUtils.isBlank((CharSequence)data)) {
                throw new CommunicationException("No data for message: \"" + message + "\"", null);
            }
            return "{\"messageID\":\"" + messageID + "\",\"data\":" + data + "}";
        }

        private ClientPerformanceExtensionConnection send(Message message) throws CommunicationException {
            String serializedMessage = this.serializeMessage(message);
            try {
                this.connection.getBasicRemote().sendText(serializedMessage);
            }
            catch (IOException e) {
                throw new CommunicationException("Failed to send message", e);
            }
            return this;
        }

        public ClientPerformanceExtensionConnection sendMessage(JSONObject data) throws CommunicationException {
            return this.send(new Message(this.nextMessageID(), data));
        }

        public JSONObject sendRequest(JSONObject data, int timeoutMilliseconds) throws CommunicationException, TimeoutException {
            Message message = new Message(this.nextMessageID(), data);
            String messageID = message.getMessageID();
            ResponseWaitLock waitBarrier = new ResponseWaitLock();
            this.responseWaits.put(messageID, waitBarrier);
            this.send(message);
            try {
                boolean isTimeout;
                boolean bl = isTimeout = !waitBarrier.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
                if (isTimeout) {
                    throw new TimeoutException("No answer was received within the maximum time");
                }
                if (waitBarrier.isAborted()) {
                    throw new CommunicationException("Communication aborted", null);
                }
            }
            catch (InterruptedException e) {
                throw new CommunicationException("Communication aborted", e);
            }
            finally {
                this.responseWaits.remove(messageID);
            }
            return waitBarrier.getResponse().getMessageData();
        }
    }

    public static interface ConnectionListener {
        public void onConnect(ClientPerformanceExtensionConnector var1, ClientPerformanceExtensionConnection var2);

        public void onMessage(ClientPerformanceExtensionConnection var1, JSONObject var2, Responder var3);

        public void onError(ClientPerformanceExtensionConnection var1, CommunicationException var2);

        public void onClose(ClientPerformanceExtensionConnection var1);
    }

    @ServerEndpoint(value="/{client-id}")
    public static final class WebSocketServerEndpoint {
        private static final Map<String, ClientPerformanceExtensionConnector> connectors = Collections.synchronizedMap(new HashMap());
        private static volatile Server server;
        private static volatile InetSocketAddress address;

        private static synchronized InetSocketAddress getAddress() {
            return address;
        }

        private static boolean isRunning() {
            return server != null;
        }

        private static void addEndpointListener(ClientPerformanceExtensionConnector connector) {
            connectors.put(connector.getID(), connector);
        }

        private static void removeEndpointListener(ClientPerformanceExtensionConnector connector) {
            connectors.remove(connector.getID());
        }

        private static void start(ClientPerformanceExtensionConnector connector) throws CommunicationException {
            WebSocketServerEndpoint.start("/xlt", connector);
        }

        private static void start(String endPointPath, ClientPerformanceExtensionConnector connector) throws CommunicationException {
            WebSocketServerEndpoint.start(new InetSocketAddress("127.0.0.1", 0), endPointPath, connector);
        }

        private static synchronized void start(InetSocketAddress address, String endPointPath, ClientPerformanceExtensionConnector connector) throws CommunicationException {
            WebSocketServerEndpoint.addEndpointListener(connector);
            if (!WebSocketServerEndpoint.isRunning()) {
                try {
                    int portToUse = address.getPort();
                    if (portToUse <= 0) {
                        portToUse = -1;
                    }
                    server = new Server(address.getHostString(), portToUse, endPointPath, null, new Class[]{WebSocketServerEndpoint.class});
                    server.start();
                    WebSocketServerEndpoint.address = new InetSocketAddress(address.getAddress(), server.getPort());
                }
                catch (DeploymentException e) {
                    WebSocketServerEndpoint.kill();
                    throw new CommunicationException("Initializing extension communication failed", e);
                }
            }
        }

        private static void stop(ClientPerformanceExtensionConnector connector) {
            if (connectors.size() <= 1) {
                WebSocketServerEndpoint.kill();
            }
            WebSocketServerEndpoint.removeEndpointListener(connector);
        }

        private static synchronized void kill() {
            if (WebSocketServerEndpoint.isRunning()) {
                server.stop();
            }
            connectors.clear();
            server = null;
        }

        @OnOpen
        public void onOpen(Session conn, EndpointConfig config, @PathParam(value="client-id") String clientID) {
            ClientPerformanceExtensionConnector connector = connectors.get(clientID);
            if (connector != null) {
                connector.onOpen(conn);
            } else {
                LOG.warn("No open handler available for clientID: " + clientID);
                try {
                    conn.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TRY_AGAIN_LATER, "No connection handler available for clientID"));
                }
                catch (IOException e) {
                    LOG.warn("", (Throwable)e);
                }
            }
        }

        @OnClose
        public void onClose(Session conn, CloseReason closeReason, @PathParam(value="client-id") String clientID) {
            ClientPerformanceExtensionConnector connector = connectors.get(clientID);
            if (connector != null) {
                connector.onClose(conn, closeReason);
            } else {
                LOG.warn("No close handler available for clientID: " + clientID);
            }
        }

        @OnError
        public void onError(Session conn, Throwable ex, @PathParam(value="client-id") String clientID) {
            ClientPerformanceExtensionConnector connector = connectors.get(clientID);
            if (connector != null) {
                connector.onError(conn, ex);
            } else {
                LOG.warn("No error handler available for clientID: " + clientID);
            }
        }

        @OnMessage
        public void onMessage(Session conn, String message, @PathParam(value="client-id") String clientID) {
            ClientPerformanceExtensionConnector connector = connectors.get(clientID);
            if (connector != null) {
                connector.onMessage(conn, message);
            } else {
                LOG.warn("No message handler available for clientID: " + clientID);
            }
        }
    }
}

