/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.clientperformance;

import com.xceptance.common.lang.ThreadUtils;
import com.xceptance.common.util.ParseUtils;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltProperties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientPerformanceUtils {
    private static final String XVFB_SCREEN_PROPERTY = "xlt.clientperformance.xvfb.screen";
    private static final String XVFB_SCREEN_CONFIG;
    private static final Logger LOG;
    private static final Object mutex;
    private static final List<Process> XVFB_PROCESSES;
    private static final ConcurrentHashMap<Thread, String> DISPLAYS;
    private static final String PATH_TO_XVFB_EXE;

    public static String getDisplay() {
        if (PATH_TO_XVFB_EXE == null) {
            return null;
        }
        Thread thread = Thread.currentThread();
        String display = DISPLAYS.get(thread);
        if (display == null) {
            display = ClientPerformanceUtils.getFreeDisp();
            DISPLAYS.put(thread, display);
            LOG.debug("Using X display '" + display + "' for thread '" + thread.getName() + "'");
        } else {
            LOG.debug("Reusing X display '" + display + "' for thread '" + thread.getName() + "'");
        }
        return display;
    }

    private static String getScreenConfig() {
        Matcher matcher;
        String defaultScreenConfig = "1600x1200x24";
        String screenConfig = XltProperties.getInstance().getProperty(XVFB_SCREEN_PROPERTY);
        if (screenConfig != null && (matcher = Pattern.compile("(\\d+)x(\\d+)x(\\d+)").matcher(screenConfig.trim())).matches() && matcher.groupCount() == 3) {
            int width = ParseUtils.parseInt(matcher.group(1), -1);
            int height = ParseUtils.parseInt(matcher.group(2), -1);
            int depth = ParseUtils.parseInt(matcher.group(3), -1);
            if (width > 0 && height > 0 && depth > 0 && depth % 8 == 0 && depth <= 32) {
                return screenConfig;
            }
            LOG.error("Specified Xvfb screen configuration '" + screenConfig + "' is invalid; will use default of '1600x1200x24'");
        }
        return "1600x1200x24";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File checkForExecutable(String executable) {
        if (!SystemUtils.IS_OS_UNIX) return null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            Process p = Runtime.getRuntime().exec("which " + executable);
            int returnValue = p.waitFor();
            IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)bos);
            if (returnValue != 0) return null;
            String found = new String(bos.toByteArray()).trim();
            File exe = new File(found);
            if (!exe.exists()) return null;
            if (!exe.canRead()) return null;
            if (!exe.canExecute()) return null;
            File file = exe;
            return file;
        }
        catch (Exception e) {
            LOG.error("Failed to check for executable: " + executable, (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFreeDisp() {
        File tmpDir = new File(SystemUtils.JAVA_IO_TMPDIR);
        Object object = mutex;
        synchronized (object) {
            int disp = 39;
            while (true) {
                File xlock;
                if ((xlock = new File(tmpDir, ".X" + ++disp + "-lock")).exists()) {
                    continue;
                }
                try {
                    Process p = ClientPerformanceUtils.startXvfb(disp, xlock);
                    if (p != null) {
                        XVFB_PROCESSES.add(p);
                        LOG.info("Started new Xvfb process using display " + disp);
                        break;
                    }
                    LOG.info("Failed to start Xvfb process using display " + disp);
                }
                catch (IOException e) {
                    LOG.error("Failed to start new Xvfb process", (Throwable)e);
                }
            }
            return ":".concat(Integer.toString(disp));
        }
    }

    private static Process startXvfb(int display, File xlock) throws IOException {
        File xvfbOut = new File(Session.getCurrent().getResultsDirectory().toString(), "xvfb-out.log");
        Process p = new ProcessBuilder(PATH_TO_XVFB_EXE, ":" + display, "-ac", "-noreset", "-screen", "0", XVFB_SCREEN_CONFIG).redirectErrorStream(true).redirectOutput(xvfbOut).start();
        ThreadUtils.sleep(1500L);
        try {
            p.exitValue();
            LOG.error("Xvfb process exited prematurely (display: " + display + ")!");
            return null;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            long endTime = System.currentTimeMillis() + 5000L;
            do {
                if (xlock.exists()) {
                    return p;
                }
                ThreadUtils.sleep(250L);
            } while (System.currentTimeMillis() < endTime);
            p.destroy();
            LOG.error("Xvfb process was not ready to accept connections within 5s (display: " + display + ")!");
            return null;
        }
    }

    private static void cleanUp() {
        LOG.debug("xvfb cleanup");
        for (Process p : XVFB_PROCESSES) {
            try {
                p.destroy();
            }
            catch (Throwable t) {
                LOG.error("Failed to destroy xvfb process during shutdown", t);
            }
        }
    }

    private ClientPerformanceUtils() {
    }

    static {
        LOG = LoggerFactory.getLogger(ClientPerformanceUtils.class);
        mutex = new Object();
        XVFB_PROCESSES = new ArrayList<Process>();
        DISPLAYS = new ConcurrentHashMap();
        File exe = ClientPerformanceUtils.checkForExecutable("Xvfb");
        PATH_TO_XVFB_EXE = exe != null ? exe.getAbsolutePath() : null;
        XVFB_SCREEN_CONFIG = ClientPerformanceUtils.getScreenConfig();
        Runtime.getRuntime().addShutdownHook(new Thread(ClientPerformanceUtils.class.getSimpleName() + "-shutdown"){

            @Override
            public void run() {
                ClientPerformanceUtils.cleanUp();
            }
        });
    }
}

