/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionExpirationTimer {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionExpirationTimer.class);
    private static final Timer transactionExpirationTimer = new Timer("TransactionExpirationTimer", true);

    TransactionExpirationTimer() {
    }

    public static TransactionTimerTask addTimerTask(String userId, long transactionTimeout) {
        TransactionTimerTask transactionExpirationTimerTask = new TransactionTimerTask(userId, transactionTimeout);
        transactionExpirationTimer.schedule((TimerTask)transactionExpirationTimerTask, transactionTimeout);
        return transactionExpirationTimerTask;
    }

    public static class TransactionTimerTask
    extends TimerTask {
        public volatile boolean isExpired = false;
        private final String userId;
        private final long transactionTimeout;

        public TransactionTimerTask(String userId, long transactionTimeout) {
            this.userId = userId;
            this.transactionTimeout = transactionTimeout;
        }

        @Override
        public void run() {
            this.isExpired = true;
            if (LOG.isWarnEnabled()) {
                LOG.warn(String.format("User '%s' exceeds maximum permitted run time of %,d ms. Will mark it as expired.", this.userId, this.transactionTimeout));
            }
        }
    }
}

