/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.common.util.ProductInformation;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.common.util.StringMatcher;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.engine.SessionShutdownListener;
import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.api.util.ResponseProcessor;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.AsynchronousAjaxController;
import com.xceptance.xlt.engine.LightWeightPageImpl;
import com.xceptance.xlt.engine.PageStatistics;
import com.xceptance.xlt.engine.RequestQueue;
import com.xceptance.xlt.engine.RequestStack;
import com.xceptance.xlt.engine.SynchronousAjaxController;
import com.xceptance.xlt.engine.XltCache;
import com.xceptance.xlt.engine.XltDebugger;
import com.xceptance.xlt.engine.XltHttpWebConnection;
import com.xceptance.xlt.engine.XltJavaScriptEngine;
import com.xceptance.xlt.engine.XltOfflineWebConnection;
import com.xceptance.xlt.engine.htmlunit.apache.XltApacheHttpWebConnection;
import com.xceptance.xlt.engine.htmlunit.okhttp3.OkHttp3WebConnection;
import com.xceptance.xlt.engine.socket.XltSockets;
import com.xceptance.xlt.engine.util.CssUtils;
import com.xceptance.xlt.engine.util.JSBeautifingResponseProcessor;
import com.xceptance.xlt.engine.util.LWPageUtilities;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.AjaxController;
import org.htmlunit.AlertHandler;
import org.htmlunit.BrowserVersion;
import org.htmlunit.DefaultCredentialsProvider;
import org.htmlunit.FailingHttpStatusCodeException;
import org.htmlunit.HttpMethod;
import org.htmlunit.NicelyResynchronizingAjaxController;
import org.htmlunit.Page;
import org.htmlunit.ProxyConfig;
import org.htmlunit.ScriptException;
import org.htmlunit.WebClient;
import org.htmlunit.WebConnection;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.css.CssStyleSheet;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSImportRuleImpl;
import org.htmlunit.cssparser.dom.CSSMediaRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleRuleImpl;
import org.htmlunit.cssparser.parser.selector.Selector;
import org.htmlunit.cssparser.parser.selector.SelectorList;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.xpath.XPathHelper;
import org.htmlunit.javascript.background.JavaScriptJobManager;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.css.CSSRule;
import org.htmlunit.javascript.host.css.CSSRuleList;
import org.htmlunit.javascript.host.css.CSSStyleSheet;
import org.htmlunit.javascript.host.css.StyleSheetList;
import org.htmlunit.javascript.host.html.HTMLDocument;
import org.htmlunit.util.UrlUtils;

public class XltWebClient
extends WebClient
implements SessionShutdownListener,
AlertHandler {
    private static final String LINKTYPE_WHITELIST_PATTERN = "(?i)stylesheet|(fav|shortcut )?icon";
    private static final String LINK_MEDIA_WHITELIST_PATTERN = "(?i)screen|all";
    private static final long serialVersionUID = 1L;
    private static final XltCache globalCache;
    private static final ConcurrentHashMap<String, KeyStore> storeCache;
    private final ConcurrentHashMap<String, WebResponse> pageLocalCache = new ConcurrentHashMap();
    private boolean loadStaticContent = false;
    private String timerName;
    private final boolean throwExcOnHttpErrorWhileLoadingPages;
    private final boolean throwExcOnHttpErrorWhileLoadingResources;
    private transient RequestQueue requestQueue;
    private final StringMatcher urlFilter;
    private final List<ResponseProcessor> responseProcessors = new ArrayList<ResponseProcessor>();
    private ResponseProcessor jsBeautifier;
    private final CssMode cssMode;
    private final ConcurrentHashMap<String, Collection<String>> cssResourceUrlCache = new ConcurrentHashMap();
    private int threadCount;
    private XltDebugger xltDebugger;

    public XltWebClient() {
        this(null);
    }

    public XltWebClient(BrowserVersion browserVersion) {
        this(browserVersion, XltProperties.getInstance().getProperty("com.xceptance.xlt.javaScriptEngineEnabled", false));
    }

    public XltWebClient(BrowserVersion browserVersion, boolean javaScriptEngineEnabled) {
        super(XltWebClient.copyAndModifyBrowserVersion(browserVersion), javaScriptEngineEnabled, null, 0);
        WebConnection underlyingWebConnection;
        int historySizeLimit;
        Session.getCurrent().addShutdownListener(this);
        XltProperties props = XltProperties.getInstance();
        this.loadStaticContent = props.getProperty("com.xceptance.xlt.loadStaticContent", false);
        this.throwExcOnHttpErrorWhileLoadingPages = props.getProperty("com.xceptance.xlt.stopTestOnHttpErrors.page", true);
        this.throwExcOnHttpErrorWhileLoadingResources = props.getProperty("com.xceptance.xlt.stopTestOnHttpErrors.embedded", false);
        this.threadCount = props.getProperty("com.xceptance.xlt.staticContent.downloadThreads", 4);
        if (this.threadCount <= 0) {
            XltLogger.runTimeLogger.warn("Property 'com.xceptance.xlt.staticContent.downloadThreads' is set to an invalid value. Will use 1 instead.");
            this.threadCount = 1;
        }
        this.requestQueue = new RequestQueue(this, this.threadCount);
        this.setAlertHandler(this);
        this.getOptions().setRedirectEnabled(true);
        this.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.getOptions().setPrintContentOnFailingStatusCode(false);
        this.getOptions().setHomePage("about:blank");
        int defaultTimeout = 10000;
        int timeout = props.getProperty("com.xceptance.xlt.timeout", 10000);
        if (timeout < 10000) {
            XltLogger.runTimeLogger.warn("com.xceptance.xlt.timeout is set lower than " + Integer.toString(10000) + "!");
        }
        this.getOptions().setTimeout(timeout);
        this.getOptions().setCssEnabled(props.getProperty("com.xceptance.xlt.cssEnabled", false));
        this.cssMode = CssMode.getMode(props.getProperty("com.xceptance.xlt.css.download.images"));
        if (javaScriptEngineEnabled) {
            int optimizationLevel = props.getProperty("com.xceptance.xlt.js.compiler.optimizationLevel", -1);
            if (optimizationLevel < -1 || optimizationLevel > 9) {
                XltLogger.runTimeLogger.warn("Property 'com.xceptance.xlt.js.compiler.optimizationLevel' is set to an invalid value. Will use -1 instead.");
                optimizationLevel = -1;
            }
            boolean takeMeasurements = props.getProperty("com.xceptance.xlt.js.takeMeasurements", false);
            this.setJavaScriptEngine(new XltJavaScriptEngine(this, optimizationLevel, takeMeasurements));
            this.getOptions().setJavaScriptEnabled(props.getProperty("com.xceptance.xlt.javaScriptEnabled", false));
            this.getOptions().setThrowExceptionOnScriptError(props.getProperty("com.xceptance.xlt.stopTestOnJavaScriptErrors", false));
            if (props.getProperty("com.xceptance.xlt.js.debugger.enabled", false)) {
                this.setJavaScriptDebuggerEnabled(true);
                if (props.getProperty("com.xceptance.xlt.js.debugger.beautifyDownloadedJavaScript", true)) {
                    this.jsBeautifier = new JSBeautifingResponseProcessor();
                }
            }
        } else {
            this.getOptions().setJavaScriptEnabled(false);
        }
        String userName = props.getProperty("com.xceptance.xlt.auth.userName");
        if (userName != null && userName.length() > 0) {
            String password = props.getProperty("com.xceptance.xlt.auth.password", "");
            ((DefaultCredentialsProvider)this.getCredentialsProvider()).addCredentials(userName, password);
            if (XltLogger.runTimeLogger.isInfoEnabled()) {
                XltLogger.runTimeLogger.info("Using credentials: " + userName + "/<password>");
            }
        }
        if (props.getProperty("com.xceptance.xlt.proxy", false)) {
            String proxyHost = props.getProperty("com.xceptance.xlt.proxy.host", "127.0.0.1");
            int proxyPort = props.getProperty("com.xceptance.xlt.proxy.port", 8888);
            String bypassForHosts = props.getProperty("com.xceptance.xlt.proxy.bypassForHosts", "");
            String[] hostPatterns = StringUtils.split((String)bypassForHosts, (String)" ,;");
            ProxyConfig proxyConfig = new ProxyConfig(proxyHost, proxyPort, null);
            for (String hostPattern : hostPatterns) {
                proxyConfig.addHostsToProxyBypass(hostPattern);
            }
            this.getOptions().setProxyConfig(proxyConfig);
            if (XltLogger.runTimeLogger.isInfoEnabled()) {
                XltLogger.runTimeLogger.info("Using proxy at " + proxyHost + ":" + proxyPort);
            }
            String proxyUserName = props.getProperty("com.xceptance.xlt.proxy.userName");
            String proxyPassword = props.getProperty("com.xceptance.xlt.proxy.password");
            if (proxyUserName != null && proxyUserName.length() > 0) {
                ((DefaultCredentialsProvider)this.getCredentialsProvider()).addCredentials(proxyUserName, proxyPassword, proxyHost, proxyPort, null);
                if (XltLogger.runTimeLogger.isInfoEnabled()) {
                    XltLogger.runTimeLogger.info("Using proxy credentials: " + proxyUserName + "/<password>");
                }
            }
        }
        AjaxMode ajaxMode = AjaxMode.getMode(props.getProperty("com.xceptance.xlt.js.ajax.executionMode", "normal"));
        this.setAjaxController(XltWebClient.getAjaxControllerForMode(ajaxMode));
        this.setCache(globalCache);
        String includedUrls = props.getProperty("com.xceptance.xlt.http.filter.include", "");
        String excludedUrls = props.getProperty("com.xceptance.xlt.http.filter.exclude", "");
        this.urlFilter = new StringMatcher(includedUrls, excludedUrls);
        this.getOptions().setUseInsecureSSL(props.getProperty("com.xceptance.xlt.ssl.easyMode", false));
        String easyModeProtocol = (String)StringUtils.defaultIfBlank((CharSequence)props.getProperty("com.xceptance.xlt.ssl.easyModeProtocol"), (CharSequence)"TLS");
        this.getOptions().setSSLInsecureProtocol(easyModeProtocol.trim());
        String sslProtocols = props.getProperty("com.xceptance.xlt.ssl.protocols");
        if (StringUtils.isNotBlank((CharSequence)sslProtocols)) {
            this.getOptions().setSSLClientProtocols(StringUtils.split((String)sslProtocols, (String)" ,;"));
        }
        if (!props.getProperty("com.xceptance.xlt.http.keepAlive", props.getProperty("com.xceptance.xlt.keepAlive", true))) {
            this.addRequestHeader("Connection", "close");
        }
        if (!props.getProperty("com.xceptance.xlt.http.gzip", true)) {
            this.addRequestHeader("Accept-Encoding", "");
        }
        if ((historySizeLimit = props.getProperty("com.xceptance.xlt.browser.history.size", 1)) < 0) {
            XltLogger.runTimeLogger.warn("Property 'com.xceptance.xlt.browser.history.size' is set to an invalid value. Will use 1 instead.");
            historySizeLimit = 1;
        }
        this.getOptions().setHistorySizeLimit(historySizeLimit);
        if (props.getProperty("com.xceptance.xlt.http.offline", false)) {
            underlyingWebConnection = new XltOfflineWebConnection();
        } else {
            String client = props.getProperty("com.xceptance.xlt.http.client");
            boolean collectTargetIpAddress = ((XltPropertiesImpl)props).collectUsedIpAddress();
            if ("okhttp3".equals(client)) {
                boolean http2Enabled = props.getProperty("com.xceptance.xlt.http.client.okhttp3.http2Enabled", true);
                underlyingWebConnection = new OkHttp3WebConnection(this, http2Enabled, collectTargetIpAddress);
            } else {
                underlyingWebConnection = new XltApacheHttpWebConnection(this, collectTargetIpAddress);
            }
        }
        XltLogger.runTimeLogger.debug("Using web connection class: " + underlyingWebConnection.getClass().getName());
        XltHttpWebConnection connection = new XltHttpWebConnection(this, underlyingWebConnection);
        this.setWebConnection(connection);
        this.setUpKeyStore(props);
        this.setUpTrustStore(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P extends Page> P getPage(WebWindow webWindow, WebRequest parameters) throws IOException, FailingHttpStatusCodeException {
        if (parameters.getUrl().toString().equals("about:blank")) {
            return super.getPage(webWindow, parameters);
        }
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info("Loading page from: " + parameters.getUrl());
        }
        if (webWindow.getTopWindow() == webWindow) {
            this.pageLocalCache.clear();
            PageStatistics.getPageStatistics().pageLoadStarted();
        }
        parameters.setDocumentRequest();
        Page page = null;
        RequestStack requestStack = RequestStack.getCurrent();
        requestStack.setTimerName(this.getTimerName());
        try {
            requestStack.pushPage();
            try {
                page = (Page)super.getPage(webWindow, parameters);
                WebResponse response = page.getWebResponse();
                if (response.getStatusCode() >= 500 && this.throwExcOnHttpErrorWhileLoadingPages) {
                    Session.getCurrent().setFailed(true);
                    throw new FailingHttpStatusCodeException(response);
                }
            }
            catch (IOException e) {
                Session.getCurrent().setFailed(true);
                throw e;
            }
            catch (ScriptException e) {
                Session.getCurrent().setFailed(true);
                throw e;
            }
        }
        finally {
            requestStack.popPage();
        }
        return (P)page;
    }

    public LightWeightPage getLightWeightPage(URL url) throws IOException, FailingHttpStatusCodeException {
        return this.getLightWeightPage(new WebRequest(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightWeightPage getLightWeightPage(WebRequest webRequestSettings) throws IOException, FailingHttpStatusCodeException {
        WebWindow window;
        URL url = webRequestSettings.getUrl();
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info("Loading page from: " + url);
        }
        if ((window = this.getCurrentWindow()) == null || window.getTopWindow() == window) {
            this.pageLocalCache.clear();
            PageStatistics.getPageStatistics().pageLoadStarted();
        }
        webRequestSettings.setDocumentRequest();
        RequestStack requestStack = RequestStack.getCurrent();
        requestStack.setTimerName(this.getTimerName());
        LightWeightPageImpl page = null;
        WebResponse response = null;
        try {
            requestStack.pushPage();
            try {
                response = this.loadWebResponse(webRequestSettings);
                if (response.getStatusCode() >= 500 && this.throwExcOnHttpErrorWhileLoadingPages) {
                    Session.getCurrent().setFailed(true);
                    throw new FailingHttpStatusCodeException(response);
                }
                this.loadStaticContent(response);
                page = new LightWeightPageImpl(response, this.getTimerName(), this);
            }
            catch (IOException e) {
                Session.getCurrent().setFailed(true);
                throw e;
            }
        }
        finally {
            requestStack.popPage();
            if (window == null || window.getTopWindow() == window) {
                PageStatistics.getPageStatistics().pageLoadFinished();
            }
        }
        return page;
    }

    public void loadNewStaticContent(HtmlPage htmlPage) {
        if (this.loadStaticContent && this.isJavaScriptEngineEnabled()) {
            URL u;
            String hrefAttribute;
            URL referrerURL;
            URL baseURL = referrerURL = htmlPage.getWebResponse().getWebRequest().getUrl();
            List elements = htmlPage.getByXPath("/html/head/base");
            if (!elements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(hrefAttribute = ((HtmlElement)elements.get(0)).getAttribute("href"))) && (u = XltWebClient.makeUrlAbsolute(baseURL, hrefAttribute)) != null) {
                baseURL = u;
            }
            if (this.getOptions().isJavaScriptEnabled()) {
                RequestStack requestStack = RequestStack.getCurrent();
                requestStack.setTimerName(this.getTimerName());
                TreeSet<String> urlStrings = new TreeSet<String>();
                elements = htmlPage.getByXPath("//input[@type='image']");
                for (Object o : elements) {
                    String srcAttribute = ((HtmlElement)o).getAttribute("src");
                    if (!StringUtils.isNotEmpty((CharSequence)srcAttribute)) continue;
                    urlStrings.add(srcAttribute);
                }
                elements = htmlPage.getByXPath("//link");
                for (Object o : elements) {
                    HtmlElement e = (HtmlElement)o;
                    String relAttribute = e.getAttribute("rel");
                    String mediaAttribute = e.getAttribute("media");
                    String hrefAttribute2 = e.getAttribute("href");
                    if (!StringUtils.isNotEmpty((CharSequence)hrefAttribute2) || !RegExUtils.isMatching(relAttribute, LINKTYPE_WHITELIST_PATTERN) || !StringUtils.isBlank((CharSequence)mediaAttribute) && !RegExUtils.isMatching(mediaAttribute, LINK_MEDIA_WHITELIST_PATTERN)) continue;
                    urlStrings.add(hrefAttribute2);
                }
                StringBuilder stringBuilder = new StringBuilder();
                elements = htmlPage.getByXPath("//style");
                for (Object o : elements) {
                    HtmlElement e = (HtmlElement)o;
                    stringBuilder.append(e.getTextContent());
                }
                elements = htmlPage.getByXPath("//@style");
                for (Object o : elements) {
                    stringBuilder.append(((DomAttr)o).getValue());
                }
                if (this.getCssMode().equals((Object)CssMode.ALWAYS)) {
                    urlStrings.addAll(CssUtils.getUrlStrings(stringBuilder.toString()));
                } else {
                    urlStrings.addAll(CssUtils.getRelativeImportUrlStrings(stringBuilder.toString()));
                }
                this.loadStaticContent(XltWebClient.resolveUrls(urlStrings, baseURL), referrerURL, htmlPage.getCharset());
            }
            if (this.getOptions().isCssEnabled() && this.getCssMode().equals((Object)CssMode.ONDEMAND)) {
                this.evalCss(htmlPage, baseURL);
            }
            ArrayList<FrameWindow> frames = new ArrayList<FrameWindow>(htmlPage.getFrames());
            for (WebWindow webWindow : frames) {
                Page framePage = webWindow.getEnclosedPage();
                if (!(framePage instanceof HtmlPage)) continue;
                this.loadNewStaticContent((HtmlPage)framePage);
            }
        }
    }

    private void loadStaticContent(WebResponse response) {
        String hrefAttValue;
        URL u;
        URL referrerUrl;
        int startAt;
        boolean haveJS = this.isJavaScriptEnabled();
        boolean haveCss = this.getOptions().isCssEnabled();
        if (response == null || !this.loadStaticContent && !haveJS && !haveCss) {
            return;
        }
        String page = response.getContentAsString();
        if (page == null) {
            return;
        }
        TreeSet<String> urlStrings = new TreeSet<String>();
        boolean isCssModeAlways = CssMode.ALWAYS.equals((Object)this.getCssMode());
        if (this.loadStaticContent || haveJS) {
            String commentPattern = this.getBrowserVersion().isIE() ? "(?sm)<!--[^\\[].*?-->" : "(?sm)<!--.*?-->";
            page = RegExUtils.replaceAll(page, commentPattern, "");
            Pattern p = RegExUtils.getPattern("(?sm)<script\\b(.*?)(?:/>|>.*?</script>)");
            Matcher m = p.matcher(page);
            StringBuilder sb = new StringBuilder();
            startAt = 0;
            while (m.find(startAt)) {
                String matching = m.group(1);
                sb.append(page.substring(startAt, m.start()));
                String srcAttribute = RegExUtils.getFirstMatch(matching, "src\\s*=\\s*['\"]([^'\"]+?)['\"]", 1);
                if (srcAttribute != null) {
                    urlStrings.add(srcAttribute);
                }
                startAt = m.end();
            }
            if (startAt < page.length()) {
                sb.append(page.substring(startAt));
            }
            page = sb.toString();
        }
        if (this.loadStaticContent || haveCss) {
            urlStrings.addAll(this.getAllowedLinkURIs(page));
            StringBuilder sb = new StringBuilder();
            StringBuilder pageStringBuilder = new StringBuilder(4096);
            Pattern p = RegExUtils.getPattern("(?sm)<style\\b([^>]*?)>((?!</style).*?)</style>");
            Matcher m = p.matcher(page);
            startAt = 0;
            while (m.find(startAt)) {
                pageStringBuilder.append(page.substring(startAt, m.start()));
                String styleAtts = m.group(1);
                String typeAtt = LWPageUtilities.getAttributeValue(styleAtts, "type");
                String mediaAtt = LWPageUtilities.getAttributeValue(styleAtts, "media");
                if ("text/css".equalsIgnoreCase(typeAtt) && (StringUtils.isBlank((CharSequence)mediaAtt) || RegExUtils.isMatching(mediaAtt, LINK_MEDIA_WHITELIST_PATTERN))) {
                    sb.append(m.group(2));
                }
                startAt = m.end();
            }
            if (startAt < page.length()) {
                pageStringBuilder.append(page.substring(startAt));
            }
            page = pageStringBuilder.toString();
            String inlineCss = sb.toString();
            if (!isCssModeAlways || !this.loadStaticContent) {
                urlStrings.addAll(CssUtils.getRelativeImportUrlStrings(inlineCss));
            } else {
                urlStrings.addAll(CssUtils.getUrlStrings(inlineCss));
                urlStrings.addAll(CssUtils.getUrlStrings(StringUtils.join(LWPageUtilities.getAllInlineCssStatements(page), (char)' ')));
            }
        }
        if (this.loadStaticContent) {
            urlStrings.addAll(LWPageUtilities.getAllImageLinks(page));
            urlStrings.addAll(LWPageUtilities.getAllImageInputLinks(page));
        }
        URL baseUrl = referrerUrl = response.getWebRequest().getUrl();
        List<String> baseUrls = LWPageUtilities.getAllBaseLinks(page);
        if (!baseUrls.isEmpty() && (u = XltWebClient.makeUrlAbsolute(baseUrl, hrefAttValue = baseUrls.get(0))) != null) {
            baseUrl = u;
        }
        this.loadStaticContent(XltWebClient.resolveUrls(urlStrings, baseUrl), referrerUrl, response.getContentCharset());
    }

    private void loadStaticContent(Collection<URL> urls, URL referrerUrl, Charset charset) {
        for (URL url : urls) {
            this.requestQueue.addRequest(url, referrerUrl, charset);
        }
        this.requestQueue.waitForCompletion();
    }

    WebResponse loadStaticContentFromUrl(URL url, URL referrerUrl, Charset charset) throws IOException {
        try {
            WebRequest webRequest = new WebRequest(url);
            if (referrerUrl != null) {
                webRequest.setAdditionalHeader("Referer", referrerUrl.toExternalForm());
            }
            webRequest.setCharset(charset);
            WebResponse webResponse = this.loadWebResponse(webRequest);
            int statusCode = webResponse.getStatusCode();
            if (statusCode >= 400 && this.throwExcOnHttpErrorWhileLoadingResources) {
                throw new FailingHttpStatusCodeException(webResponse);
            }
            return webResponse;
        }
        catch (IOException e) {
            if (this.throwExcOnHttpErrorWhileLoadingResources) {
                throw e;
            }
            if (XltLogger.runTimeLogger.isWarnEnabled()) {
                XltLogger.runTimeLogger.warn("Failed to load static content from: " + url, (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public WebResponse loadWebResponse(WebRequest request) throws IOException {
        String urlString;
        WebResponse response;
        URL pageURL = request.getUrl();
        int port = pageURL.getPort();
        if (port >= 0 && port == pageURL.getDefaultPort()) {
            request.setUrl(XltWebClient.getUrlWithNewPort(pageURL, -1));
            request.setOriginalURL(pageURL);
        }
        if ((response = this.pageLocalCache.get(urlString = request.getUrl().toString())) == null) {
            if (XltLogger.runTimeLogger.isInfoEnabled()) {
                XltLogger.runTimeLogger.info("Loading " + urlString);
            }
            response = super.loadWebResponse(request);
            if (!request.isXHR() && !request.isDocumentRequest() && request.getHttpMethod() != HttpMethod.POST) {
                this.pageLocalCache.put(urlString, response);
            }
        }
        if (response.getStatusCode() < 400) {
            this.handleCss(response, request.getCharset());
        }
        return response;
    }

    @Override
    public Page loadWebResponseInto(WebResponse webResponse, WebWindow webWindow) throws IOException, FailingHttpStatusCodeException {
        this.loadStaticContent(webResponse);
        Page p = super.loadWebResponseInto(webResponse, webWindow);
        if (webWindow.getTopWindow() == webWindow) {
            PageStatistics.getPageStatistics().pageLoadFinished();
        }
        return p;
    }

    @Override
    public void download(WebWindow requestingWindow, String target, WebRequest request, boolean checkHash, boolean forceLoad, boolean forceAttachment, String description) {
        if (requestingWindow.getTopWindow() == requestingWindow) {
            URL currentUrl;
            boolean isHashJump;
            URL requestedUrl = request.getUrl();
            boolean bl = isHashJump = requestedUrl.sameFile(currentUrl = requestingWindow.getEnclosedPage().getWebResponse().getWebRequest().getUrl()) && requestedUrl.getRef() != null;
            if (!isHashJump) {
                this.pageLocalCache.clear();
            }
            PageStatistics.getPageStatistics().pageLoadStarted();
        }
        request.setDocumentRequest();
        super.download(requestingWindow, target, request, checkHash, forceLoad, forceAttachment, description);
    }

    private static Collection<URL> resolveUrls(Collection<String> urlStrings, URL baseURL) {
        HashMap<String, URL> resolvedURLs = new HashMap<String, URL>(urlStrings.size());
        for (String urlString : urlStrings) {
            URL absoluteURL = XltWebClient.makeUrlAbsolute(baseURL, urlString);
            if (absoluteURL == null) continue;
            String absoluteURLString = absoluteURL.toString();
            resolvedURLs.put(absoluteURLString, absoluteURL);
        }
        return resolvedURLs.values();
    }

    private List<String> getAllowedLinkURIs(String pageContent) {
        ArrayList<String> links = new ArrayList<String>();
        String relAttRegex = this.loadStaticContent ? LINKTYPE_WHITELIST_PATTERN : "(?i)stylesheet";
        for (String attributeList : LWPageUtilities.getAllLinkAttributes(pageContent)) {
            String mediaAttribute;
            String hrefAttributeValue;
            String relAttribute = LWPageUtilities.getAttributeValue(attributeList, "rel");
            if (relAttribute == null || !RegExUtils.isMatching(relAttribute, relAttRegex) || StringUtils.isBlank((CharSequence)(hrefAttributeValue = LWPageUtilities.getAttributeValue(attributeList, "href"))) || (mediaAttribute = LWPageUtilities.getAttributeValue(attributeList, "media")) != null && !RegExUtils.isMatching(mediaAttribute, LINK_MEDIA_WHITELIST_PATTERN)) continue;
            links.add(hrefAttributeValue);
        }
        return links;
    }

    @Override
    public void shutdown() {
        this.setTimerName("BrowserShutdown");
        this.close();
        this.requestQueue.shutdown();
        this.pageLocalCache.clear();
    }

    public String getTimerName() {
        return this.timerName;
    }

    public void setTimerName(String timerName) {
        this.timerName = timerName;
        RequestStack.getCurrent().reset();
        RequestStack.getCurrent().setTimerName(timerName);
    }

    public boolean isAcceptedUrl(URL url) {
        return this.urlFilter.isAccepted(url.toString());
    }

    public WebResponse processResponse(WebResponse webResponse) {
        WebResponse response = webResponse;
        for (int i = 0; i < this.responseProcessors.size(); ++i) {
            response = this.responseProcessors.get(i).processResponse(response);
        }
        if (this.jsBeautifier != null && this.isJavaScriptDebuggerEnabled()) {
            response = this.jsBeautifier.processResponse(response);
        }
        return response;
    }

    public void clearResponseProcessors() {
        this.responseProcessors.clear();
    }

    public void addResponseProcessor(ResponseProcessor processor) {
        this.responseProcessors.add(processor);
    }

    public void removeResponseProcessor(ResponseProcessor processor) {
        this.responseProcessors.remove(processor);
    }

    @Override
    public void handleAlert(Page page, String message) {
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info("window.alert() message: " + message);
        }
    }

    public void waitForBackgroundThreads(Page page, long maximumWaitingTime) {
        if (this.isJavaScriptEnabled()) {
            if (maximumWaitingTime >= 0L) {
                if (XltLogger.runTimeLogger.isDebugEnabled()) {
                    XltLogger.runTimeLogger.debug(String.format("Waiting at most %d ms for all background jobs in all web windows.", maximumWaitingTime));
                }
                List<WebWindow> webWindows = this.getAllWebWindows(page);
                long start = TimerUtils.get().getStartTime();
                for (WebWindow webWindow : webWindows) {
                    int remainingJobs;
                    JavaScriptJobManager jobManager = webWindow.getJobManager();
                    if (jobManager == null) continue;
                    long remainingWaitingTime = maximumWaitingTime - TimerUtils.get().getElapsedTime(start);
                    if (remainingWaitingTime > 0L) {
                        if (XltLogger.runTimeLogger.isDebugEnabled()) {
                            XltLogger.runTimeLogger.debug(String.format("Now waiting for background jobs in web window '%s'.", webWindow.toString()));
                        }
                        remainingJobs = jobManager.waitForJobs(remainingWaitingTime);
                    } else {
                        remainingJobs = jobManager.getJobCount();
                    }
                    if (remainingJobs > 0 && XltLogger.runTimeLogger.isWarnEnabled()) {
                        XltLogger.runTimeLogger.warn(String.format("%d background job(s) still running in web window '%s'. Check your JavaScript code. You may also increase the waiting time (currently: %d ms).", remainingJobs, webWindow.toString(), maximumWaitingTime));
                    }
                    jobManager.removeAllJobs();
                }
            } else {
                XltLogger.runTimeLogger.debug("Will not wait for running background jobs to finish, nor kill pending jobs.");
            }
        }
    }

    public CssMode getCssMode() {
        return this.cssMode;
    }

    @Override
    public boolean isLoadStaticContent() {
        return this.loadStaticContent;
    }

    public void setLoadStaticContent(boolean loadStaticContent) {
        this.loadStaticContent = loadStaticContent;
    }

    private void cacheResourceUrlsOfCssResponse(WebResponse r) {
        URL url;
        block4: {
            url = r.getWebRequest().getUrl();
            try {
                url = XltWebClient.normalizeUrl(url);
            }
            catch (MalformedURLException mue) {
                if (!XltLogger.runTimeLogger.isWarnEnabled()) break block4;
                XltLogger.runTimeLogger.warn("Failed to normalize URL '" + url + "'");
            }
        }
        String requestUrlString = url.toString();
        if (XltLogger.runTimeLogger.isDebugEnabled()) {
            XltLogger.runTimeLogger.debug("Caching resource URLs of CSS response for URL: " + requestUrlString);
        }
        if (!this.cssResourceUrlCache.containsKey(requestUrlString)) {
            this.cssResourceUrlCache.put(requestUrlString, CssUtils.getUrlStrings(CssUtils.clearImportRules(r)));
        }
    }

    private void handleCss(WebResponse response, Charset charset) {
        Set<String> urlStrings;
        if (!CssUtils.isCssResponse(response)) {
            return;
        }
        CssMode cssMode = this.getCssMode();
        String cssContent = response.getContentAsString();
        if (this.loadStaticContent && cssMode.equals((Object)CssMode.ALWAYS)) {
            urlStrings = CssUtils.getUrlStrings(cssContent);
        } else {
            if (cssMode.equals((Object)CssMode.ONDEMAND)) {
                this.cacheResourceUrlsOfCssResponse(response);
            }
            urlStrings = CssUtils.getRelativeImportUrlStrings(cssContent);
        }
        for (String urlString : urlStrings) {
            URL url = XltWebClient.makeUrlAbsolute(response.getWebRequest().getUrl(), urlString);
            if (url == null) continue;
            URL referrerUrl = response.getWebRequest().getUrl();
            this.requestQueue.addRequest(url, referrerUrl, charset);
        }
    }

    private void evalCss(HtmlPage page, URL baseURL) {
        if (page == null || page.getBody() == null) {
            return;
        }
        HtmlElement body = page.getBody();
        List<CSSStyleRuleImpl> cssRulesWithUrls = this.getCssRulesWithUrls(page);
        StringBuilder cssText = new StringBuilder(4096);
        BrowserVersion browserVersion = page.getWebClient().getBrowserVersion();
        this.evalCss(body, cssRulesWithUrls, browserVersion, cssText);
        ArrayList<URL> urls = new ArrayList<URL>();
        HashSet<String> alreadyLoadedUrls = new HashSet<String>(this.pageLocalCache.keySet());
        List<URL> pageBaseURLs = Arrays.asList(baseURL);
        for (String urlString : CssUtils.getUrlStrings(cssText.toString())) {
            List<URL> baseURLs = this.getCssBaseUrls(urlString);
            if (baseURLs.isEmpty()) {
                baseURLs = pageBaseURLs;
            }
            for (URL u : baseURLs) {
                URL url = XltWebClient.makeUrlAbsolute(u, urlString);
                if (url == null || alreadyLoadedUrls.contains(url.toString())) continue;
                urls.add(url);
                alreadyLoadedUrls.add(url.toString());
            }
        }
        URL referrerUrl = page.getWebResponse().getWebRequest().getUrl();
        this.loadStaticContent(urls, referrerUrl, page.getCharset());
    }

    private List<URL> getCssBaseUrls(String urlString) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Map.Entry<String, Collection<String>> entry : this.cssResourceUrlCache.entrySet()) {
            if (!entry.getValue().contains(urlString)) continue;
            try {
                urls.add(new URL(entry.getKey()));
            }
            catch (MalformedURLException e) {
                if (!XltLogger.runTimeLogger.isWarnEnabled()) continue;
                XltLogger.runTimeLogger.warn("Failed to create URL from: " + entry.getKey(), (Throwable)e);
            }
        }
        return urls;
    }

    private void evalCss(HtmlElement element, List<CSSStyleRuleImpl> cssRules, BrowserVersion browserVersion, StringBuilder cssText) {
        String elementStyle = element.getAttribute("style");
        if (XltWebClient.containsUrl(elementStyle)) {
            cssText.append(elementStyle);
        }
        Iterator<CSSStyleRuleImpl> rulesIterator = cssRules.iterator();
        block0: while (rulesIterator.hasNext()) {
            CSSStyleRuleImpl rule = rulesIterator.next();
            SelectorList selectors = rule.getSelectors();
            for (int j = 0; j < selectors.size(); ++j) {
                Selector selector = (Selector)selectors.get(j);
                boolean selected = CssStyleSheet.selects(browserVersion, selector, element, null, false, false);
                if (!selected) continue;
                cssText.append(rule.getCssText());
                rulesIterator.remove();
                continue block0;
            }
        }
        for (DomElement childElement : element.getChildElements()) {
            if (!(childElement instanceof HtmlElement)) continue;
            this.evalCss((HtmlElement)childElement, cssRules, browserVersion, cssText);
        }
    }

    private List<CSSStyleRuleImpl> getCssRulesWithUrls(HtmlPage page) {
        ArrayList<CSSStyleRuleImpl> cssRules = new ArrayList<CSSStyleRuleImpl>();
        if (this.isJavaScriptEnabled()) {
            Window window = (Window)page.getEnclosingWindow().getScriptableObject();
            HTMLDocument document = (HTMLDocument)window.getDocument();
            StyleSheetList sheets = document.getStyleSheets();
            for (int i = 0; i < sheets.getLength(); ++i) {
                CSSStyleSheet sheet = (CSSStyleSheet)sheets.item(i);
                this.addCssStyleRulesWithUrls(sheet, cssRules);
            }
        }
        return cssRules;
    }

    private void addCssStyleRulesWithUrls(CSSStyleSheet sheet, List<CSSStyleRuleImpl> cssRules) {
        if (sheet.getCssStyleSheet().isActive()) {
            CSSRuleList rules = sheet.getCssRules();
            for (int r = 0; r < rules.getLength(); ++r) {
                try {
                    CSSRule rule = (CSSRule)rules.get(r, null);
                    this.addCssStyleRulesWithUrls(sheet, rule.getRule(), cssRules);
                    continue;
                }
                catch (Throwable t) {
                    if (!XltLogger.runTimeLogger.isDebugEnabled()) continue;
                    XltLogger.runTimeLogger.debug("Failed to process CSS style sheet: " + sheet.getUri() + ". Cause: " + t.getMessage());
                }
            }
        }
    }

    private void addCssStyleRulesWithUrls(CSSStyleSheet sheet, AbstractCSSRuleImpl rule, List<CSSStyleRuleImpl> cssStyleRules) {
        block4: {
            CSSMediaRuleImpl mediaRule;
            String mediaText;
            block5: {
                block3: {
                    if (!(rule instanceof CSSStyleRuleImpl) || !XltWebClient.containsUrl(rule.getCssText())) break block3;
                    if (XltWebClient.containsUrl(rule.getCssText())) {
                        cssStyleRules.add((CSSStyleRuleImpl)rule);
                    }
                    break block4;
                }
                if (!(rule instanceof CSSImportRuleImpl)) break block5;
                CSSImportRuleImpl importRule = (CSSImportRuleImpl)rule;
                String mediaText2 = importRule.getMedia().getMediaText();
                if (!StringUtils.isBlank((CharSequence)mediaText2) && !RegExUtils.isMatching(mediaText2, LINK_MEDIA_WHITELIST_PATTERN)) break block4;
                CssStyleSheet imported = sheet.getCssStyleSheet().getImportedStyleSheet(importRule);
                CSSStyleSheet importedSheet = new CSSStyleSheet(sheet.getOwnerNode(), (Scriptable)sheet.getWindow(), imported);
                if (importedSheet == null) break block4;
                this.addCssStyleRulesWithUrls(importedSheet, cssStyleRules);
                break block4;
            }
            if (rule instanceof CSSMediaRuleImpl && (StringUtils.isBlank((CharSequence)(mediaText = (mediaRule = (CSSMediaRuleImpl)rule).getMediaList().getMediaText())) || RegExUtils.isMatching(mediaText, LINK_MEDIA_WHITELIST_PATTERN))) {
                List rules = mediaRule.getCssRules().getRules();
                for (AbstractCSSRuleImpl r : rules) {
                    this.addCssStyleRulesWithUrls(sheet, r, cssStyleRules);
                }
            }
        }
    }

    private static boolean containsUrl(String cssText) {
        return cssText.toLowerCase().contains("url(");
    }

    private List<WebWindow> getAllWebWindows(Page page) {
        ArrayList<WebWindow> webWindows = new ArrayList<WebWindow>();
        if (page != null) {
            webWindows.add(page.getEnclosingWindow());
            if (page instanceof HtmlPage) {
                List<FrameWindow> frames = ((HtmlPage)page).getFrames();
                for (FrameWindow frameWindow : frames) {
                    webWindows.addAll(this.getAllWebWindows(frameWindow.getEnclosedPage()));
                }
            }
        }
        return webWindows;
    }

    public static URL makeUrlAbsolute(URL baseURL, String relativeUrl) {
        if (baseURL == null || relativeUrl == null || relativeUrl.trim().length() == 0) {
            return null;
        }
        relativeUrl = StringEscapeUtils.unescapeHtml4((String)relativeUrl);
        try {
            String urlString = relativeUrl.startsWith("http") ? relativeUrl : UrlUtils.resolveUrl(baseURL, relativeUrl);
            return XltWebClient.normalizeUrl(new URL(urlString));
        }
        catch (MalformedURLException mue) {
            if (XltLogger.runTimeLogger.isWarnEnabled()) {
                String errMsg = String.format("Cannot create new URL from base URL '%s' and relative URL '%s'", baseURL, relativeUrl);
                XltLogger.runTimeLogger.warn(errMsg);
            }
            return null;
        }
    }

    public void setJavaScriptDebuggerEnabled(boolean enabled) {
        if (this.xltDebugger == null) {
            this.xltDebugger = new XltDebugger(this);
        }
        this.xltDebugger.setEnabled(enabled);
    }

    public boolean isJavaScriptDebuggerEnabled() {
        return this.xltDebugger == null ? false : this.xltDebugger.isEnabled();
    }

    private static URL normalizeUrl(URL url) throws MalformedURLException {
        int port = url.getPort();
        if (port >= 0 && port == url.getDefaultPort()) {
            return XltWebClient.getUrlWithNewPort(url, -1);
        }
        return url;
    }

    private static URL getUrlWithNewPort(URL url, int port) throws MalformedURLException {
        String path = url.getPath();
        String query = url.getQuery();
        String ref = url.getRef();
        String userInfo = url.getUserInfo();
        StringBuilder s = new StringBuilder();
        s.append(url.getProtocol());
        s.append("://");
        if (userInfo != null && userInfo.length() > 0) {
            s.append(userInfo);
            s.append("@");
        }
        s.append(url.getHost());
        if (port != -1) {
            s.append(":").append(port);
        }
        if (path != null && path.length() > 0) {
            if (path.charAt(0) != '/') {
                s.append("/");
            }
            s.append(path);
        }
        if (query != null) {
            s.append("?").append(query);
        }
        if (ref != null) {
            if (ref.charAt(0) != '#') {
                s.append("#");
            }
            s.append(ref);
        }
        return new URL(s.toString());
    }

    private static AjaxController getAjaxControllerForMode(AjaxMode ajaxMode) {
        switch (ajaxMode) {
            case RESYNC: {
                return new NicelyResynchronizingAjaxController();
            }
            case NORMAL: {
                return new AjaxController();
            }
            case ASYNC: {
                return new AsynchronousAjaxController();
            }
        }
        return new SynchronousAjaxController();
    }

    private static BrowserVersion copyAndModifyBrowserVersion(BrowserVersion browserVersion) {
        if (browserVersion == null) {
            browserVersion = XltWebClient.determineBrowserVersion();
        }
        BrowserVersion.BrowserVersionBuilder browserVersionBuilder = new BrowserVersion.BrowserVersionBuilder(browserVersion);
        String customUserAgent = XltProperties.getInstance().getProperty("com.xceptance.xlt.browser.userAgent", "");
        if (customUserAgent.length() == 0) {
            ProductInformation productInfo = ProductInformation.getProductInformation();
            String productIdentifier = productInfo.getProductName() + " " + productInfo.getVersion();
            customUserAgent = browserVersion.getUserAgent().replace(")", "; " + productIdentifier + ")");
        }
        browserVersionBuilder.setUserAgent(customUserAgent);
        return browserVersionBuilder.build();
    }

    private static BrowserVersion determineBrowserVersion() {
        String browserType = XltProperties.getInstance().getProperty("com.xceptance.xlt.browser", "FF").toUpperCase();
        BrowserVersion browserVersion = browserType.equals("IE") ? BrowserVersion.INTERNET_EXPLORER : (browserType.equals("CH") ? BrowserVersion.CHROME : (browserType.equals("EDGE") ? BrowserVersion.EDGE : (browserType.equals("FF_ESR") ? BrowserVersion.FIREFOX_ESR : BrowserVersion.FIREFOX)));
        return browserVersion;
    }

    private void setUpKeyStore(XltProperties props) {
        String storeFilePath = props.getProperty("com.xceptance.xlt.tls.keyStore.file");
        if (StringUtils.isNotBlank((CharSequence)storeFilePath)) {
            String storePassword = props.getProperty("com.xceptance.xlt.tls.keyStore.password");
            char[] storePasswordChars = XltWebClient.getPasswordChars(storePassword);
            KeyStore store = XltWebClient.getStore(storeFilePath, storePasswordChars);
            this.getOptions().setSSLClientCertificateKeyStore(store, storePasswordChars);
        }
    }

    private void setUpTrustStore(XltProperties props) {
        String storeFilePath = props.getProperty("com.xceptance.xlt.tls.trustStore.file");
        if (StringUtils.isNotBlank((CharSequence)storeFilePath)) {
            String storePassword = props.getProperty("com.xceptance.xlt.tls.trustStore.password");
            char[] storePasswordChars = XltWebClient.getPasswordChars(storePassword);
            KeyStore store = XltWebClient.getStore(storeFilePath, storePasswordChars);
            this.getOptions().setSSLTrustStore(store);
        }
    }

    private static char[] getPasswordChars(String password) {
        return password == null ? ArrayUtils.EMPTY_CHAR_ARRAY : password.toCharArray();
    }

    private static KeyStore getStore(String storeFilePath, char[] storePassword) {
        XltLogger.runTimeLogger.debug("Getting store for path '{}'", (Object)storeFilePath);
        return storeCache.computeIfAbsent(storeFilePath, path -> XltWebClient.loadStore(path, storePassword));
    }

    private static KeyStore loadStore(String storeFilePath, char[] storePassword) {
        try {
            XltLogger.runTimeLogger.debug("Loading store from '{}'", (Object)storeFilePath);
            File storeFile = new File(storeFilePath);
            return KeyStore.getInstance(storeFile, storePassword);
        }
        catch (Exception e) {
            throw new XltException("Failed to read key/trust store from: " + storeFilePath, e);
        }
    }

    static {
        XltSockets.initialize();
        XltProperties props = XltProperties.getInstance();
        String logMsgFormat = "Specified size of %s cache is lower than the minimum size of '%d'. Will use the minimum size.";
        int jsCacheSize = props.getProperty("com.xceptance.xlt.js.cache.size", 100);
        if (jsCacheSize < 10 && XltLogger.runTimeLogger.isWarnEnabled()) {
            XltLogger.runTimeLogger.warn(String.format("Specified size of %s cache is lower than the minimum size of '%d'. Will use the minimum size.", "JS", 10));
        }
        jsCacheSize = Math.max(jsCacheSize, 10);
        int cssCacheSize = props.getProperty("com.xceptance.xlt.css.cache.size", 100);
        if (cssCacheSize < 10 && XltLogger.runTimeLogger.isWarnEnabled()) {
            XltLogger.runTimeLogger.warn(String.format("Specified size of %s cache is lower than the minimum size of '%d'. Will use the minimum size.", "CSS", 10));
        }
        cssCacheSize = Math.max(cssCacheSize, 10);
        globalCache = new XltCache(jsCacheSize, cssCacheSize);
        storeCache = new ConcurrentHashMap();
        String xpathEngine = props.getProperty("com.xceptance.xlt.xpath.engine", "jaxen");
        XPathHelper.useJaxen = xpathEngine.equalsIgnoreCase("jaxen");
    }

    static enum AjaxMode {
        ASYNC,
        SYNC,
        NORMAL,
        RESYNC;


        static AjaxMode getMode(String modeString) {
            AjaxMode mode = NORMAL;
            if (modeString != null && modeString.length() > 0) {
                String s = modeString.toLowerCase().trim();
                if (s.equals("async")) {
                    mode = ASYNC;
                } else if (s.equals("sync")) {
                    mode = SYNC;
                } else if (s.equals("resync")) {
                    mode = RESYNC;
                }
            }
            return mode;
        }
    }

    static enum CssMode {
        ALWAYS,
        ONDEMAND,
        NEVER;


        static CssMode getMode(String modeString) {
            CssMode mode = NEVER;
            if (modeString != null && modeString.trim().length() > 0) {
                String s = modeString.toLowerCase().trim();
                if (s.equals("always")) {
                    mode = ALWAYS;
                } else if (s.equals("ondemand")) {
                    mode = ONDEMAND;
                }
            }
            return mode;
        }
    }
}

