/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.xceptance.common.collection.LRUList;
import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.resultbrowser.ActionInfo;
import com.xceptance.xlt.engine.resultbrowser.DumpMgr;
import com.xceptance.xlt.engine.resultbrowser.ErrorCounter;
import com.xceptance.xlt.engine.resultbrowser.Page;
import com.xceptance.xlt.engine.resultbrowser.Request;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.html.HtmlPage;

public class RequestHistory {
    public static final String OUTPUT2DISK_PROPERTY = "com.xceptance.xlt.output2disk";
    private static final String OUTPUT2DISK_WRITEHAR_PROPERTY = "com.xceptance.xlt.output2disk.writeHarFile";
    private static final String OUTPUT2DISK_SIZE_PROPERTY = "com.xceptance.xlt.output2disk.size";
    public static final String OUTPUT2DISK_ERROR_PROPERTY = "com.xceptance.xlt.output2disk.onError";
    private final LRUList<Page> pages;
    private final List<Request> pendingRequests;
    private DumpMode dumpMode;
    private DumpMgr dumpMgr;
    private final SessionImpl session;

    public RequestHistory(SessionImpl session, XltProperties properties) {
        this.session = session;
        int historySize = properties.getProperty(session, OUTPUT2DISK_SIZE_PROPERTY).flatMap(ParseNumbers::parseOptionalInt).orElse(3);
        if (historySize < 1) {
            XltLogger.runTimeLogger.warn("com.xceptance.xlt.output2disk.size must be larger than 1, setting 3 as default now.");
            historySize = 3;
        }
        this.pages = new LRUList(historySize);
        this.pendingRequests = new LinkedList<Request>();
        String dumpModeValue = properties.getProperty(session, OUTPUT2DISK_PROPERTY).orElse("onError");
        this.dumpMode = DumpMode.valueFrom(dumpModeValue);
        this.dumpMgr = new DumpMgr();
        this.dumpMgr.setHarExportEnabled(properties.getProperty(session, OUTPUT2DISK_WRITEHAR_PROPERTY).map(Boolean::valueOf).orElse(false));
    }

    public synchronized void add(String name, WebRequest webRequest, WebResponse webResponse, RequestData requestData) {
        ParameterCheckUtils.isNotNull(name, "name");
        ParameterCheckUtils.isNotNull(webRequest, "webRequestSettings");
        if (this.dumpMode != DumpMode.NEVER) {
            if (this.dumpMode == DumpMode.ON_ERROR) {
                this.pendingRequests.add(new Request(name, webRequest, webResponse, requestData));
            } else if (this.dumpMode == DumpMode.ALWAYS) {
                this.dumpMgr.dump(new Request(name, webRequest, webResponse, requestData));
            }
        }
    }

    public void add(LightWeightPage lwPage) {
        this.add(() -> new Page(lwPage.getTimerName(), lwPage));
    }

    public void add(String name, HtmlPage htmlPage) {
        ParameterCheckUtils.isNotNull(name, "name");
        this.add(() -> new Page(name, htmlPage));
    }

    public void add(ActionInfo actionInfo, byte[] image) {
        ParameterCheckUtils.isNotNull(actionInfo.name, "name");
        this.add(() -> new Page(actionInfo, image));
    }

    public void add(String name) {
        ParameterCheckUtils.isNotNull(name, "name");
        this.add(() -> new Page(name));
    }

    private synchronized void add(Supplier<Page> pageSupplier) {
        if (this.dumpMode == DumpMode.NEVER) {
            return;
        }
        Page page = pageSupplier.get();
        if (this.dumpMode == DumpMode.ON_ERROR) {
            this.pages.add(page);
            page.getRequests().addAll(this.pendingRequests);
            this.pendingRequests.clear();
        } else if (this.dumpMode == DumpMode.ALWAYS) {
            this.dumpMgr.dump(page);
        }
    }

    public void dumpToDisk() {
        if (this.requestDumpPermission()) {
            this.dump();
        }
    }

    private boolean requestDumpPermission() {
        switch (this.dumpMode) {
            case ALWAYS: {
                return true;
            }
            case ON_ERROR: {
                if (!this.session.hasFailed()) break;
                return ErrorCounter.get().countDumpIfOpen(this.session);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        LinkedList<Request> requestsCopy;
        LinkedList<Page> pagesCopy;
        RequestHistory requestHistory = this;
        synchronized (requestHistory) {
            pagesCopy = new LinkedList<Page>(this.pages);
            requestsCopy = new LinkedList<Request>(this.pendingRequests);
            this.pages.clear();
            this.pendingRequests.clear();
        }
        this.dumpMgr.dumpToDisk(pagesCopy, requestsCopy);
    }

    public synchronized void clear() {
        this.pages.clear();
        this.pendingRequests.clear();
        this.dumpMgr.clear();
    }

    public DumpMode getDumpMode() {
        return this.dumpMode;
    }

    public void setDumpMode(DumpMode dumpMode) {
        this.dumpMode = dumpMode;
    }

    public void setDumpManager(DumpMgr dumpManager) {
        if (dumpManager != null) {
            this.dumpMgr = dumpManager;
        }
    }

    public DumpMgr getDumpManager() {
        return this.dumpMgr;
    }

    public static enum DumpMode {
        NEVER,
        ON_ERROR,
        ALWAYS;


        public static DumpMode valueFrom(String propertyValue) {
            if ("never".equals(propertyValue)) {
                return NEVER;
            }
            if ("onError".equals(propertyValue) || "onErrors".equals(propertyValue)) {
                return ON_ERROR;
            }
            return ALWAYS;
        }
    }
}

