/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import com.xceptance.common.util.ParseUtils;
import com.xceptance.common.util.PropertiesUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public final class PropertyIncludeResolver {
    static final String PROP_INCLUDE_NAME_PREFIX = "com.xceptance.xlt.propertiesInclude";

    public static List<PropertyIncludeResult> resolve(FileObject homeDirectory, FileObject configDirectory, List<PropertyInclude> propertyFiles) {
        ArrayDeque<PropertyInclude> inputFiles = new ArrayDeque<PropertyInclude>(propertyFiles);
        ArrayDeque<PropertyInclude> toProcess = new ArrayDeque<PropertyInclude>();
        ArrayList<PropertyIncludeResult> processed = new ArrayList<PropertyIncludeResult>();
        HashSet<String> previousFiles = new HashSet<String>();
        while (!toProcess.isEmpty() || !inputFiles.isEmpty()) {
            boolean isInclude;
            PropertyInclude propertyFile;
            if (toProcess.isEmpty()) {
                propertyFile = (PropertyInclude)inputFiles.pollFirst();
                isInclude = false;
            } else {
                propertyFile = (PropertyInclude)toProcess.pollFirst();
                isInclude = true;
            }
            if (previousFiles.contains(propertyFile.file.getPublicURIString())) {
                processed.add(new PropertyIncludeResult(propertyFile.file, propertyFile.name, configDirectory, false, true, false, isInclude));
                continue;
            }
            previousFiles.add(propertyFile.file.getPublicURIString());
            if (!PropertyIncludeResolver.verifyRootDir(homeDirectory, propertyFile.file)) {
                processed.add(new PropertyIncludeResult(propertyFile.file, propertyFile.name, configDirectory, false, false, true, isInclude));
                continue;
            }
            try {
                List<PropertyInclude> includes;
                if (!propertyFile.file.exists()) {
                    processed.add(new PropertyIncludeResult(propertyFile.file, propertyFile.name, configDirectory, false, false, false, isInclude));
                    continue;
                }
                if (propertyFile.file.isFile()) {
                    processed.add(new PropertyIncludeResult(propertyFile.file, propertyFile.name, configDirectory, true, false, false, isInclude));
                    includes = PropertyIncludeResolver.resolveIncludes(propertyFile.file);
                    toProcess.addAll(includes);
                    continue;
                }
                if (!propertyFile.file.isFolder()) continue;
                includes = PropertyIncludeResolver.getFilesOrderedByName(configDirectory, propertyFile.file);
                toProcess.addAll(includes);
            }
            catch (FileSystemException fileSystemException) {}
        }
        return processed;
    }

    private static boolean verifyRootDir(FileObject homeDirectory, FileObject toCheckFile) {
        boolean isPartOfRootDir = false;
        FileObject file = toCheckFile;
        try {
            if (!toCheckFile.isFile()) {
                file = toCheckFile.getParent();
            }
            do {
                if (!file.equals(homeDirectory)) continue;
                isPartOfRootDir = true;
                break;
            } while ((file = file.getParent()) != null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isPartOfRootDir;
    }

    public static String extractName(FileObject rootDirectory, FileObject target, String originalName) {
        FileName targetName = target.getName();
        FileName rootName = rootDirectory.getName();
        if (!target.equals(rootDirectory) && PropertyIncludeResolver.verifyRootDir(rootDirectory, target)) {
            try {
                return rootName.getRelativeName(targetName);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        return originalName;
    }

    private static List<PropertyInclude> resolveIncludes(FileObject file) {
        try {
            Properties properties = PropertyIncludeResolver.getPropertiesFromFile(file);
            ArrayList<PropertyInclude> includes = new ArrayList<PropertyInclude>();
            FileObject baseDir = file.getParent();
            for (String path : PropertyIncludeResolver.getOrderedIncludes(properties)) {
                FileObject f = baseDir.resolveFile(path);
                String s = PropertyIncludeResolver.extractName(file, f, path);
                includes.add(new PropertyInclude(f, s));
            }
            return includes;
        }
        catch (IOException iOException) {
            return List.of();
        }
    }

    private static List<PropertyInclude> getFilesOrderedByName(FileObject configDirectory, FileObject directory) {
        FileObject[] files;
        ArrayList<PropertyInclude> orderedIncludes = new ArrayList<PropertyInclude>();
        try {
            files = directory.getChildren();
        }
        catch (FileSystemException fse) {
            throw new IllegalStateException("Failed to get children of directory '" + directory.getName().getPath() + "'");
        }
        if (files != null) {
            for (FileObject child : files) {
                try {
                    if (child.isFolder() || !child.getName().getExtension().equals("properties")) continue;
                    String originalName = child.getName().getBaseName();
                    orderedIncludes.add(new PropertyInclude(child, PropertyIncludeResolver.extractName(configDirectory, child, originalName)));
                }
                catch (FileSystemException fse) {
                    throw new IllegalStateException("Failed to determine type of file '" + child.getName().getPath() + "'");
                }
            }
        }
        Collections.sort(orderedIncludes);
        return orderedIncludes;
    }

    private static Properties getPropertiesFromFile(FileObject current) throws IOException {
        return PropertiesUtils.loadProperties(current);
    }

    private static List<String> getOrderedIncludes(Properties properties) {
        Map<String, String> unsortedIncludes = PropertiesUtils.getPropertiesForKey(PROP_INCLUDE_NAME_PREFIX, properties);
        TreeMap<Integer, String> sortedIncludes = new TreeMap<Integer, String>();
        for (Map.Entry<String, String> entry : unsortedIncludes.entrySet()) {
            int index;
            String key = entry.getKey();
            try {
                index = ParseUtils.parseInt(key);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Failed to parse the suffix '%s' of property '%s' as an integer", key, "com.xceptance.xlt.propertiesInclude." + key));
            }
            sortedIncludes.put(index, entry.getValue());
        }
        return new ArrayList<String>(sortedIncludes.values());
    }

    public static class PropertyInclude
    implements Comparable<PropertyInclude> {
        public final FileObject file;
        public final String name;

        public PropertyInclude(FileObject file, String name) {
            this.file = file;
            this.name = name;
        }

        @Override
        public int compareTo(PropertyInclude o) {
            return this.file.compareTo((Object)o.file);
        }
    }

    public static class PropertyIncludeResult {
        public final FileObject file;
        public final String name;
        public final boolean exists;
        public final boolean seenBefore;
        public final boolean outsideORootDirScope;
        public final boolean isInclude;

        public PropertyIncludeResult(FileObject file, String name, FileObject rootDir, boolean exists, boolean seenBefore, boolean outsideORootDirScope, boolean isInclude) {
            this.file = file;
            this.name = name;
            this.exists = exists;
            this.seenBefore = seenBefore;
            this.outsideORootDirScope = outsideORootDirScope;
            this.isInclude = isInclude;
        }
    }
}

