/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import com.xceptance.xlt.api.util.XltProperties;

public abstract class TimerUtils {
    private static final TimerUtils HPT = new HighPrecisionTimerUtils();
    private static final TimerUtils LPT = new LowPrecisionTimerUtils();

    public static TimerUtils get() {
        return LocalTimerUtils.DEFAULT;
    }

    public abstract boolean isHighPrecision();

    public abstract long getTime();

    public long getStartTime() {
        return this.getTime();
    }

    public long getElapsedTime(long startTime) {
        return this.getTime() - startTime;
    }

    public static TimerUtils getHighPrecisionTimer() {
        return HPT;
    }

    public static TimerUtils getLowPrecisionTimer() {
        return LPT;
    }

    static final class LowPrecisionTimerUtils
    extends TimerUtils {
        LowPrecisionTimerUtils() {
        }

        @Override
        public boolean isHighPrecision() {
            return false;
        }

        @Override
        public long getTime() {
            return System.currentTimeMillis();
        }
    }

    static final class HighPrecisionTimerUtils
    extends TimerUtils {
        HighPrecisionTimerUtils() {
        }

        @Override
        public boolean isHighPrecision() {
            return true;
        }

        @Override
        public long getTime() {
            return System.nanoTime() / 1000000L;
        }
    }

    static final class LocalTimerUtils
    extends TimerUtils {
        static final TimerUtils DEFAULT = new LocalTimerUtils();
        private final TimerUtils instance = XltProperties.getInstance().getProperty("com.xceptance.xlt.useHighPrecisionTimer", true) ? HPT : LPT;

        private LocalTimerUtils() {
        }

        @Override
        public boolean isHighPrecision() {
            return this.instance.isHighPrecision();
        }

        @Override
        public long getTime() {
            return this.instance.getTime();
        }

        @Override
        public long getStartTime() {
            return this.instance.getStartTime();
        }

        @Override
        public long getElapsedTime(long startTime) {
            return this.instance.getElapsedTime(startTime);
        }
    }
}

