/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitElementUtils;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitDriver;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitKeyboard;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.htmlunit.ScriptException;
import org.htmlunit.html.DisabledElement;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.javascript.host.event.MouseEvent;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.Coordinates;

public class HtmlUnitMouse {
    private final HtmlUnitDriver parent_;
    private final HtmlUnitKeyboard keyboard_;
    private DomElement currentActiveElement_;
    private Point currentMousePosition;

    public HtmlUnitMouse(HtmlUnitDriver parent, HtmlUnitKeyboard keyboard) {
        this.parent_ = parent;
        this.keyboard_ = keyboard;
    }

    private DomElement getElementForOperation(Coordinates potentialCoordinates) {
        if (potentialCoordinates != null) {
            return (DomElement)potentialCoordinates.getAuxiliary();
        }
        if (this.currentActiveElement_ == null) {
            throw new NoSuchElementException("About to perform an interaction that relies on the active element, but there isn't one.");
        }
        return this.currentActiveElement_;
    }

    public void click(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent_.click(element, false);
    }

    void click(DomElement element, boolean directClick) {
        if (!element.isDisplayed()) {
            throw new ElementNotInteractableException("You may only interact with visible elements");
        }
        this.moveOutIfNeeded(element);
        try {
            element.click(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed() || directClick && element instanceof HtmlOption, this.keyboard_.isAltPressed());
            this.updateActiveElement(element);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (ScriptException e) {
            System.out.println(e.getMessage());
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SocketTimeoutException) {
                throw new TimeoutException(cause);
            }
            throw e;
        }
    }

    private void moveOutIfNeeded(DomElement element) {
        try {
            if (this.currentActiveElement_ != element) {
                if (this.currentActiveElement_ != null) {
                    this.currentActiveElement_.mouseOver(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
                    this.currentActiveElement_.mouseOut(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
                }
                if (element != null) {
                    element.mouseMove(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
                    element.mouseOver(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
                }
            }
        }
        catch (ScriptException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private void updateActiveElement(DomElement element) {
        if (element != null) {
            this.currentActiveElement_ = element;
        }
    }

    public void doubleClick(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent_.doubleClick(element);
    }

    void doubleClick(DomElement element) {
        this.moveOutIfNeeded(element);
        try {
            element.dblClick(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed());
            this.updateActiveElement(element);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void contextClick(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.moveOutIfNeeded(element);
        if (this.currentMousePosition == null) {
            element.rightClick(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed());
        } else {
            int xPos = this.currentMousePosition.getX();
            int yPos = this.currentMousePosition.getY();
            HtmlUnitElementUtils.fireMouseEvent(element, "mousedown", xPos, yPos, 2, 1);
            HtmlUnitElementUtils.fireMouseEvent(element, "mouseup", xPos, yPos, 2, 1);
            HtmlUnitElementUtils.fireMouseEvent(element, "contextmenu", xPos, yPos, 2, 0);
        }
        this.updateActiveElement(element);
    }

    public void mouseDown(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent_.mouseDown(element);
    }

    void mouseDown(DomElement element) {
        this.moveOutIfNeeded(element);
        element.mouseDown(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
        this.updateActiveElement(element);
    }

    public void mouseUp(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent_.mouseUp(element);
    }

    void mouseUp(DomElement element) {
        this.moveOutIfNeeded(element);
        element.mouseUp(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
        this.updateActiveElement(element);
    }

    public void mouseMove(Coordinates elementCoordinates) {
        this.mouseMove(elementCoordinates, 0L, 0L);
    }

    void mouseMove(DomElement element) {
        this.moveOutIfNeeded(element);
        this.updateActiveElement(element);
    }

    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        DomElement e = this.getElementForOperation(where);
        Point p = where.onPage();
        long coordX = (long)p.getX() + xOffset;
        long coordY = (long)p.getY() + yOffset;
        this.moveOutIfNeeded(e, coordX, coordY);
        this.updateMousePosition(new Point((int)coordX, (int)coordY));
        this.updateActiveElement(e);
    }

    private void moveOutIfNeeded(DomElement element, long coordX, long coordY) {
        try {
            if (this.currentActiveElement_ != element) {
                if (this.currentActiveElement_ != null) {
                    this.currentActiveElement_.mouseOver(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
                    this.currentActiveElement_.mouseOut(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
                    this.currentActiveElement_.blur();
                }
                if (element != null) {
                    this.mouseMove(element, coordX, coordY);
                }
            }
        }
        catch (ScriptException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private void mouseMove(DomElement element, long coordX, long coordY) {
        if (element instanceof DisabledElement && ((DisabledElement)((Object)element)).isDisabled()) {
            return;
        }
        MouseEvent event = new MouseEvent(element, "mousemove", this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0, 0);
        event.setClientX((int)coordX);
        event.setClientY((int)coordY);
        element.fireEvent(event);
        event = new MouseEvent(element, "mouseover", this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0, 0);
        event.setClientX((int)coordX);
        event.setClientY((int)coordY);
        element.fireEvent(event);
    }

    private void updateMousePosition(Point newPosition) {
        if (newPosition != null) {
            this.currentMousePosition = newPosition;
        }
    }
}

