/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.xceptance.common.util.ConsoleUiUtils;
import com.xceptance.xlt.gce.GceAdminConfiguration;
import com.xceptance.xlt.gce.GceAdminUtils;
import com.xceptance.xlt.gce.GceClient;
import com.xceptance.xlt.gce.OpCreateInstanceGroup;
import com.xceptance.xlt.gce.OpCreateInstanceGroupNonInteractively;
import com.xceptance.xlt.gce.OpDeleteInstanceGroup;
import com.xceptance.xlt.gce.OpDeleteInstanceGroupNonInteractively;
import com.xceptance.xlt.gce.OpListInstances;
import com.xceptance.xlt.gce.OpListInstancesByGroupNonInteractively;
import com.xceptance.xlt.gce.OpListInstancesByNameLabelNonInteractively;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GceAdmin {
    private static final Logger log = LoggerFactory.getLogger(GceAdmin.class);
    private static final String[] OPERATION_KEYS = new String[]{"l", "c", "d", "q"};
    private static final String[] OPERATION_DESCRIPTIONS = new String[]{"List running instances", "Create managed instance groups", "Delete managed instance groups", "Quit"};
    static final String[] OPERATIONS = new String[]{"list", "create", "delete", "quit"};
    private final GceClient gceClient;

    GceAdmin() throws IOException, GeneralSecurityException {
        GceAdminConfiguration gceConfiguration = new GceAdminConfiguration();
        this.gceClient = new GceClient(gceConfiguration.getApplicationName(), gceConfiguration.getProjectId(), gceConfiguration.getInstanceConnectTimeout());
    }

    void startInteractiveMode() {
        while (true) {
            try {
                while (true) {
                    System.out.println();
                    String operation = this.selectOperation();
                    System.out.println();
                    if (operation.equals(OPERATIONS[0])) {
                        new OpListInstances(this.gceClient).execute();
                    } else if (operation.equals(OPERATIONS[1])) {
                        new OpCreateInstanceGroup(this.gceClient).execute();
                    } else if (operation.equals(OPERATIONS[2])) {
                        new OpDeleteInstanceGroup(this.gceClient).execute();
                    } else if (operation.equals(OPERATIONS[3])) {
                        return;
                    }
                    System.out.println();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to execute operation: " + e.getMessage());
                log.error("Failed to execute operation", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private String selectOperation() {
        return ConsoleUiUtils.selectItem("What do you want to do?", Arrays.asList(OPERATION_KEYS), Arrays.asList(OPERATION_DESCRIPTIONS), Arrays.asList(OPERATIONS));
    }

    void startNonInteractiveMode(CommandLine commandLine) throws IOException {
        File outputFile;
        List args = commandLine.getArgList();
        String command = (String)args.get(0);
        String outputFilePath = commandLine.getOptionValue("o");
        File file = outputFile = StringUtils.isNotBlank((CharSequence)outputFilePath) ? new File(outputFilePath) : null;
        if (command.equals("list-by-label")) {
            if (args.size() != 3) {
                GceAdminUtils.dieWithMessage("Use 'gce_admin list-by-label <region-name> <name-label>'");
            } else {
                String regionName = (String)args.get(1);
                String nameLabel = (String)args.get(2);
                new OpListInstancesByNameLabelNonInteractively(this.gceClient).execute(regionName, nameLabel, outputFile);
            }
        } else if (command.equals("list-by-group")) {
            if (args.size() != 3) {
                GceAdminUtils.dieWithMessage("Use 'gce_admin list-by-group <region-name> <instance-group-name>'");
            } else {
                String regionName = (String)args.get(1);
                String instanceGroupName = (String)args.get(2);
                new OpListInstancesByGroupNonInteractively(this.gceClient).execute(regionName, instanceGroupName, outputFile);
            }
        } else if (command.equals("create-group")) {
            if (args.size() != 5) {
                GceAdminUtils.dieWithMessage("Use 'gce_admin create-group <region-name> <instance-group-name> <instance-template-name> <instance-count>'");
            } else {
                String regionName = (String)args.get(1);
                String instanceGroupName = (String)args.get(2);
                String instanceTemplateName = (String)args.get(3);
                int instanceCount = Integer.parseInt((String)args.get(4));
                new OpCreateInstanceGroupNonInteractively(this.gceClient).execute(regionName, instanceGroupName, instanceTemplateName, instanceCount, outputFile);
            }
        } else if (command.equals("delete-group")) {
            if (args.size() != 3) {
                GceAdminUtils.dieWithMessage("Use 'gce_admin delete-group <region-name> <instance-group-name>'");
            } else {
                String regionName = (String)args.get(1);
                String instanceGroupName = (String)args.get(2);
                new OpDeleteInstanceGroupNonInteractively(this.gceClient).execute(regionName, instanceGroupName);
            }
        } else {
            GceAdminUtils.dieWithMessage("Unknown command: " + command);
        }
    }
}

