/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceGroup;
import com.google.api.services.compute.model.InstanceGroupList;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceGroupsListInstances;
import com.google.api.services.compute.model.InstanceGroupsListInstancesRequest;
import com.google.api.services.compute.model.InstanceList;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.InstanceTemplateList;
import com.google.api.services.compute.model.InstanceWithNamedPorts;
import com.google.api.services.compute.model.ManagedInstance;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.RegionInstanceGroupList;
import com.google.api.services.compute.model.RegionInstanceGroupManagersListInstancesResponse;
import com.google.api.services.compute.model.RegionInstanceGroupsListInstances;
import com.google.api.services.compute.model.RegionInstanceGroupsListInstancesRequest;
import com.google.api.services.compute.model.RegionList;
import com.xceptance.common.lang.ThreadUtils;
import com.xceptance.xlt.gce.GceAdminUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class GceClient {
    private static final String STATE_RUNNING = "RUNNING";
    private static final long INSTANCE_STATE_POLLING_INTERVAL = 1000L;
    private final Compute compute;
    private final String projectId;
    private final long instanceConnectTimeout;
    private final List<Region> regions;
    private final Map<String, Region> regionsByName;

    GceClient(String applicationName, String projectId, long instanceConnectTimeout) throws GeneralSecurityException, IOException {
        this.projectId = projectId;
        this.instanceConnectTimeout = Math.max(instanceConnectTimeout, 0L);
        GoogleCredential credential = GoogleCredential.getApplicationDefault();
        if (credential.createScopedRequired()) {
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://www.googleapis.com/auth/devstorage.full_control");
            scopes.add("https://www.googleapis.com/auth/compute");
            credential = credential.createScoped(scopes);
        }
        this.compute = new Compute.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
        this.regionsByName = this.loadRegions();
        this.regions = new ArrayList<Region>(this.regionsByName.values());
    }

    private Map<String, Region> loadRegions() throws IOException {
        RegionList response;
        TreeMap<String, Region> regions = new TreeMap<String, Region>();
        Compute.Regions.List request = this.compute.regions().list(this.projectId);
        do {
            List items;
            if ((items = (response = (RegionList)request.execute()).getItems()) != null) {
                for (Region region : items) {
                    regions.put(region.getName(), region);
                }
            }
            request.setPageToken(response.getNextPageToken());
        } while (response.getNextPageToken() != null);
        return regions;
    }

    List<Region> getRegions() throws IOException {
        return this.regions;
    }

    Region getRegion(String regionName) {
        Region region = this.regionsByName.get(regionName);
        if (region == null) {
            throw new IllegalArgumentException("Unknown region: " + regionName);
        }
        return region;
    }

    void createInstanceGroup(String regionName, String instanceGroupName, String instanceTemplateName, int instanceCount) throws IOException {
        InstanceGroupManager instanceGroupManager = new InstanceGroupManager();
        instanceGroupManager.setBaseInstanceName(instanceGroupName);
        instanceGroupManager.setName(instanceGroupName);
        instanceGroupManager.setInstanceTemplate("global/instanceTemplates/" + instanceTemplateName);
        instanceGroupManager.setTargetSize(Integer.valueOf(instanceCount));
        this.compute.regionInstanceGroupManagers().insert(this.projectId, regionName, instanceGroupManager).execute();
    }

    List<Instance> waitForInstancesAreRunning(String regionName, String instanceGroupName, int instanceCount) throws IOException, TimeoutException {
        long timeout = this.instanceConnectTimeout;
        long deadline = System.currentTimeMillis() + timeout;
        List<Instance> instances = this.waitForInstancesToExist(regionName, instanceGroupName, instanceCount, timeout);
        long remainingTimeout = deadline - System.currentTimeMillis();
        instances = this.waitForInstanceState(instances, STATE_RUNNING, remainingTimeout);
        return instances;
    }

    List<Instance> waitForInstancesToExist(String regionName, String instanceGroupName, int instanceCount, long timeout) throws IOException, TimeoutException {
        long deadline = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < deadline) {
            List<ManagedInstance> managedInstances = this.getManagedInstances(regionName, instanceGroupName);
            if (managedInstances != null && managedInstances.size() == instanceCount) {
                boolean ok = true;
                for (ManagedInstance managedInstance : managedInstances) {
                    ok = ok && managedInstance.getInstanceStatus() != null;
                }
                if (ok) {
                    return this.getInstances(managedInstances);
                }
            }
            ThreadUtils.sleep(1000L);
        }
        throw new TimeoutException(String.format("One or more of the %d instances did not exist within %d seconds", instanceCount, timeout));
    }

    private List<ManagedInstance> getManagedInstances(String regionName, String instanceGroupName) throws IOException {
        return ((RegionInstanceGroupManagersListInstancesResponse)this.compute.regionInstanceGroupManagers().listManagedInstances(this.projectId, regionName, instanceGroupName).execute()).getManagedInstances();
    }

    private List<Instance> getInstances(List<ManagedInstance> managedInstances) throws IOException {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (ManagedInstance managedInstance : managedInstances) {
            instances.add(this.getInstance(managedInstance));
        }
        return instances;
    }

    private Instance getInstance(ManagedInstance managedInstance) throws IOException {
        String zoneName = GceAdminUtils.getZoneName(managedInstance.getInstance());
        String instanceName = GceAdminUtils.getInstanceName(managedInstance.getInstance());
        return (Instance)this.compute.instances().get(this.projectId, zoneName, instanceName).execute();
    }

    List<Instance> waitForInstanceState(List<Instance> instances, String state, long timeout) throws IOException, TimeoutException {
        ArrayList<Instance> updatedInstances = new ArrayList<Instance>();
        long deadline = System.currentTimeMillis() + timeout;
        for (Instance instance : instances) {
            long remainingTimeout = deadline - System.currentTimeMillis();
            Instance updatedInstance = this.waitForInstanceState(instance, STATE_RUNNING, remainingTimeout);
            updatedInstances.add(updatedInstance);
        }
        return updatedInstances;
    }

    Instance waitForInstanceState(Instance instance, String state, long timeout) throws IOException, TimeoutException {
        long deadline = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < deadline) {
            if ((instance = this.getInstance(instance.getSelfLink())) != null && instance.getStatus().equals(state)) {
                return instance;
            }
            ThreadUtils.sleep(1000L);
        }
        throw new TimeoutException(String.format("Instance '%s' did not reach state '%s' within %d seconds. Current state is '%s'.", instance.getName(), state, timeout / 1000L, instance.getStatus()));
    }

    Instance getInstance(String instanceUrl) throws IOException {
        String zoneName = GceAdminUtils.getZoneName(instanceUrl);
        String instanceName = GceAdminUtils.getInstanceName(instanceUrl);
        return (Instance)this.compute.instances().get(this.projectId, zoneName, instanceName).execute();
    }

    List<InstanceTemplate> getInstanceTemplates() throws IOException {
        InstanceTemplateList response;
        ArrayList<InstanceTemplate> instanceTemplates = new ArrayList<InstanceTemplate>();
        Compute.InstanceTemplates.List request = this.compute.instanceTemplates().list(this.projectId);
        do {
            if ((response = (InstanceTemplateList)request.execute()).getItems() != null) {
                instanceTemplates.addAll(response.getItems());
            }
            request.setPageToken(response.getNextPageToken());
        } while (response.getNextPageToken() != null);
        Collections.sort(instanceTemplates, new Comparator<InstanceTemplate>(){

            @Override
            public int compare(InstanceTemplate t1, InstanceTemplate t2) {
                String s1 = StringUtils.defaultString((String)t1.getName());
                String s2 = StringUtils.defaultString((String)t2.getName());
                return s1.compareTo(s2);
            }
        });
        return instanceTemplates;
    }

    InstanceGroup getInstanceGroup(String regionOrZoneName, String instanceGroupName) throws IOException {
        if (this.regionsByName.containsKey(regionOrZoneName)) {
            try {
                return (InstanceGroup)this.compute.regionInstanceGroups().get(this.projectId, regionOrZoneName, instanceGroupName).execute();
            }
            catch (IOException ex) {
                if (GceClient.isNotFound(ex)) {
                    for (String zone : this.getZoneNamesFromRegion(this.getRegion(regionOrZoneName))) {
                        InstanceGroup group = (InstanceGroup)GceClient.getOrNull(this.compute.instanceGroups().get(this.projectId, zone, instanceGroupName));
                        if (group == null) continue;
                        return group;
                    }
                }
                throw ex;
            }
        }
        return (InstanceGroup)this.compute.instanceGroups().get(this.projectId, regionOrZoneName, instanceGroupName).execute();
    }

    List<InstanceGroup> getAllInstanceGroups(Region region) throws IOException {
        ArrayList<InstanceGroup> groupList = new ArrayList<InstanceGroup>();
        String regionName = region.getName();
        groupList.addAll(this.getMultiZoneInstanceGroups(regionName));
        List<String> zoneNames = this.getZoneNamesFromRegion(region);
        for (String zoneName : zoneNames) {
            groupList.addAll(this.getSingleZoneInstanceGroups(zoneName));
        }
        return groupList;
    }

    List<InstanceGroup> getMultiZoneInstanceGroups(String regionName) throws IOException {
        RegionInstanceGroupList response;
        ArrayList<InstanceGroup> instanceGroups = new ArrayList<InstanceGroup>();
        Compute.RegionInstanceGroups.List request = this.compute.regionInstanceGroups().list(this.projectId, regionName);
        do {
            if ((response = (RegionInstanceGroupList)request.execute()).getItems() != null) {
                instanceGroups.addAll(response.getItems());
            }
            request.setPageToken(response.getNextPageToken());
        } while (response.getNextPageToken() != null);
        return instanceGroups;
    }

    List<InstanceGroup> getSingleZoneInstanceGroups(String zoneName) throws IOException {
        InstanceGroupList response;
        ArrayList<InstanceGroup> instanceGroups = new ArrayList<InstanceGroup>();
        Compute.InstanceGroups.List request = this.compute.instanceGroups().list(this.projectId, zoneName);
        do {
            if ((response = (InstanceGroupList)request.execute()).getItems() != null) {
                instanceGroups.addAll(response.getItems());
            }
            request.setPageToken(response.getNextPageToken());
        } while (response.getNextPageToken() != null);
        return instanceGroups;
    }

    List<Instance> getInstancesInRegion(Region region) throws IOException {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        List<String> zoneNames = this.getZoneNamesFromRegion(region);
        for (String zoneName : zoneNames) {
            instances.addAll(this.getInstancesInZone(zoneName));
        }
        return instances;
    }

    private List<String> getZoneNamesFromRegion(Region region) {
        List zones = region.getZones();
        if (zones != null) {
            zones = zones.stream().map(GceAdminUtils::getZoneName).collect(Collectors.toList());
        }
        return zones;
    }

    List<Instance> getInstancesInZone(String zoneName) throws IOException {
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        InstanceList instances = (InstanceList)this.compute.instances().list(this.projectId, zoneName).execute();
        if (instances.getItems() != null) {
            instanceList.addAll(instances.getItems());
        }
        return instanceList;
    }

    List<Instance> getInstancesInGroup(InstanceGroup instanceGroup) throws IOException {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        String groupName = instanceGroup.getName();
        if (instanceGroup.getSelfLink().contains("regions")) {
            RegionInstanceGroupsListInstances response;
            String regionName = GceAdminUtils.getRegionName(instanceGroup.getRegion());
            RegionInstanceGroupsListInstancesRequest requestBody = new RegionInstanceGroupsListInstancesRequest();
            Compute.RegionInstanceGroups.ListInstances request = this.compute.regionInstanceGroups().listInstances(this.projectId, regionName, groupName, requestBody);
            do {
                if ((response = (RegionInstanceGroupsListInstances)request.execute()).getItems() == null) continue;
                for (InstanceWithNamedPorts instanceWithNamedPorts : response.getItems()) {
                    String instanceUrl = instanceWithNamedPorts.getInstance();
                    String zoneName = GceAdminUtils.getZoneName(instanceUrl);
                    String instanceName = GceAdminUtils.getInstanceName(instanceUrl);
                    Instance instance = (Instance)this.compute.instances().get(this.projectId, zoneName, instanceName).execute();
                    instances.add(instance);
                }
                request.setPageToken(response.getNextPageToken());
            } while (response.getNextPageToken() != null);
        } else if (instanceGroup.getSelfLink().contains("zones")) {
            InstanceGroupsListInstances response;
            String zoneName = GceAdminUtils.getZoneName(instanceGroup.getZone());
            InstanceGroupsListInstancesRequest requestBody = new InstanceGroupsListInstancesRequest();
            Compute.InstanceGroups.ListInstances request = this.compute.instanceGroups().listInstances(this.projectId, zoneName, groupName, requestBody);
            do {
                if ((response = (InstanceGroupsListInstances)request.execute()).getItems() == null) continue;
                for (InstanceWithNamedPorts instanceWithNamedPorts : response.getItems()) {
                    String instanceUrl = instanceWithNamedPorts.getInstance();
                    String instanceName = GceAdminUtils.getInstanceName(instanceUrl);
                    Instance instance = (Instance)this.compute.instances().get(this.projectId, zoneName, instanceName).execute();
                    instances.add(instance);
                }
                request.setPageToken(response.getNextPageToken());
            } while (response.getNextPageToken() != null);
        }
        return instances;
    }

    void deleteInstanceGroup(InstanceGroup instanceGroup) throws IOException {
        String regionUrl = instanceGroup.getRegion();
        if (regionUrl != null) {
            String regionName = GceAdminUtils.getRegionName(regionUrl);
            this.compute.regionInstanceGroupManagers().delete(this.projectId, regionName, instanceGroup.getName()).execute();
        } else {
            String zoneName = GceAdminUtils.getZoneName(instanceGroup.getZone());
            this.compute.instanceGroupManagers().delete(this.projectId, zoneName, instanceGroup.getName()).execute();
        }
    }

    static <T> T getOrNull(AbstractGoogleClientRequest<T> request) throws IOException {
        try {
            return (T)request.execute();
        }
        catch (IOException ioe) {
            if (GceClient.isNotFound(ioe)) {
                return null;
            }
            throw ioe;
        }
    }

    private static boolean isNotFound(IOException ioe) {
        return ioe instanceof HttpResponseException && ((HttpResponseException)ioe).getStatusCode() == 404;
    }
}

