/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.util.concurrent.DaemonThreadFactory;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.AgentControllerStatus;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.mastercontroller.AgentControllerStatusInfo;
import com.xceptance.xlt.util.StatusUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentControllerStatusUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(AgentControllerStatusUpdater.class);
    private final Map<String, AgentControllerStatusInfo> statusMap;
    private final Map<String, AgentControllerStatusInfo> unmodifiableStatusMap;
    private ScheduledExecutorService scheduledExecutor;
    private final ExecutorService executor;
    private final Map<AgentController, Future<?>> tasks;

    public AgentControllerStatusUpdater(ExecutorService executor) {
        this.executor = executor;
        this.statusMap = new ConcurrentHashMap<String, AgentControllerStatusInfo>();
        this.unmodifiableStatusMap = Collections.unmodifiableMap(this.statusMap);
        this.tasks = new ConcurrentHashMap();
    }

    public void clearAgentControllerStatusMap() {
        this.statusMap.clear();
    }

    public Map<String, AgentControllerStatusInfo> getAgentControllerStatusMap() {
        return this.unmodifiableStatusMap;
    }

    public synchronized void start(Collection<AgentController> agentControllers, long delay) {
        this.stop();
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("AC-status-pool-"));
        Map<AgentController, Boolean> supported = this.checkNewStatusEndpointSupported(agentControllers);
        for (AgentController agentController : agentControllers) {
            boolean supportsNewStatusEndpoint = supported.get(agentController);
            Future<?> task = this.executor.submit(() -> this.retrieveAgentControllerStatus(agentController, supportsNewStatusEndpoint, delay));
            this.tasks.put(agentController, task);
        }
    }

    public synchronized void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
            this.scheduledExecutor = null;
        }
        this.tasks.values().forEach(task -> task.cancel(true));
        this.tasks.clear();
    }

    @Deprecated
    private Map<AgentController, Boolean> checkNewStatusEndpointSupported(Collection<AgentController> agentControllers) {
        HashMap<AgentController, Future<Boolean>> futures = new HashMap<AgentController, Future<Boolean>>();
        for (AgentController agentController : agentControllers) {
            Future<Boolean> future = this.executor.submit(() -> this.isNewEndpointSupported(agentController));
            futures.put(agentController, future);
        }
        HashMap<AgentController, Boolean> results = new HashMap<AgentController, Boolean>();
        for (Map.Entry futureEntry : futures.entrySet()) {
            boolean result = false;
            try {
                result = (Boolean)((Future)futureEntry.getValue()).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            results.put((AgentController)futureEntry.getKey(), result);
        }
        return results;
    }

    @Deprecated
    private boolean isNewEndpointSupported(AgentController agentController) {
        boolean result = false;
        try {
            agentController.getStatus();
            result = true;
            LOG.debug("{} supports the new status endpoint", (Object)agentController);
        }
        catch (Exception e) {
            LOG.debug("{} does not support the new status endpoint because of:", (Object)agentController, (Object)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveAgentControllerStatus(AgentController agentController, boolean supportsNewStatusEndpoint, long delay) {
        AgentControllerStatusInfo agentControllerStatusInfo = this.retrieveAgentControllerStatus(agentController, supportsNewStatusEndpoint);
        if (agentControllerStatusInfo != null && agentControllerStatusInfo.hasRunningAgents()) {
            Runnable updateTask = () -> this.retrieveAgentControllerStatus(agentController, supportsNewStatusEndpoint, delay);
            Runnable wrapperTask = () -> {
                Future<?> task = this.executor.submit(updateTask);
                this.tasks.put(agentController, task);
            };
            AgentControllerStatusUpdater agentControllerStatusUpdater = this;
            synchronized (agentControllerStatusUpdater) {
                if (this.scheduledExecutor != null && !this.scheduledExecutor.isShutdown()) {
                    this.scheduledExecutor.schedule(wrapperTask, delay, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private AgentControllerStatusInfo retrieveAgentControllerStatus(AgentController agentController, boolean supportsNewStatusEndpoint) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        try {
            LOG.debug("Getting status from " + agentController);
            AgentControllerStatus agentControllerStatus = this.getStatus(agentController, supportsNewStatusEndpoint);
            AgentControllerStatusInfo agentControllerStatusInfo = new AgentControllerStatusInfo(agentControllerStatus);
            this.statusMap.put(agentController.getName(), agentControllerStatusInfo);
            return agentControllerStatusInfo;
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            LOG.error("Failed getting status from " + agentController, (Throwable)e);
            AgentControllerStatusInfo agentControllerStatusInfo = this.statusMap.computeIfAbsent(agentController.getName(), acName -> new AgentControllerStatusInfo());
            agentControllerStatusInfo.setException(e);
            return agentControllerStatusInfo;
        }
    }

    @Deprecated
    private AgentControllerStatus getStatus(AgentController agentController, boolean supportsNewStatusEndpoint) {
        AgentControllerStatus agentControllerStatus;
        if (supportsNewStatusEndpoint) {
            agentControllerStatus = agentController.getStatus();
        } else {
            Set<AgentStatus> agentStatuses = agentController.getAgentStatus();
            agentControllerStatus = StatusUtils.getAgentControllerStatus(agentStatuses);
        }
        return agentControllerStatus;
    }
}

