/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.io.FileListFileFilter;
import com.xceptance.common.util.zip.ZipUtils;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.mastercontroller.MasterController;
import com.xceptance.xlt.mastercontroller.Poll;
import com.xceptance.xlt.util.AgentControllerException;
import com.xceptance.xlt.util.FailedAgentControllerCollection;
import com.xceptance.xlt.util.FileReplicationIndex;
import com.xceptance.xlt.util.FileReplicationUtils;
import com.xceptance.xlt.util.ProgressBar;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentControllerUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(AgentControllerUpdate.class);
    private static final Poll.AgentControllerPollingTask UPLOAD_POLL_TASK = new Poll.AgentControllerPollingTask(){

        @Override
        public boolean call(AgentController agentController) throws Exception {
            if (agentController.isUpdateDone()) {
                agentController.setUpdateAcknowledged();
                LOG.debug("Update done at " + agentController);
                return true;
            }
            return false;
        }
    };
    private final ThreadPoolExecutor uploadExecutor;
    private final ThreadPoolExecutor downloadExecutor;
    private final Collection<AgentController> agentControllers;
    private final File tempDirectory;
    private final FailedAgentControllerCollection failedAgentControllers;
    private Map<FileReplicationIndex, Set<AgentController>> remoteFileIndexes;

    public AgentControllerUpdate(Collection<AgentController> agentControllers, ThreadPoolExecutor uploadExecutor, ThreadPoolExecutor downloadExecutor, File tempDirectory) {
        this.agentControllers = agentControllers;
        this.uploadExecutor = uploadExecutor;
        this.downloadExecutor = downloadExecutor;
        this.tempDirectory = tempDirectory;
        this.failedAgentControllers = new FailedAgentControllerCollection();
    }

    public void prepare(ProgressBar progress) throws AgentControllerException {
        this.remoteFileIndexes = this.getAgentFileIndexes(progress);
    }

    private Map<FileReplicationIndex, Set<AgentController>> getAgentFileIndexes(ProgressBar progress) throws AgentControllerException {
        Map<AgentController, FileReplicationIndex> remoteFileIndexes = this.getRemoteFileIndexes(progress);
        Map<FileReplicationIndex, Set<AgentController>> fileIndexes = this.summarizeFileIndexes(remoteFileIndexes, progress);
        return fileIndexes;
    }

    private Map<AgentController, FileReplicationIndex> getRemoteFileIndexes(final ProgressBar progress) {
        LOG.info("Get remote file indexes");
        final ConcurrentHashMap<AgentController, FileReplicationIndex> remoteFileIndexes = new ConcurrentHashMap<AgentController, FileReplicationIndex>();
        final CountDownLatch latch = new CountDownLatch(this.agentControllers.size());
        for (final AgentController agentController : this.agentControllers) {
            this.downloadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        remoteFileIndexes.put(agentController, agentController.getAgentFilesIndex());
                        progress.increaseCount();
                    }
                    catch (Exception ex) {
                        AgentControllerUpdate.this.failedAgentControllers.add(agentController, ex);
                        LOG.error("Failed uploading agent files to " + agentController, (Throwable)ex);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Waiting for file indexes failed. " + MasterController.getDetailedMessage(e), (Throwable)e);
        }
        return remoteFileIndexes;
    }

    private Map<FileReplicationIndex, Set<AgentController>> summarizeFileIndexes(Map<AgentController, FileReplicationIndex> remoteFileIndexes, ProgressBar progress) {
        LOG.debug("Map indexes to agent controllers");
        HashMap<FileReplicationIndex, Set<AgentController>> fileIndexes = new HashMap<FileReplicationIndex, Set<AgentController>>();
        for (Map.Entry<AgentController, FileReplicationIndex> acFileIndex : remoteFileIndexes.entrySet()) {
            FileReplicationIndex fileIndex = acFileIndex.getValue();
            HashSet<AgentController> agentControllers = (HashSet<AgentController>)fileIndexes.get(fileIndex);
            if (agentControllers == null) {
                agentControllers = new HashSet<AgentController>();
            }
            agentControllers.add(acFileIndex.getKey());
            fileIndexes.put(fileIndex, agentControllers);
        }
        progress.increaseCount();
        return fileIndexes;
    }

    public void update(File workDir, FileReplicationIndex localIndex, ProgressBar progress) throws AgentControllerException, IOException {
        this.updateRemoteFiles(workDir, localIndex, progress);
        int totalAgentCount = this.getTotalAgentCount();
        this.updateTotalAgentCount(totalAgentCount, progress);
    }

    private void updateRemoteFiles(File workDir, FileReplicationIndex localIndex, ProgressBar progress) throws AgentControllerException, IOException {
        if (this.remoteFileIndexes == null) {
            throw new IOException("No remote file index. Please run 'prepare' before 'update'.");
        }
        Map<FileReplicationIndex, Set<AgentController>> remoteFileIndexes = this.remoteFileIndexes;
        this.remoteFileIndexes = null;
        this.uploadDifferences(workDir, localIndex, remoteFileIndexes, progress);
        this.pollForUpdateSuccess(remoteFileIndexes, progress);
    }

    private void uploadDifferences(File workDir, FileReplicationIndex localIndex, Map<FileReplicationIndex, Set<AgentController>> remoteFileIndexes, ProgressBar progress) throws AgentControllerException, IOException {
        for (Map.Entry<FileReplicationIndex, Set<AgentController>> indexAgents : remoteFileIndexes.entrySet()) {
            LOG.debug("Compute file index differences");
            ArrayList<File> filesToBeDeleted = new ArrayList<File>();
            ArrayList<File> filesToBeUpdated = new ArrayList<File>();
            FileReplicationUtils.compareIndexes(localIndex, indexAgents.getKey(), filesToBeUpdated, filesToBeDeleted);
            this.logFileUpdate(filesToBeUpdated, filesToBeDeleted, indexAgents.getValue());
            this.zipAndUpload(workDir, filesToBeUpdated, filesToBeDeleted, indexAgents.getValue(), progress);
        }
    }

    private void zipAndUpload(File workDir, List<File> filesToBeUpdated, final List<File> filesToBeDeleted, Set<AgentController> agentControllersForUpload, final ProgressBar progress) throws AgentControllerException, IOException {
        LOG.info("Zip update files");
        final File archiveFile = this.archiveAgentFiles(filesToBeUpdated, workDir);
        LOG.info("Upload file update");
        final CountDownLatch latch = new CountDownLatch(agentControllersForUpload.size());
        for (final AgentController agentController : agentControllersForUpload) {
            this.uploadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        String updateFileName = String.format("agentfiles_%s_%s.zip", agentController.getName(), UUID.randomUUID());
                        LOG.debug(agentController + " uploading");
                        agentController.getFileManager().uploadFile(archiveFile, updateFileName);
                        LOG.debug(agentController + " upload finished");
                        progress.increaseCount();
                        LOG.debug(agentController + " updating");
                        agentController.updateAgentFiles(updateFileName, filesToBeDeleted);
                        progress.increaseCount();
                    }
                    catch (Exception ex) {
                        AgentControllerUpdate.this.failedAgentControllers.add(agentController, ex);
                        LOG.error("Failed uploading files to " + agentController, (Throwable)ex);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Waiting for file upload to complete failed. " + MasterController.getDetailedMessage(e), (Throwable)e);
        }
        LOG.debug("Clean up file update");
        FileUtils.deleteQuietly((File)archiveFile);
    }

    private void pollForUpdateSuccess(Map<FileReplicationIndex, Set<AgentController>> remoteFileIndexes, ProgressBar progress) {
        LOG.info("Wait for update is done");
        Poll.poll(this.downloadExecutor, UPLOAD_POLL_TASK, AgentControllerUpdate.getUpdatingAgentControllers(remoteFileIndexes), this.failedAgentControllers, progress);
    }

    private static Collection<AgentController> getUpdatingAgentControllers(Map<FileReplicationIndex, Set<AgentController>> remoteFileIndexes) {
        HashMap<String, AgentController> stillUpdating = new HashMap<String, AgentController>();
        for (Set<AgentController> agentControllers : remoteFileIndexes.values()) {
            for (AgentController agentController : agentControllers) {
                stillUpdating.put(agentController.getName(), agentController);
            }
        }
        return stillUpdating.values();
    }

    public FailedAgentControllerCollection getFailedAgentControllers() {
        return this.failedAgentControllers;
    }

    private void logFileUpdate(List<File> filesToBeUpdated, List<File> filesToBeDeleted, Set<AgentController> agentControllers) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (AgentController agentController : agentControllers) {
            sb.append("\n -> ").append(agentController);
        }
        String modifiedAgentcontrollers = sb.toString();
        LOG.debug("Files to be deleted on agent controller(s): " + modifiedAgentcontrollers);
        for (File file : filesToBeDeleted) {
            LOG.debug(file.toString());
        }
        LOG.debug("Files to be updated on agent controller(s): " + modifiedAgentcontrollers);
        for (File file : filesToBeUpdated) {
            LOG.debug(file.toString());
        }
    }

    private void updateTotalAgentCount(final int totalAgentCount, final ProgressBar progress) throws AgentControllerException {
        final CountDownLatch latch = new CountDownLatch(this.agentControllers.size());
        for (final AgentController agentController : this.agentControllers) {
            this.uploadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        agentController.setTotalAgentCount(totalAgentCount);
                        progress.increaseCount();
                    }
                    catch (Exception ex) {
                        AgentControllerUpdate.this.failedAgentControllers.add(agentController, ex);
                        LOG.error("Failed updating total agent count at " + agentController, (Throwable)ex);
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Waiting for agent count update failed. " + MasterController.getDetailedMessage(e), e);
        }
    }

    private File archiveAgentFiles(List<File> filesToArchive, File rootDir) throws IOException {
        File[] files = new File[filesToArchive.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(rootDir, filesToArchive.get(i).getPath()).getCanonicalFile();
        }
        File zipFile = File.createTempFile("agentfiles-", ".zip", this.tempDirectory);
        zipFile.deleteOnExit();
        LOG.debug("Zipping agent files from '" + rootDir + "' to '" + zipFile + "' ...");
        FileListFileFilter fileListFileFilter = new FileListFileFilter(files);
        ZipUtils.zipDirectory(rootDir, fileListFileFilter, zipFile);
        return zipFile;
    }

    private int getTotalAgentCount() throws AgentControllerException {
        int totalAgentcount = 0;
        for (AgentController agentcontroller : this.agentControllers) {
            totalAgentcount += agentcontroller.getAgentCount();
        }
        return totalAgentcount;
    }
}

