/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.util.ConsoleUiUtils;
import com.xceptance.common.util.ProductInformation;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.AgentStatusInfo;
import com.xceptance.xlt.agentcontroller.ScenarioStatus;
import com.xceptance.xlt.agentcontroller.TestResultAmount;
import com.xceptance.xlt.agentcontroller.TestUserStatus;
import com.xceptance.xlt.mastercontroller.AgentControllerStatusInfo;
import com.xceptance.xlt.mastercontroller.AgentControllersInformation;
import com.xceptance.xlt.mastercontroller.MasterController;
import com.xceptance.xlt.mastercontroller.MasterControllerUI;
import com.xceptance.xlt.mastercontroller.ReportCreationType;
import com.xceptance.xlt.mastercontroller.TestCaseLoadProfileConfiguration;
import com.xceptance.xlt.mastercontroller.TestLoadProfileConfiguration;
import com.xceptance.xlt.util.AgentControllerException;
import com.xceptance.xlt.util.AgentControllerInfo;
import com.xceptance.xlt.util.FailedAgentControllerCollection;
import com.xceptance.xlt.util.StatusUtils;
import java.util.Arrays;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BasicConsoleUI
implements MasterControllerUI {
    private static final String COPYRIGHT = "Copyright (c) 2005-%s %s. All rights reserved.";
    private static final List<String> TEST_RESULT_AMOUNT_DISPLAY_NAMES = Arrays.asList(TestResultAmount.displayNames());
    private static final List<TestResultAmount> TEST_RESULT_AMOUNTS = Arrays.asList(TestResultAmount.values());
    private static final List<String> TEST_RESULT_SHORTCUTS = Arrays.asList(TestResultAmount.shortcuts());
    private static final List<String> REPORT_CREATION_TYPE_SHORTCUTS = Arrays.asList(ReportCreationType.shortcuts());
    private static final List<String> REPORT_CREATION_TYPE_DISPLAY_NAMES = Arrays.asList(ReportCreationType.displayNames());
    private static final List<ReportCreationType> REPORT_CREATION_TYPES = Arrays.asList(ReportCreationType.values());
    private static final String TIME_TOTALS = "/";
    private static final String SETTING_NOT_AVAILABLE = "n/a";
    private static final String OVERFLOW_ERROR = "#OUT OF RANGE#";
    protected final MasterController masterController;
    private int statusListUpdateInterval;

    public BasicConsoleUI(MasterController masterController) {
        this.masterController = masterController;
    }

    @Override
    public void agentFilesUploaded() {
        this.print();
    }

    @Override
    public void agentsStarted() {
        this.print();
    }

    @Override
    public void agentsStopped() {
        this.print();
    }

    @Override
    public void agentStatusReceived(FailedAgentControllerCollection results) {
        if (!results.isEmpty()) {
            for (Map.Entry<AgentController, Exception> result : results.getMap().entrySet()) {
                Exception ex = result.getValue();
                if (ex == null) continue;
                String msg = this.getUserFriendlyExceptionMessage(ex);
                System.out.println("Failed to get agent status from " + result.getKey() + " -> " + msg);
            }
            System.out.println();
        }
    }

    @Override
    public void downloadingTestResults() {
        System.out.print(" -> Downloading test results");
    }

    public boolean downloadTestResults(TestResultAmount testResultAmount) {
        boolean ok;
        if (testResultAmount == null) {
            testResultAmount = ConsoleUiUtils.selectItem("Select the data to be downloaded:", TEST_RESULT_SHORTCUTS, TEST_RESULT_AMOUNT_DISPLAY_NAMES, TEST_RESULT_AMOUNTS);
            System.out.println();
        }
        boolean bl = ok = !TestResultAmount.CANCEL.equals((Object)testResultAmount);
        if (ok) {
            System.out.println("Downloading test results... Please be patient, it might take some time...");
            ok = this.masterController.downloadTestResults(testResultAmount);
            System.out.println();
            if (ok) {
                this.handleTestComment();
                System.out.println("\nResults have been downloaded to: " + this.masterController.getCurrentTestResultsDirectory());
            }
        }
        return ok;
    }

    public boolean generateReport() {
        return this.generateReport(null);
    }

    public boolean generateReport(ReportCreationType reportCreationType) {
        boolean result = false;
        if (reportCreationType == null) {
            reportCreationType = ConsoleUiUtils.selectItem("Would you like to include the ramp-up period in the test report?", REPORT_CREATION_TYPE_SHORTCUTS, REPORT_CREATION_TYPE_DISPLAY_NAMES, REPORT_CREATION_TYPES);
            System.out.println();
        }
        if (!reportCreationType.equals((Object)ReportCreationType.ABORT)) {
            System.out.println("Generating load test report based on latest download...");
            result = this.masterController.generateReport(reportCreationType);
            if (!result) {
                System.out.println(" -> Failed");
            }
            System.out.println();
        }
        return result;
    }

    @Override
    public int getStatusListUpdateInterval() {
        return this.statusListUpdateInterval;
    }

    public boolean isLoadTestRunning() {
        try {
            if (this.masterController.isAnyAgentRunning()) {
                System.out.println("-> WARNING: Unable to execute command because a test is currently running.");
                return true;
            }
        }
        catch (AgentControllerException e) {
            System.out.println("-> WARNING: Unable to execute command because at least one agent controller cannot be reached.");
            return true;
        }
        return false;
    }

    public void printAgentStatusList() {
        List<AgentControllerStatusInfo> agentControllerStatusList = this.masterController.getAgentControllerStatusList();
        Map<String, List<AgentStatusInfo>> failedAgentsByHost = StatusUtils.getFailedAgentsByHost(agentControllerStatusList);
        List<ScenarioStatus> scenarioStatusList = StatusUtils.aggregateScenarioStatusLists(agentControllerStatusList);
        if (!scenarioStatusList.isEmpty()) {
            int maxNameLength = 9;
            for (ScenarioStatus scenarioStatus : scenarioStatusList) {
                maxNameLength = Math.max(maxNameLength, scenarioStatus.getUserName().length());
            }
            StringBuilder buf = new StringBuilder();
            Formatter formatter = new Formatter(buf);
            String headerFormat = "%-" + maxNameLength + "s   State         Running Users   Iterations   Last Time   Avg. Time   Elapsed Time      Events          Errors   Progress\n";
            formatter.format(headerFormat, "Test Case");
            String separatorLineFormat = "%s   --------   ----------------   ----------   ---------   ---------   ------------   ---------   -------------   --------\n";
            formatter.format("%s   --------   ----------------   ----------   ---------   ---------   ------------   ---------   -------------   --------\n", StringUtils.repeat((String)"-", (int)maxNameLength));
            String format = "%-" + maxNameLength + "s   %-8s   %,6d of %,6d   %,10d   %9s   %9s     %10s   %,9d   %,6d %6s   %7d%%\n";
            String timeFormat = "%,7.2f s";
            String failedFormat = "%-" + maxNameLength + "s   %-8s   %s\n";
            for (ScenarioStatus scenarioStatus : scenarioStatusList) {
                if (scenarioStatus.getState() == TestUserStatus.State.Failed) {
                    formatter.format(failedFormat, new Object[]{scenarioStatus.getUserName(), scenarioStatus.getState(), scenarioStatus.getException()});
                    continue;
                }
                String elapsedTime = this.formatTime(scenarioStatus.getElapsedTime());
                int errorRate = 0;
                if (scenarioStatus.getIterations() > 0) {
                    errorRate = Math.round((float)scenarioStatus.getErrors() * 100.0f / (float)scenarioStatus.getIterations());
                }
                double lastRuntime = (double)scenarioStatus.getLastRuntime() / 1000.0;
                double avgRuntime = (double)scenarioStatus.getAverageRuntime() / 1000.0;
                formatter.format(format, new Object[]{scenarioStatus.getUserName(), scenarioStatus.getState(), scenarioStatus.getRunningUsers(), scenarioStatus.getTotalUsers(), scenarioStatus.getIterations(), String.format("%,7.2f s", lastRuntime), String.format("%,7.2f s", avgRuntime), elapsedTime, scenarioStatus.getEvents(), scenarioStatus.getErrors(), "(" + errorRate + "%)", scenarioStatus.getPercentageComplete()});
            }
            if (scenarioStatusList.size() > 1) {
                ScenarioStatus summaryStatus = StatusUtils.getTotalScenarioStatus(scenarioStatusList);
                String elapsedTime = this.formatTime(summaryStatus.getElapsedTime());
                int iterations = summaryStatus.getIterations();
                int errors = summaryStatus.getErrors();
                int errorRate = iterations > 0 ? Math.round((float)errors * 100.0f / (float)iterations) : 0;
                formatter.format("%s   --------   ----------------   ----------   ---------   ---------   ------------   ---------   -------------   --------\n", StringUtils.repeat((String)"-", (int)maxNameLength));
                formatter.format(format, new Object[]{summaryStatus.getUserName(), summaryStatus.getState(), summaryStatus.getRunningUsers(), summaryStatus.getTotalUsers(), iterations, TIME_TOTALS, TIME_TOTALS, elapsedTime, summaryStatus.getEvents(), errors, "(" + errorRate + "%)", summaryStatus.getPercentageComplete()});
            }
            formatter.close();
            System.out.println(buf);
        }
        if (!failedAgentsByHost.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            sb.append("->  Agent(s) exited unexpectedly:\n");
            for (Map.Entry<String, List<AgentStatusInfo>> failedAgentsEntry : failedAgentsByHost.entrySet()) {
                sb.append("  - ").append(failedAgentsEntry.getKey()).append("\n");
                List<AgentStatusInfo> failedAgents = failedAgentsEntry.getValue();
                for (AgentStatusInfo failedAgent : failedAgents) {
                    sb.append("        Agent '").append(failedAgent.getAgentID()).append("' returned with exit code '").append(failedAgent.getExitCode()).append("'\n");
                }
                count += failedAgents.size();
            }
            sb.insert(3, Integer.toString(count));
            System.out.println(sb.toString());
        }
    }

    public void printLoadTestSettings() {
        String output = this.getLoadTestSettings(this.masterController.getCurrentLoadProfile());
        if (!StringUtils.isBlank((CharSequence)output)) {
            System.out.println();
            System.out.println("Load Profile");
            System.out.println(output);
        }
    }

    String getLoadTestSettings(TestLoadProfileConfiguration loadTestSettings) {
        StringBuilder configLine = new StringBuilder();
        if (loadTestSettings != null) {
            Formatter formatter = new Formatter(configLine);
            String testCaseColumnHeading = "Test Case";
            String arrivalRateColumnHeading = "Arrival Rate [eff]";
            String usersColumnHeading = "Users [eff]";
            String loadFactorColumnHeading = "Load Factor";
            String measurementPeriodColumnHeading = "Measurement Period";
            String colSep = " | ";
            Map<String, Integer> maxLengthMap = this.getColumnBoundaries(loadTestSettings);
            int maxNameLength = Math.max(maxLengthMap.get("testCases"), "Test Case".length());
            int arrivalLength = Math.max(maxLengthMap.get("arrivalRate"), "Arrival Rate [eff]".length());
            int maxUserLength = Math.max(maxLengthMap.get("users"), "Users [eff]".length());
            int maxLoadFactor = Math.max(maxLengthMap.get("loadFactor"), "Load Factor".length());
            int measureLength = "Measurement Period".length();
            int totalLength = maxNameLength + arrivalLength + maxUserLength + maxLoadFactor + measureLength + 4 * " | ".length();
            String lineFormat = StringUtils.joinWith((String)" | ", (Object[])new Object[]{"%s", "%s", "%s", "%s", "%s\n"});
            String dashLine = StringUtils.repeat((String)"-", (int)totalLength);
            formatter.format("%s\n", dashLine);
            formatter.format(lineFormat, StringUtils.center((String)"Test Case", (int)maxNameLength), StringUtils.center((String)"Arrival Rate [eff]", (int)arrivalLength), StringUtils.center((String)"Users [eff]", (int)maxUserLength), StringUtils.center((String)"Load Factor", (int)maxLoadFactor), StringUtils.center((String)"Measurement Period", (int)measureLength));
            formatter.format("%s\n", dashLine);
            int arrivalRateSum = 0;
            int numberOfUsersSum = 0;
            int measurementPeriodMaximum = 0;
            String previousLoadFactor = "";
            boolean sameLoadFactor = true;
            boolean arrivalRateOverflow = false;
            boolean userOverflow = false;
            for (TestCaseLoadProfileConfiguration settings : loadTestSettings.getLoadTestConfiguration()) {
                String loadFactor;
                Pair<Integer, Integer> boundaries = this.getMinMaxValue(settings.getArrivalRate());
                if (!arrivalRateOverflow && boundaries != null) {
                    try {
                        arrivalRateSum = Math.addExact(arrivalRateSum, (Integer)boundaries.getRight());
                    }
                    catch (ArithmeticException e) {
                        arrivalRateOverflow = true;
                    }
                }
                String arrivalRate = this.getIntRangeAsString(boundaries);
                boundaries = this.getMinMaxValue(settings.getNumberOfUsers());
                if (!userOverflow && boundaries != null) {
                    try {
                        numberOfUsersSum = Math.addExact(numberOfUsersSum, (Integer)boundaries.getRight());
                    }
                    catch (ArithmeticException e) {
                        userOverflow = true;
                    }
                }
                String users = this.getIntRangeAsString(boundaries);
                boundaries = this.getMinMaxValue(settings.getLoadFactor());
                if (boundaries != null) {
                    double minLoadFactorFraction = (double)((Integer)boundaries.getLeft()).intValue() / 1000.0;
                    double maxLoadFactorFraction = (double)((Integer)boundaries.getRight()).intValue() / 1000.0;
                    loadFactor = this.getDoubleRangeAsString((Pair<Double, Double>)new MutablePair((Object)minLoadFactorFraction, (Object)maxLoadFactorFraction));
                } else {
                    loadFactor = this.getDoubleRangeAsString(null);
                }
                if (sameLoadFactor) {
                    if (StringUtils.isEmpty((CharSequence)previousLoadFactor)) {
                        previousLoadFactor = loadFactor;
                    } else {
                        sameLoadFactor = previousLoadFactor.equals(loadFactor);
                    }
                }
                int measurementPeriod = settings.getMeasurementPeriod();
                measurementPeriodMaximum = Math.max(measurementPeriod, measurementPeriodMaximum);
                formatter.format(lineFormat, StringUtils.rightPad((String)settings.getUserName(), (int)maxNameLength), StringUtils.leftPad((String)arrivalRate, (int)arrivalLength), StringUtils.leftPad((String)users, (int)maxUserLength), StringUtils.leftPad((String)loadFactor, (int)maxLoadFactor), StringUtils.leftPad((String)this.convertSecondsToTime(measurementPeriod), (int)measureLength));
            }
            formatter.format("%s\n", StringUtils.repeat((String)"-", (int)totalLength));
            int firstColWidth = arrivalLength + maxNameLength + " | ".length();
            if (!arrivalRateOverflow) {
                formatter.format("%," + firstColWidth + "d | ", arrivalRateSum);
            } else {
                formatter.format("%" + Math.max(firstColWidth, OVERFLOW_ERROR.length()) + "s | ", OVERFLOW_ERROR);
            }
            if (!userOverflow) {
                formatter.format("%," + maxUserLength + "d | ", numberOfUsersSum);
            } else {
                formatter.format("%" + Math.max(maxUserLength, OVERFLOW_ERROR.length()) + "s | ", OVERFLOW_ERROR);
            }
            formatter.format("%" + maxLoadFactor + "s | ", sameLoadFactor ? previousLoadFactor : " ");
            formatter.format("%" + measureLength + "s\n", this.convertSecondsToTime(measurementPeriodMaximum));
            formatter.close();
        }
        return configLine.toString();
    }

    private String convertSecondsToTime(long seconds) {
        if ((seconds = Math.abs(seconds)) > 0L) {
            long rem = seconds % 3600L;
            return String.format("%d:%02d:%02d", seconds / 3600L, rem / 60L, rem % 60L);
        }
        return "0:00:00";
    }

    private Pair<Integer, Integer> getMinMaxValue(int[][] pairs) {
        if (pairs == null || pairs.length == 0 || pairs[0].length == 1) {
            return null;
        }
        int min = pairs[0][1];
        int max = pairs[0][1];
        for (int i = 1; i < pairs.length; ++i) {
            int val = pairs[i][1];
            min = Math.min(min, val);
            max = Math.max(max, val);
        }
        return new ImmutablePair((Object)min, (Object)max);
    }

    private Map<String, Integer> getColumnBoundaries(TestLoadProfileConfiguration loadTestSettings) {
        int maxTestCaseLength = 0;
        int maxArrivalRateLength = 0;
        int maxUsersLength = 0;
        int maxLoadFactor = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (TestCaseLoadProfileConfiguration profile : loadTestSettings.getLoadTestConfiguration()) {
            maxTestCaseLength = Math.max(maxTestCaseLength, profile.getUserName().length());
            maxArrivalRateLength = Math.max(maxArrivalRateLength, this.getIntRangeAsString(this.getMinMaxValue(profile.getArrivalRate())).length());
            maxUsersLength = Math.max(maxUsersLength, this.getIntRangeAsString(this.getMinMaxValue(profile.getNumberOfUsers())).length());
            Pair<Integer, Integer> loadFactorPair = this.getMinMaxValue(profile.getLoadFactor());
            if (loadFactorPair != null) {
                double min = (double)((Integer)loadFactorPair.getLeft()).intValue() / 1000.0;
                double max = (double)((Integer)loadFactorPair.getRight()).intValue() / 1000.0;
                maxLoadFactor = Math.max(maxLoadFactor, this.getDoubleRangeAsString((Pair<Double, Double>)new ImmutablePair((Object)min, (Object)max)).length());
                continue;
            }
            maxLoadFactor = Math.max(maxLoadFactor, this.getDoubleRangeAsString(null).length());
        }
        map.put("testCases", maxTestCaseLength);
        map.put("arrivalRate", maxArrivalRateLength);
        map.put("users", maxUsersLength);
        map.put("loadFactor", maxLoadFactor);
        return map;
    }

    private String getIntRangeAsString(Pair<Integer, Integer> pair) {
        int max;
        if (pair == null) {
            return SETTING_NOT_AVAILABLE;
        }
        int min = (Integer)pair.getLeft();
        return min == (max = ((Integer)pair.getRight()).intValue()) ? String.format("%,d", max) : String.format("%,d..%,d", min, max);
    }

    private String getDoubleRangeAsString(Pair<Double, Double> pair) {
        double max;
        if (pair == null) {
            return SETTING_NOT_AVAILABLE;
        }
        double min = (Double)pair.getLeft();
        return min == (max = ((Double)pair.getRight()).doubleValue()) ? String.format("%,.3f", max) : String.format("%,.3f..%,.3f", min, max);
    }

    public void printXltInfo() {
        ProductInformation info = ProductInformation.getProductInformation();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(info.getBuildDate());
        int year = cal.get(1);
        String productInfo = info.getProductIdentifier();
        String copyright = String.format(COPYRIGHT, year, info.getVendorName());
        String licenseInfo = "XLT is Open Source and available under the Apache License 2.0.";
        System.out.printf("\n%s\n%s\n%s\n\n", productInfo, copyright, "XLT is Open Source and available under the Apache License 2.0.");
    }

    public void printAgentControllerPreCheckInformation() {
        System.out.print("\nChecking for agent controller reachability and XLT version conflicts ... ");
        AgentControllersInformation agentControllerInfos = this.masterController.getAgentControllerInformation();
        StringBuilder sb = new StringBuilder();
        if (agentControllerInfos.hasErrors()) {
            sb.append("\n\n");
            sb.append("WARNING: At least one agent controller is unreachable.\n\n");
            for (AgentControllerInfo agentControllerInfo : agentControllerInfos.getAgentControllerInformation()) {
                Exception ex = agentControllerInfo.getException();
                if (ex == null) continue;
                sb.append(" -> ").append(agentControllerInfo.getName()).append(": ").append(this.getUserFriendlyExceptionMessage(agentControllerInfo.getException())).append('\n');
            }
        } else if (agentControllerInfos.hasXltVersionConflict()) {
            sb.append("\n\n");
            sb.append("WARNING: Master controller and agent controllers run different XLT versions.\n");
            sb.append("         Master controller version: ").append(ProductInformation.getProductInformation().getCondensedProductIdentifier()).append('\n');
        } else {
            sb.append("OK\n");
        }
        System.out.println(sb.toString());
    }

    @Override
    public void receivingAgentStatus() {
    }

    public abstract void run();

    public void setStatusListUpdateInterval(int statusListUpdateInterval) {
        this.statusListUpdateInterval = statusListUpdateInterval;
    }

    public boolean startAgents(String testCaseName, boolean checkTestSuiteUploaded) {
        if (!checkTestSuiteUploaded || this.masterController.areAgentsInSync()) {
            System.out.println("Starting agents... ");
            boolean result = false;
            try {
                result = this.masterController.startAgents(testCaseName);
            }
            catch (AgentControllerException e) {
                this.print(e.getFailed());
            }
            catch (Exception e) {
                this.print(e);
            }
            System.out.println();
            return result;
        }
        System.out.println("The test suite has to be uploaded before a test can be started.\n");
        return false;
    }

    @Override
    public void startingAgents() {
        System.out.print("Starting agents... ");
    }

    public boolean stopAgents() {
        System.out.println("Aborting agents... ");
        boolean result = false;
        try {
            result = this.masterController.stopAgents();
        }
        catch (AgentControllerException e) {
            this.print(e.getFailed());
        }
        System.out.println();
        return result;
    }

    @Override
    public void stoppingAgents() {
        System.out.print("Stopping agents... ");
    }

    @Override
    public void testResultsDownloaded(FailedAgentControllerCollection results) {
        this.print(results);
    }

    public boolean uploadAgentFiles() {
        boolean result = false;
        System.out.println("Uploading test suite... ");
        try {
            this.masterController.updateAgentFiles();
            result = true;
        }
        catch (AgentControllerException e) {
            this.print(e.getFailed());
        }
        catch (Exception t) {
            this.print(t);
        }
        System.out.println();
        return result;
    }

    @Override
    public void uploadingAgentFiles() {
        System.out.print(" -> Uploading agent files... ");
    }

    @Override
    public void skipAgentControllerConnections(FailedAgentControllerCollection unconnectedAgentControllers) {
        if (!unconnectedAgentControllers.isEmpty()) {
            System.out.println("\n-> WARNING: Skipped unreachable agent controllers:");
            for (AgentController agentcontroller : unconnectedAgentControllers.getAgentControllers()) {
                System.out.println("   SKIPPED " + agentcontroller);
            }
        }
    }

    protected void handleTestComment() {
        this.masterController.setTestComment4DownloadedResults();
    }

    private String formatTime(long time) {
        String sign = "";
        if (time < 0L) {
            sign = "-";
            time = -time;
        }
        long timeInSecs = time / 1000L;
        long timeInMins = timeInSecs / 60L;
        long timeInHours = timeInMins / 60L;
        long secs = timeInSecs % 60L;
        long mins = timeInMins % 60L;
        long hours = timeInHours;
        return String.format("%s%d:%02d:%02d", sign, hours, mins, secs);
    }

    private String buildFailureList(FailedAgentControllerCollection results) {
        StringBuilder failed = new StringBuilder();
        for (Map.Entry<AgentController, Exception> result : results.getMap().entrySet()) {
            failed.append(" -> " + result.getKey());
            Exception ex = result.getValue();
            if (ex != null) {
                String msg = this.getUserFriendlyExceptionMessage(ex);
                failed.append(" - " + msg);
            }
            failed.append("\n");
        }
        return failed.toString();
    }

    protected String getUserFriendlyExceptionMessage(Exception ex) {
        String msg = StringUtils.defaultString((String)ex.getMessage());
        if (msg.startsWith("401:")) {
            msg = "Authentication failed. The agent controller rejected the master controller's password.";
        }
        return msg;
    }

    private void print(FailedAgentControllerCollection results) {
        StringBuilder failed = new StringBuilder();
        if (results != null && results.getMap().size() > 0) {
            failed.append("- FAILED!\n\n");
            failed.append(this.buildFailureList(results));
            System.out.println(failed);
        } else {
            System.out.println("- OK");
        }
    }

    private void print(Exception e) {
        System.out.println("- FAILED: " + e.getMessage());
    }

    private void print() {
        this.print((FailedAgentControllerCollection)null);
    }

    protected boolean checkAlive() {
        try {
            this.masterController.checkAlive();
            return true;
        }
        catch (AgentControllerException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("WARNING: Unable to execute this command because at least one agent controller is unreachable:\n\n");
            sb.append(this.buildFailureList(e.getFailed()));
            System.out.println(sb);
        }
        catch (IllegalStateException e) {
            System.out.println("WARNING: Unable to execute this command: " + e.getMessage());
        }
        return false;
    }
}

