/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.util.zip.ZipUtils;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.agentcontroller.TestResultAmount;
import com.xceptance.xlt.agentcontroller.TestUserStatus;
import com.xceptance.xlt.mastercontroller.MasterController;
import com.xceptance.xlt.mastercontroller.Poll;
import com.xceptance.xlt.mastercontroller.TestLoadProfileConfiguration;
import com.xceptance.xlt.util.FailedAgentControllerCollection;
import com.xceptance.xlt.util.ProgressBar;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(ResultDownloader.class);
    private final ThreadPoolExecutor downloadExecutor;
    private final File testResultsDir;
    private final File tempDirectory;
    private final FailedAgentControllerCollection failedAgentControllers;
    private final ProgressBar progress;
    private final List<AgentController> agentControllers;

    public ResultDownloader(ThreadPoolExecutor downloadExecutor, File testResultsDir, File tempDirectory, ArrayList<AgentController> agentControllers, ProgressBar progress) {
        this.downloadExecutor = downloadExecutor;
        this.testResultsDir = testResultsDir;
        this.tempDirectory = tempDirectory;
        this.progress = progress;
        this.agentControllers = agentControllers;
        this.failedAgentControllers = new FailedAgentControllerCollection();
    }

    public boolean download(TestResultAmount testResultAmount, boolean compressedTimerFiles) {
        FileObject testPropFile;
        boolean testConfigDownloaded = this.getRemoteTestConfig();
        boolean timeDataUpdated = false;
        if (testConfigDownloaded && (testPropFile = MasterController.getTestPropertyFile(this.testResultsDir)) != null) {
            timeDataUpdated = this.updateTimeData(testPropFile);
        }
        this.archiveResults(testResultAmount);
        boolean resultsDownloaded = this.downloadResults(compressedTimerFiles);
        return resultsDownloaded && testConfigDownloaded && timeDataUpdated;
    }

    private boolean getRemoteTestConfig() {
        Set<File> tempTestConfigs = this.downloadTestConfig();
        boolean unzipped = this.unzipTestConfig(tempTestConfigs);
        return unzipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> downloadTestConfig() {
        final Set<File> tempTestConfigs = Collections.synchronizedSet(new HashSet());
        final CountDownLatch latch = new CountDownLatch(this.agentControllers.size());
        final AtomicBoolean callFailed = new AtomicBoolean();
        for (final AgentController agentController : this.agentControllers) {
            this.downloadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    LOG.info(agentController + ": Download test configuration");
                    try {
                        if (tempTestConfigs.isEmpty()) {
                            tempTestConfigs.add(ResultDownloader.this.downloadConfiguration(agentController));
                            LOG.info(agentController + ": Download test configuration OK");
                        }
                    }
                    catch (Exception e) {
                        ResultDownloader.this.failedAgentControllers.add(agentController, e);
                        LOG.error("Failed downloading test configuration", (Throwable)e);
                        callFailed.set(true);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Waiting for download of test configuration has failed", (Throwable)e);
        }
        finally {
            if (callFailed.get()) {
                this.removeFailedControllers();
            }
        }
        if (!tempTestConfigs.isEmpty()) {
            this.progress.increaseCount();
        }
        return tempTestConfigs;
    }

    private void removeFailedControllers() {
        Iterator<AgentController> it = this.agentControllers.iterator();
        Set<AgentController> failed = this.failedAgentControllers.getAgentControllers();
        while (it.hasNext()) {
            AgentController ac = it.next();
            if (!failed.contains(ac)) continue;
            it.remove();
            LOG.debug(ac.getName() + ": Removed from list of used controllers.");
        }
    }

    private boolean unzipTestConfig(Set<File> tempTestConfigs) {
        LOG.debug("Unzipping test configuration ...");
        boolean unzipped = false;
        for (File tempTestConfigFile : tempTestConfigs) {
            try {
                ZipUtils.unzipFile(tempTestConfigFile, this.testResultsDir);
                LOG.debug("Finished unzipping of test configuration");
                unzipped = true;
                break;
            }
            catch (IOException iOException) {
            }
        }
        this.progress.increaseCount();
        LOG.debug("Clean up ... ");
        for (File tempTestConfigFile : tempTestConfigs) {
            FileUtils.deleteQuietly((File)tempTestConfigFile);
        }
        this.progress.increaseCount();
        return unzipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getTimeData(final AtomicLong startDate, final AtomicLong elapsedTime) {
        LOG.info("Query earliest start date and highest elapsed time");
        final CountDownLatch latch = new CountDownLatch(this.agentControllers.size());
        final AtomicBoolean callFailed = new AtomicBoolean();
        for (final AgentController agentController : this.agentControllers) {
            this.downloadExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        long earliestTestUserStartDate = Long.MAX_VALUE;
                        long highestTestUserElapsedTime = 0L;
                        Set<AgentStatus> agentStatuses = agentController.getAgentStatus();
                        if (agentStatuses != null) {
                            for (AgentStatus agentStatus : agentStatuses) {
                                for (TestUserStatus testUserStatus : agentStatus.getTestUserStatusList()) {
                                    long userElapsedTime;
                                    long userStartDate = testUserStatus.getStartDate();
                                    if (userStartDate < earliestTestUserStartDate) {
                                        earliestTestUserStartDate = userStartDate;
                                    }
                                    if ((userElapsedTime = testUserStatus.getElapsedTime()) <= highestTestUserElapsedTime) continue;
                                    highestTestUserElapsedTime = userElapsedTime;
                                }
                            }
                        }
                        Object object = startDate;
                        synchronized (object) {
                            if (earliestTestUserStartDate < startDate.get()) {
                                startDate.set(earliestTestUserStartDate);
                            }
                        }
                        object = elapsedTime;
                        synchronized (object) {
                            if (highestTestUserElapsedTime > elapsedTime.get()) {
                                elapsedTime.set(highestTestUserElapsedTime);
                            }
                        }
                    }
                    catch (Exception e) {
                        ResultDownloader.this.failedAgentControllers.add(agentController, e);
                        callFailed.set(true);
                    }
                    finally {
                        ResultDownloader.this.progress.increaseCount();
                        latch.countDown();
                    }
                }
            });
        }
        boolean finished = true;
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Waiting retrieving time data has failed", (Throwable)e);
            finished = false;
        }
        finally {
            if (callFailed.get()) {
                this.removeFailedControllers();
            }
        }
        return finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveResults(final TestResultAmount testResultAmount) {
        LOG.info("Archive results");
        final AtomicBoolean callFailed = new AtomicBoolean();
        final CountDownLatch latch = new CountDownLatch(this.agentControllers.size());
        for (final AgentController agentController : this.agentControllers) {
            this.downloadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOG.debug("Archive results at " + agentController);
                        agentController.archiveAgentResults(testResultAmount);
                    }
                    catch (Exception e) {
                        ResultDownloader.this.failedAgentControllers.add(agentController, e);
                        LOG.debug("Archive results FAILED at " + agentController);
                        callFailed.set(true);
                    }
                    finally {
                        latch.countDown();
                        ResultDownloader.this.progress.increaseCount();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Failure");
        }
        finally {
            if (callFailed.get()) {
                this.removeFailedControllers();
            }
        }
    }

    private boolean downloadResults(final boolean compressedTimerFiles) {
        LOG.debug("Download results");
        try {
            boolean bl = Poll.poll(this.downloadExecutor, new Poll.AgentControllerPollingTask(){

                @Override
                public boolean call(AgentController agentController) throws Exception {
                    if (agentController.isArchiveAvailable()) {
                        LOG.debug("Downloading results from " + agentController);
                        ResultDownloader.this.downloadTestResults(agentController, compressedTimerFiles);
                        LOG.debug("Downloading results from " + agentController + " OK");
                        return true;
                    }
                    return false;
                }
            }, this.agentControllers, this.failedAgentControllers, this.progress);
            return bl;
        }
        finally {
            this.removeFailedControllers();
        }
    }

    private boolean updateTimeData(FileObject testPropFile) {
        boolean timeDataUpdated;
        block8: {
            AtomicLong startDate = new AtomicLong(Long.MAX_VALUE);
            AtomicLong elapsedTime = new AtomicLong(0L);
            boolean downloadedTimeData = this.getTimeData(startDate, elapsedTime);
            long totalRampUpPeriod = this.getTotalRampUpPeriod();
            LOG.debug("Set start date and elapsed time to test configuration ...");
            timeDataUpdated = false;
            try {
                if (!downloadedTimeData || !testPropFile.exists() || !testPropFile.isFile()) break block8;
                long startTime = startDate.get();
                long elapsed = elapsedTime.get();
                if (startTime > 0L && startTime < Long.MAX_VALUE) {
                    try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(testPropFile.getContent().getOutputStream(true), StandardCharsets.ISO_8859_1));){
                        w.newLine();
                        w.newLine();
                        w.write("# start date / elapsed time / total ramp-up time (AUTOMATICALLY INSERTED)");
                        w.newLine();
                        w.write("com.xceptance.xlt.loadtest.start = " + startTime);
                        w.newLine();
                        w.write("com.xceptance.xlt.loadtest.elapsed = " + elapsed);
                        w.newLine();
                        w.write("com.xceptance.xlt.loadtest.rampUp = " + totalRampUpPeriod);
                        w.newLine();
                    }
                }
                timeDataUpdated = true;
            }
            catch (IOException e) {
                LOG.error("Failed adding runtime information to file '" + testPropFile.getPublicURIString() + "'.", (Throwable)e);
            }
        }
        this.progress.increaseCount();
        return timeDataUpdated;
    }

    private long getTotalRampUpPeriod() {
        File configDir = new File(this.testResultsDir, "config");
        XltPropertiesImpl properties = TestLoadProfileConfiguration.readProperties(configDir.getParentFile(), configDir);
        TestLoadProfileConfiguration loadProfileConfig = new TestLoadProfileConfiguration(properties);
        return loadProfileConfig.getTotalRampUpPeriod() * 1000L;
    }

    private void downloadTestResults(AgentController agentController, boolean compressedTimerFiles) throws IOException {
        HashMap<String, File> downloadedZipFiles = new HashMap<String, File>();
        LOG.info("Downloading test results files from " + agentController);
        Map<String, String> remoteZipFileNames = agentController.getAgentResultsArchives();
        this.progress.increaseCount();
        String tempResultsPrefix = "testresults-";
        for (Map.Entry<String, String> remoteAgentResultFile : remoteZipFileNames.entrySet()) {
            String agentID = remoteAgentResultFile.getKey();
            String remoteZipFileName = remoteAgentResultFile.getValue();
            File zipFile = File.createTempFile("testresults-" + agentID + "-", ".zip", this.tempDirectory);
            zipFile.deleteOnExit();
            agentController.getFileManager().downloadFile(zipFile, remoteZipFileName);
            downloadedZipFiles.put(agentID, zipFile);
        }
        this.progress.increaseCount();
        LOG.debug("Unzipping test results files ...");
        for (Map.Entry downloadedZipFile : downloadedZipFiles.entrySet()) {
            String agentID = (String)downloadedZipFile.getKey();
            File zipFile = (File)downloadedZipFile.getValue();
            File agentResultsDir = new File(this.testResultsDir, agentID);
            LOG.debug("Unzipping '" + zipFile + "' to '" + agentResultsDir + "' ...");
            ZipUtils.unzipFile(zipFile, agentResultsDir, compressedTimerFiles);
        }
        this.progress.increaseCount();
        LOG.debug("cleanup agent controller test results archive files ...");
        agentController.archiveDownloadDone();
        LOG.debug("cleanup master controller test results archive files ...");
        for (File zipFile : downloadedZipFiles.values()) {
            FileUtils.deleteQuietly((File)zipFile);
        }
        LOG.info("Finished downloading test results files from " + agentController);
        this.progress.increaseCount();
    }

    private File downloadConfiguration(AgentController agentController) throws IOException {
        LOG.debug("Archiving test configuration ...");
        String remoteZipFileName = agentController.archiveTestConfig();
        File tempConfigZip = File.createTempFile("testconfig-", ".zip", this.tempDirectory);
        tempConfigZip.deleteOnExit();
        LOG.debug("Downloading test configuration archive ...");
        if (remoteZipFileName != null) {
            agentController.getFileManager().downloadFile(tempConfigZip, remoteZipFileName);
        }
        return tempConfigZip;
    }

    public FailedAgentControllerCollection getFailedAgentControllerCollection() {
        return this.failedAgentControllers;
    }
}

